/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentCancelPayRecValidator
extends AbstractValidator {
    public void validate() {
        Set ids = ((Stream)Arrays.stream(this.dataEntities).parallel()).map(d -> d.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection list = QueryServiceHelper.query((String)"cas_recbill", (String)"id,sourcebillid,billstatus", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", ids)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)list)) {
            Map<Long, List<DynamicObject>> dataGroup = list.parallelStream().collect(Collectors.groupingBy(d -> d.getLong("sourcebillid")));
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                Long payBillId = dataEntity.getDataEntity().getLong("id");
                List<DynamicObject> recBills = dataGroup.get(payBillId);
                if (!EmptyUtil.isNoEmpty(recBills)) continue;
                for (DynamicObject recBill : recBills) {
                    if ("A".equals(recBill.getString("billstatus"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u6536\u6b3e\u5355\u5355\u636e\u72b6\u6001\u975e\u6682\u5b58\u3002", (String)"PayPushIfmCancelValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

