/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.opservice.factory.PaymentBillFactory;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.EBErrorCode;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentChargeBackValidator
extends AbstractValidator {
    public void validate() throws KDBizException {
        EBErrorCode ebErrorCode = new EBErrorCode();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String billStatus;
            DynamicObject info = dataEntity.getDataEntity();
            long orgId = (Long)info.getDynamicObject("org").getPkValue();
            Set cs108 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs108");
            if (!cs108.contains(billStatus = info.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_STATUS_ERROR().getMessage());
                continue;
            }
            if (EmptyUtil.isNoEmpty((Object)info.get("entrustorg")) && info.getBigDecimal("entrustamt").compareTo(BigDecimal.ZERO) != 0) {
                String entrustMsg = ResManager.loadKDString((String)"\u5355\u636e[%s]\u5df2\u751f\u6210\u59d4\u6258\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u9000\u5355\uff0c\u8bf7\u53d6\u6d88\u59d4\u6258\u6216\u5c06\u59d4\u6258\u4ed8\u6b3e\u5355\u9000\u5355\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentChargeBackValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(entrustMsg, info.getString("billno")));
                continue;
            }
            if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
                PaymentBillFactory.getUnSubmitService().validate(info);
            } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                PaymentBillFactory.getUnAuditService().validate(info);
            }
            String sourcebilltype = info.getString("sourcebilltype");
            if (CasHelper.isEmpty((Object)sourcebilltype)) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_NO_LINK().getMessage());
            }
            if ("cas_recbill".equals(sourcebilltype)) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_NO_CASREC().getMessage());
            }
            if ("bei_intelpay".equals(sourcebilltype)) {
                this.addErrorMessage(dataEntity, ebErrorCode.BACK_NO_BEI_INTELPAY().getMessage());
            }
            OperateOption option = this.getOption();
            WriteBackServiceImpl.getInstance().setOption(option);
            String msg = WriteBackServiceImpl.getInstance().validate(info, WriteBackOperateEnum.CHARGEBACKVALIDATE, PaymentDisposeConsumer.class, info.getString("sourcebilltype"));
            WriteBackServiceImpl.getInstance().setOption(null);
            if (!EmptyUtil.isNoEmpty((String)msg)) continue;
            this.addMessage(dataEntity, msg);
        }
    }
}

