/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PayBillCrossHelper;

public class PaymentSynSaveValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentSynSaveValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billtype");
        preparePropertys.add("payeracctbank");
        preparePropertys.add("payeeacctbank");
        return preparePropertys;
    }

    public void validate() {
        HashSet<Long> accBankIds = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long payeeAcctBank;
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            if (CasHelper.isNotEmpty((Object)payerAcctBank)) {
                accBankIds.add(payerAcctBank.getLong("id"));
            }
            if (!CasHelper.isNotEmpty((Object)(payeeAcctBank = info.getLong("payeeacctbank")))) continue;
            accBankIds.add(payeeAcctBank);
        }
        Set ifmAccIds = PayBillCrossHelper.getIfmAccIds(accBankIds);
        for (ExtendedDataEntity data : this.dataEntities) {
            String sourceBillType;
            DynamicObject info = data.getDataEntity();
            DynamicObject billType = info.getDynamicObject("billtype");
            DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
            boolean isPayerInnerAcc = CasHelper.isEmpty((Object)payerAcctBank) ? false : ifmAccIds.contains(payerAcctBank.getLong("id"));
            long payeeAcctBank = info.getLong("payeeacctbank");
            boolean isPayeeInnerAcc = ifmAccIds.contains(payeeAcctBank);
            if (billType != null && BillTypeConstants.PAYBILL_SYN.equals(billType.getPkValue())) {
                boolean isDifferent;
                if (StringUtils.isBlank((CharSequence)info.getString("payeebanknum"))) {
                    this.addErrorMessage(data, String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7", (String)"PaymentSubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0])));
                }
                if (info.get("payeebank") == null && CasHelper.isEmpty((Object)info.getString("payeebankname"))) {
                    this.addErrorMessage(data, String.format(new PaymentErrorCode().BILL_CANNOT_NULL().getMessage(), ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c", (String)"PaymentSubmitImpl_5_1", (String)"fi-cas-business", (Object[])new Object[0])));
                }
                if (CasHelper.isNotEmpty((Object)payerAcctBank) && payeeAcctBank != 0L && payerAcctBank.getLong("id") == payeeAcctBank) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26\u4e0d\u652f\u6301\u540c\u4e00\u94f6\u884c\u8d26\u53f7\u4e4b\u95f4\u7684\u8f6c\u8d26\u3002", (String)"PaymentSynSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (CasHelper.isEmpty((Object)payeeAcctBank)) continue;
                boolean bl = isDifferent = !(isPayerInnerAcc && isPayeeInnerAcc || !isPayerInnerAcc && !isPayeeInnerAcc);
                if (isDifferent) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u540c\u540d\u8f6c\u8d26\u4e0d\u652f\u6301\u94f6\u884c\u8d26\u6237\u548c\u5185\u90e8\u8d26\u6237\u4e4b\u95f4\u7684\u8f6c\u8d26\u3002", (String)"PaymentSynSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            }
            if ("fca_transupbill".equals(sourceBillType = (String)info.get("sourcebilltype")) || isPayerInnerAcc || !isPayeeInnerAcc) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u4e0d\u652f\u6301\u94f6\u884c\u8d26\u6237\u5bf9\u5185\u90e8\u8d26\u6237\u4ed8\u6b3e\u3002", (String)"PaymentBillInnerAccountValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("PaymentSynSaveValidator validate end");
    }
}

