/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class QuotationEntryOpValidator
extends AbstractValidator {
    public void validate() {
        Map variables = this.getOption().getVariables();
        boolean isImport = variables.containsKey("importtag_of_datasource") && "true".equals(variables.get("importtag_of_datasource"));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection infos = info.getDynamicObjectCollection("cas_payinfo");
            infos.forEach(dynamicObject -> {
                String quotation = dynamicObject.getString("entry_quotation");
                if (StringUtils.isEmpty((String)quotation)) {
                    dynamicObject.set("entry_quotation", (Object)"0");
                }
            });
            DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
            DynamicObject paymentIdentify = info.getDynamicObject("paymentidentify");
            Boolean isPositivePay = EmptyUtil.isNoEmpty((DynamicObject)paymentIdentify) && "0".equals(paymentIdentify.getString("type"));
            ArrayList<String> checkBankNumErrorRows = new ArrayList<String>(payApplyEntry.size());
            ArrayList<String> checkPayeeErrorRows = new ArrayList<String>(payApplyEntry.size());
            ArrayList<String> checkErrorRows = new ArrayList<String>(payApplyEntry.size());
            HashSet<String> checkPayeeSelectErrorRows = new HashSet<String>(payApplyEntry.size());
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                this.fillByPayeeType(checkBankNumErrorRows, info, rowIndex);
                if (EmptyUtil.isEmpty((Object)((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeename")) || EmptyUtil.isEmpty((Object)((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeeaccbanknum"))) {
                    checkErrorRows.add(String.valueOf(rowIndex + 1));
                }
                if (this.isOther(info, rowIndex) || this.isEmployee(info, rowIndex) || this.isCompany(info, rowIndex) || !EmptyUtil.isEmpty((Object)((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payee"))) continue;
                checkPayeeErrorRows.add(String.valueOf(rowIndex + 1));
            }
            checkPayeeSelectErrorRows.addAll(checkBankNumErrorRows);
            checkPayeeSelectErrorRows.addAll(checkPayeeErrorRows);
            int i = 0;
            boolean flag = false;
            for (int rowIndex = 0; rowIndex < payApplyEntry.size(); ++rowIndex) {
                String ePayeeName = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeename");
                String ePayeeAccBankNum = ((DynamicObject)payApplyEntry.get(rowIndex)).getString("e_payeeaccbanknum");
                if (!this.isCompany(info, rowIndex) || !EmptyUtil.isBlank((CharSequence)ePayeeName) || !EmptyUtil.isNotBlank((CharSequence)ePayeeAccBankNum)) continue;
                QFilter qFilter = new QFilter("bankaccountnumber", "=", (Object)ePayeeAccBankNum);
                DynamicObject acc = BusinessDataServiceHelper.loadSingle((String)"am_accountbank", (String)"id,company", (QFilter[])new QFilter[]{qFilter});
                if (acc != null) {
                    Set ids = AccountBankHelper.getUserAuthorityOrgs((Long)acc.getLong("id"));
                    if (ids.size() != 1) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6240\u9009\u8d26\u6237\u5206\u914d\u7ed9\u591a\u5bb6\u7ec4\u7ec7\u4f7f\u7528\uff0c\u65e0\u6cd5\u627e\u5230\u552f\u4e00\u8d44\u91d1\u7ec4\u7ec7\u8d4b\u503c\u5230\u6536\u6b3e\u4eba\u3002\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u540e\u518d\u586b\u5199\u6536\u6b3e\u8d26\u53f7\u3002", (String)"PayApplyEdit_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex + 1));
                        ++i;
                        continue;
                    }
                    flag = true;
                    continue;
                }
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u6536\u6b3e\u8d26\u53f7\u672a\u5339\u914d\u5230\u94f6\u884c\u8d26\u6237\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u901a\u8fc7\u9009\u62e9\u65b9\u5f0f\u586b\u5199\u6216\u8005\u4fee\u6539\u624b\u5de5\u586b\u5199\u7684\u6536\u6b3e\u8d26\u53f7\u3002", (String)"PayApplyEdit_22", (String)"fi-cas-formplugin", (Object[])new Object[0]), rowIndex + 1));
                ++i;
            }
            if (i > 0) {
                return;
            }
            if (!checkErrorRows.isEmpty() && isPositivePay.booleanValue() && !isImport && !flag) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u4ed8\u6b3e\u6807\u8bc6=\u4e3b\u52a8\u4ed8\u6b3e\u65f6\uff0c\u7533\u8bf7\u660e\u7ec6\u7b2c%s\u884c\u201c\u6536\u6b3e\u4eba\u201d\u3001\u201c\u6536\u6b3e\u8d26\u53f7\u201d\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"PayApplyEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", checkErrorRows)));
                return;
            }
            DynamicObject payOrg = info.getDynamicObject("payorg");
            String valueSource = payOrg == null ? "2" : SystemParameterHelper.getParameterString((long)payOrg.getLong("id"), (String)"cs126");
            if (!checkErrorRows.isEmpty() || checkPayeeSelectErrorRows.isEmpty() || !"1".equals(valueSource) || isImport) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%s\u884c\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a\u4f9b\u5e94\u5546\uff08\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0d\u4e3a\u7a7a\uff09\u3001\u5ba2\u6237\uff08\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0d\u4e3a\u7a7a\uff09\u65f6\uff0c\u6536\u6b3e\u4eba&\u6536\u6b3e\u8d26\u53f7\u9700\u901a\u8fc7\u9009\u62e9\u65b9\u5f0f\u586b\u5199\u3002", (String)"PayApplyEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", checkPayeeSelectErrorRows)));
            return;
        }
    }

    private void fillByPayeeType(List<String> errorRows, DynamicObject info, int rowIndex) {
        DynamicObject internalOrg;
        DynamicObject ePayee;
        DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
        if ((this.isSupplier(info, rowIndex) || this.isCustomer(info, rowIndex)) && (ePayee = ((DynamicObject)payApplyEntry.get(rowIndex)).getDynamicObject("e_payee")) != null && (internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)info.getDynamicObject("payorg"), (DynamicObject)ePayee)) != null) {
            this.checkPayeeAccBank(errorRows, info, rowIndex, internalOrg);
        }
    }

    private void checkPayeeAccBank(List<String> errorRows, DynamicObject info, int rowIndex, DynamicObject internalOrg) {
        QFilter bankNumberFilter;
        DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
        QFilter useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)internalOrg.getPkValue()));
        DynamicObject[] bankAccounts = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id, bank.bebank", (QFilter[])new QFilter[]{useOrgFilter, bankNumberFilter = new QFilter("bankaccountnumber", "=", ((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeeaccbanknum"))});
        if (bankAccounts == null || bankAccounts.length == 0) {
            if (BaseDataHelper.isInternalOrg((DynamicObject)info.getDynamicObject("payorg"))) {
                errorRows.add(String.valueOf(rowIndex + 1));
            } else if (QueryServiceHelper.exists((String)"bd_accountbanks", (QFilter[])new QFilter[]{useOrgFilter})) {
                errorRows.add(String.valueOf(rowIndex + 1));
            }
        }
    }

    private boolean isSupplier(DynamicObject info, int rowIndex) {
        return this.isAimType(AsstActTypeEnum.SUPPLIER, info, rowIndex);
    }

    private boolean isCustomer(DynamicObject info, int rowIndex) {
        return this.isAimType(AsstActTypeEnum.CUSTOMER, info, rowIndex);
    }

    private boolean isCompany(DynamicObject info, int rowIndex) {
        return this.isAimType(AsstActTypeEnum.COMPANY, info, rowIndex);
    }

    private boolean isEmployee(DynamicObject info, int rowIndex) {
        return this.isAimType(AsstActTypeEnum.EMPLOYEE, info, rowIndex);
    }

    private boolean isOther(DynamicObject info, int rowIndex) {
        return this.isAimType(AsstActTypeEnum.OTHER, info, rowIndex);
    }

    private boolean isAimType(AsstActTypeEnum asstActType, DynamicObject info, int rowIndex) {
        DynamicObjectCollection payApplyEntry = info.getDynamicObjectCollection("cas_payapplyentry");
        Object payeeType = ((DynamicObject)payApplyEntry.get(rowIndex)).get("e_payeetype");
        return asstActType.getValue().equals(payeeType);
    }
}

