/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.ReceServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.enums.RecBizTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillSubmitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(ReceivingBillSubmitValidator.class);

    public void validate() {
        ReceivErrorCode receivErrorCode = new ReceivErrorCode();
        Set orgIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("org")) && EmptyUtil.isNoEmpty((Long)d.getDataEntity().getDynamicObject("org").getLong("id"))).map(d -> d.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map orgParamMap = new HashMap(10);
        Map casInitMap = new HashMap(10);
        Map orgCtrlMap = new HashMap(10);
        if (EmptyUtil.isNoEmpty(orgIds)) {
            orgParamMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(orgIds), (String)"cs127");
            casInitMap = SystemStatusCtrolHelper.getCurrentPeriod(orgIds);
            orgCtrlMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIds);
        }
        List payerAccIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("accountbank")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        List cashAccIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("accountcash")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        Map currencyPksMap = AccountBankHelper.getBatchCurrencyPks((String)"bd_accountbanks", payerAccIdList);
        Map cashCurrencyPksMap = AccountBankHelper.getBatchCurrencyPks((String)"cas_accountcash", cashAccIdList);
        Set idSet = Arrays.stream(this.dataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toSet());
        DynamicObject[] recVirtBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,sourcebilltype,isvirtual,actrecamt", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet), new QFilter("isvirtual", "=", (Object)"1")});
        Map recVirtBillMap = Arrays.stream(recVirtBill).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        List fromBeiRecBills = Arrays.stream(this.dataEntities).filter(e -> "bei_intelrec".equals(e.getDataEntity().getString("sourcebilltype"))).collect(Collectors.toList());
        Map beiBillMap = null;
        if (null != fromBeiRecBills && fromBeiRecBills.size() > 0) {
            List sourceBillIdList = fromBeiRecBills.stream().map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
            DynamicObject[] beiBills = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id,creditamount", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdList)});
            beiBillMap = Arrays.stream(beiBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        }
        DynamicObjectCollection virtAcctIds = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{VisibleVirtualAcctHelper.virtualAcctQf()});
        Set virtAcctIdSet = virtAcctIds.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject org;
            String errorMsg;
            DynamicObject e_receivingtype;
            Iterator iterator;
            boolean noSettleOrg;
            StringBuffer errMsg = new StringBuffer();
            DynamicObject recBill = dataEntity.getDataEntity();
            String payerType = recBill.getString("payertype");
            if (CasHelper.isEmpty((Object)payerType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u7c7b\u578b\u4e3a\u5fc5\u586b\u9879\u3002", (String)"PaymentErrorCode_52", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            BigDecimal sumAmt = recBill.getBigDecimal("actrecamt");
            if (BigDecimal.valueOf(Math.pow(10.0, 13.0)).compareTo(sumAmt) <= 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u8d85\u8fc7\u6700\u5927\u503c\u3002", (String)"ReceivingBillSaveValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!AsstActTypeEnum.OTHER.getValue().equals("receivingtype") && recBill.get("payer") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u4eba\u3002", (String)"ReceivingBillSaveValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (recBill.getDynamicObject("accountcash") != null && recBill.getDynamicObject("accountbank") != null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7\u548c\u73b0\u91d1\u8d26\u53f7\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"PaymentSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!this.checkEmpty(dataEntity, errMsg)) {
                String billStatus = recBill.getString("billstatus");
                if (!billStatus.equals(BillStatusEnum.SAVE.getValue())) {
                    String content = receivErrorCode.STATUS_CANNOT_SUBMIT().getMessage();
                    this.addMessage(dataEntity, content, ErrorLevel.Error);
                }
                DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
                BigDecimal amt = BigDecimal.ZERO;
                for (int i = 0; i < entrys.size(); ++i) {
                    BigDecimal actAmt = ((DynamicObject)entrys.get(i)).getBigDecimal("e_actamt");
                    if (actAmt.compareTo(BigDecimal.ZERO) == 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u4e2d\u7684\u5b9e\u6536\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ReceivingBillSaveValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), i + 1));
                    }
                    amt = amt.add(actAmt);
                }
                if (recBill.getBigDecimal("actrecamt").compareTo(amt) != 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b9e\u6536\u91d1\u989d\u603b\u548c\u4e0e\u5355\u636e\u5934\u6536\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"ReceivingBillSaveValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
            } else {
                this.addMessage(dataEntity, errMsg.toString(), ErrorLevel.Error);
            }
            DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && (noSettleOrg = entrys.parallelStream().filter(e -> EmptyUtil.isNoEmpty((DynamicObject)e.getDynamicObject("e_receivingtype")) && e.getDynamicObject("e_receivingtype").getBoolean("ispartreceivable") && EmptyUtil.isEmpty((DynamicObject)e.getDynamicObject("e_settleorg"))).findFirst().isPresent())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53c2\u4e0e\u7ed3\u7b97\u7684\u6536\u6b3e\u7c7b\u578b\u7684\u6536\u6b3e\u5355\uff0c\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivingBillSaveValidator_2_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            HashSet<DynamicObject> entryReceivingTypes = new HashSet<DynamicObject>(4);
            boolean multireceivingtype = recBill.getBoolean("multireceivingtype");
            DynamicObject receivingtype = recBill.getDynamicObject("receivingtype");
            for (DynamicObject entry : entrys) {
                DynamicObject e_paymenttype = entry.getDynamicObject("e_receivingtype");
                if (e_paymenttype == null) continue;
                entryReceivingTypes.add(e_paymenttype);
            }
            if (multireceivingtype && entryReceivingTypes != null && entryReceivingTypes.size() < 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u5173\u95ed\u591a\u6536\u6b3e\u7c7b\u578b\u3002", (String)"ReceivingBillSubmitValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && "110".equals(receivingtype.getString("biztype")) && entryReceivingTypes != null && entryReceivingTypes.size() < 2) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u4f46\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u6536\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillSubmitValidator_20", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!multireceivingtype && entryReceivingTypes != null && entryReceivingTypes.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u6253\u5f00\u591a\u6536\u6b3e\u7c7b\u578b\u3002", (String)"ReceivingBillSubmitValidator_15", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && !"110".equals(receivingtype.getString("biztype")) && entryReceivingTypes != null && entryReceivingTypes.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u5b58\u5728\u591a\u79cd\u6536\u6b3e\u7c7b\u578b\uff0c\u4f46\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u6536\u6b3e\u7c7b\u578b\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u7efc\u5408\u6536\u6b3e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillSubmitValidator_21", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ((!multireceivingtype || entryReceivingTypes != null && entryReceivingTypes.size() == 1) && EmptyUtil.isNoEmpty((DynamicObject)receivingtype) && (iterator = entryReceivingTypes.iterator()).hasNext() && EmptyUtil.isNoEmpty((DynamicObject)(e_receivingtype = (DynamicObject)iterator.next())) && e_receivingtype.getLong("id") != receivingtype.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u53ea\u6709\u4e00\u79cd\u6536\u6b3e\u7c7b\u578b\u6216\u8005\u975e\u591a\u6536\u6b3e\u7c7b\u578b\uff0c\u5206\u5f55\u7684\u6536\u6b3e\u7c7b\u578b\u5fc5\u987b\u4e0e\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u6536\u6b3e\u7c7b\u578b\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillSubmitValidator_22", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue;
            }
            iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry;
                entry = (DynamicObject)iterator.next();
                DynamicObject e_receivingtype2 = entry.getDynamicObject("e_receivingtype");
                if (e_receivingtype2 == null || !"110".equals(e_receivingtype2.getString("biztype"))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u4e0d\u5141\u8bb8\u542b\u6709\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7efc\u5408\u6536\u6b3e\u7684\u6536\u6b3e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillSubmitValidator_23", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                break;
            }
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject e_paymenttype = ((DynamicObject)entrys.get(i)).getDynamicObject("e_receivingtype");
                String e_corebilltype = ((DynamicObject)entrys.get(i)).getString("e_corebilltype");
                if (e_paymenttype == null) continue;
                boolean ispartreceivable = e_paymenttype.getBoolean("ispartreceivable");
                ComboProp property = (ComboProp)EntityMetadataCache.getDataEntityType((String)"cas_recbill").getProperty(ispartreceivable ? "settlecorebilltype" : "unsettlecorebilltype");
                Set settleTypes = property.getComboItems().stream().map(ValueMapItem::getValue).collect(Collectors.toSet());
                Map coreBillMap = CoreBillSettingHelper.loadCoreBillSettingNumberAndName((String)"cas_recbill", (boolean)false, (boolean)ispartreceivable);
                String names = "";
                if (coreBillMap.size() > 0) {
                    settleTypes.addAll(coreBillMap.keySet());
                    names = "\u3001" + String.join((CharSequence)"\u3001", coreBillMap.values());
                }
                if (!StringUtils.isNotEmpty((CharSequence)e_corebilltype) || settleTypes.contains(e_corebilltype)) continue;
                String errorMsg2 = ispartreceivable ? ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6536\u6b3e\u7c7b\u578b\u53c2\u4e0e\u7ed3\u7b97\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u3010\u8d22\u52a1\u5e94\u6536\u5355\u3001\u9500\u552e\u8ba2\u5355\u3001\u9500\u552e\u5408\u540c\u3001\u5efa\u7b51\u6536\u5165\u5408\u540c%2$s\u3011\u3002", (String)"ReceivingBillSubmitValidator_18", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\u6536\u6b3e\u7c7b\u578b\u4e0d\u53c2\u4e0e\u7ed3\u7b97\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u53ea\u80fd\u9009\u62e9\u3010\u603b\u8d26\u6536\u6b3e\u5355\u3001\u8fd8\u6b3e\u5355%2$s\u3011\u3002", (String)"ReceivingBillSubmitValidator_19", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, String.format(errorMsg2, i + 1, names));
            }
            DynamicObject sysStatusCtrl = (DynamicObject)orgCtrlMap.get(String.valueOf(recBill.getDynamicObject("org").getPkValue()));
            if (sysStatusCtrl == null || CasHelper.isEmpty((Object)sysStatusCtrl.getDynamicObject("standardcurrency"))) {
                KDBizException exception = new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u51fa\u7eb3\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u7136\u540e\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"ReceivingBillSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                this.exceptionProcess(dataEntity, (Exception)((Object)exception), ErrorLevel.Error);
                continue;
            }
            DynamicObject settleType = recBill.getDynamicObject("settletype");
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
                recBill.set("accountbank", null);
            }
            Collection supportedCurrencys = null;
            DynamicObject accountBank = recBill.getDynamicObject("accountbank");
            DynamicObject accountCash = recBill.getDynamicObject("accountcash");
            if (accountBank != null) {
                supportedCurrencys = (Collection)currencyPksMap.get(accountBank.getPkValue());
            } else if (accountCash != null) {
                supportedCurrencys = (Collection)cashCurrencyPksMap.get(accountCash.getPkValue());
            }
            logger.info("\u6536\u6b3e\u5e01\u79cd" + String.valueOf(recBill.getLong("currency.id")));
            if (supportedCurrencys != null) {
                supportedCurrencys.forEach(curr -> logger.info("\u8d26\u6237\u5e01\u79cd" + String.valueOf(curr)));
            }
            if (supportedCurrencys != null && !supportedCurrencys.contains(recBill.getLong("currency.id"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u4e1a\u52a1\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReceivingBillSubmitValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            long payee = recBill.getLong("payer");
            String payeename = recBill.getString("payername");
            DynamicObject type = recBill.getDynamicObject("receivingtype");
            Boolean isPart = Boolean.TRUE;
            if (type != null) {
                isPart = type.getBoolean("ispartreceivable");
            }
            if (isPart.booleanValue() && payee == 0L && StringUtils.isBlank((CharSequence)payeename)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivingBillSaveValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (EmptyUtil.isNoEmpty((String)(errorMsg = CheckUtils.checkBizType((DynamicObject)recBill)))) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
                continue;
            }
            String comment = recBill.getString("txt_description");
            TextProp property = (TextProp)recBill.getDataEntityType().getProperties().get((Object)"txt_description");
            int maxLenth = property.getMaxLenth();
            if (CasHelper.isNotEmpty((Object)comment) && comment.length() > maxLenth) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b57\u6bb5\u201c\u6458\u8981\u201d\u8f93\u5165\u957f\u5ea6\u4e0d\u80fd\u8d85\u51fa\u9650\u5b9a\u8303\u56f40~%2$s\u3002", (String)"ReceivingBillSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]), recBill.getString("billno"), maxLenth));
            }
            if (ReceServiceHelper.isNeedValidate((DynamicObject)recBill)) {
                logger.info("submitValidate ");
                RecBillOverAmountHelper.getWriteBackVad((DynamicObject)recBill, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMITVALIDATE, (boolean)true);
            }
            String sourceBillType = recBill.getString("sourcebilltype");
            Long sourceBillId = recBill.getLong("sourcebillid");
            if (null != recVirtBillMap && null != recVirtBillMap.get(recBill.getPkValue())) {
                boolean isvirtual = ((DynamicObject)recVirtBillMap.get(recBill.getPkValue())).getBoolean("isvirtual");
                String sourcebilltype = ((DynamicObject)recVirtBillMap.get(recBill.getPkValue())).getString("sourcebilltype");
                if (isvirtual && !EmptyUtil.isEmpty((String)sourcebilltype) && "cas_recbill".equals(sourcebilltype)) {
                    BigDecimal actRecAmtDB = ((DynamicObject)recVirtBillMap.get(recBill.getPkValue())).getBigDecimal("actrecamt");
                    BigDecimal actrecamtTemp = recBill.getBigDecimal("actrecamt");
                    if (actrecamtTemp != null && actrecamtTemp.compareTo(actRecAmtDB) != 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fee\u6539\u540e\u7684\u6536\u6b3e\u91d1\u989d\u6570\u503c\u4e0e\u539f\u6765\u91d1\u989d\u6570\u503c\u201c%s\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"ReceivingBillSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), actRecAmtDB));
                    }
                }
            }
            DynamicObject currency = recBill.getDynamicObject("currency");
            if (!CasHelper.isEmpty((Object)sourceBillType) && !CasHelper.isEmpty((Object)sourceBillId) && "bei_intelrec".equals(sourceBillType)) {
                if (null == beiBillMap || null == beiBillMap.get(sourceBillId)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e3a\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u4f46\u5bf9\u5bf9\u5e94\u7684\u4ea4\u6613\u660e\u7ec6\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ReceivingBillSaveValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                } else {
                    String sourceBillNumbers = recBill.getString("sourcebillnumber");
                    String[] split = sourceBillNumbers.split(",");
                    if (split.length <= 1) {
                        BigDecimal creditamount = ((DynamicObject)beiBillMap.get(sourceBillId)).getBigDecimal("creditamount");
                        BigDecimal actrecamt = recBill.getBigDecimal("actrecamt");
                        String sign = "\uffe5";
                        if (currency != null) {
                            sign = currency.getString("sign");
                        }
                        if (creditamount.compareTo(actrecamt) != 0) {
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e3a\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u6536\u6b3e\u5355\uff0c\u5b9e\u6536\u91d1\u989d\u5fc5\u987b\u7b49\u4e8e\u4ea4\u6613\u660e\u7ec6\u7684\u6536\u6b3e\u91d1\u989d\uff08%1$s %2$s\uff09\u3002", (String)"ReceivingBillSaveValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]), sign, creditamount));
                        }
                    }
                }
            }
            DynamicObject settletype = recBill.getDynamicObject("settletype");
            DynamicObject accountbank = recBill.getDynamicObject("accountbank");
            if (accountbank != null && BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype) && (virtAcctIdSet.isEmpty() || !virtAcctIdSet.contains(accountbank.getPkValue()))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u865a\u62df\u7ed3\u7b97\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u865a\u62df\u94f6\u884c\u8d26\u6237", (String)"ReceivingBillSubmitValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(org = recBill.getDynamicObject("org"))) && EmptyUtil.isNoEmpty((Long)org.getLong("id"))) {
                Date beginDate;
                DynamicObject currentperiod;
                Long orgId = org.getLong("id");
                Date bizDate = recBill.getDate("bizDate");
                Object orgParam = orgParamMap.get(String.valueOf(orgId));
                DynamicObject casInit = (DynamicObject)casInitMap.get(orgId);
                DynamicObject dynamicObject2 = EmptyUtil.isEmpty((DynamicObject)casInit) ? null : (currentperiod = EmptyUtil.isEmpty((DynamicObject)casInit.getDynamicObject("currentperiod")) ? null : casInit.getDynamicObject("currentperiod"));
                if (currentperiod == null && !EmptyUtil.isEmpty((DynamicObject)casInit) && ExtendConfigHelper.isInitOnlySet()) {
                    currentperiod = casInit.getDynamicObject("startperiod");
                }
                Date date = beginDate = currentperiod == null ? null : currentperiod.getDate("beginDate");
                if (EmptyUtil.isNoEmpty(orgParam) && !((Boolean)orgParam).booleanValue() && EmptyUtil.isNoEmpty((Object)bizDate) && EmptyUtil.isNoEmpty((Object)beginDate) && bizDate.before(beginDate)) {
                    KDBizException e2 = new KDBizException(receivErrorCode.BIZDATE_BEFORE_CURRENTPERIOD(), new Object[0]);
                    this.exceptionProcess(dataEntity, (Exception)((Object)e2), ErrorLevel.Error);
                    continue;
                }
            }
            DynamicObjectCollection entryentity = recBill.getDynamicObjectCollection("entry");
            int i = 1;
            for (DynamicObject dynamicObject3 : entryentity) {
                DynamicObject entryReceivingType = dynamicObject3.getDynamicObject("e_receivingtype");
                boolean isAr = entryReceivingType != null && entryReceivingType.getBoolean("ispartreceivable");
                String coreBillType = dynamicObject3.getString("e_corebilltype");
                if (isAr && StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue())) {
                    String payBillNo = dynamicObject3.getString("e_corebillno");
                    DynamicObject payBill = BusinessDataServiceHelper.loadSingle((String)"cas_paybill", (String)"id,billno,entry,entry.seq,entry.settleorg,entry.e_localamt,entry.e_actamt,currency", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)payBillNo)});
                    if (EmptyUtil.isEmpty((DynamicObject)payBill)) continue;
                    BigDecimal actAmt = dynamicObject3.getBigDecimal("e_actamt");
                    DynamicObject settleOrg = dynamicObject3.getDynamicObject("e_settleorg");
                    long coreBillEntryId = dynamicObject3.getLong("e_corebillentryid");
                    DynamicObjectCollection entryCol = payBill.getDynamicObjectCollection("entry");
                    BigDecimal payActAmount = coreBillEntryId != 0L ? entryCol.stream().filter(o -> coreBillEntryId == o.getLong("id")).map(o -> o.getBigDecimal("e_actamt")).findFirst().orElse(BigDecimal.ZERO) : entryCol.stream().filter(o -> o.getDynamicObject("settleorg") != null ? o.getDynamicObject("settleorg").getPkValue().equals(settleOrg.getPkValue()) : false).map(o -> o.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    DynamicObject payBillCurrency = payBill.getDynamicObject("currency");
                    DynamicObject recBillCurrency = recBill.getDynamicObject("currency");
                    if (payBillCurrency != null && recBillCurrency != null && payBillCurrency.getPkValue().equals(recBillCurrency.getPkValue()) && actAmt.compareTo(payActAmount) > 0) {
                        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u9000\u6b3e\u7684\u573a\u666f\uff0c\u5b9e\u6536\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u5355\u7684\u201c\u5b9e\u4ed8\u91d1\u989d\u201d\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9009\u9519\u4ed8\u6b3e\u5355\u3002", (String)"ClaimBillSaveValidator_14", (String)"fi-cas-opplugin", (Object[])new Object[0]), i);
                        this.addMessage(dataEntity, msg);
                    }
                }
                ++i;
            }
        }
    }

    private boolean checkEmpty(ExtendedDataEntity info, StringBuffer errMsg) {
        boolean isVirtualSettle;
        if (StringUtils.isBlank((Object)info.getValue("receivingtype"))) {
            errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)info.getValue("payertype"))) {
            errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)info.getValue("org"))) {
            errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        DynamicObject settleType = (DynamicObject)info.getValue("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        boolean isDraft = DraftHelper.isSettle((Object)settleType);
        DynamicObject receivingType = (DynamicObject)info.getValue("receivingtype");
        boolean isVirtualRec = receivingType != null && StringUtils.equals((CharSequence)RecBizTypeEnum.VIRTUAL_RECEIVING.getValue(), (CharSequence)receivingType.getString("biztype"));
        DynamicObject settletype = (DynamicObject)info.getValue("settletype");
        boolean bl = isVirtualSettle = settletype != null && SettleMentTypeEnum.VIRTUAL.getValue().equals(settletype.getString("settlementtype"));
        if (!(isVirtualSettle || isVirtualRec || isDraft || isCash || ((Boolean)info.getValue("isagent")).booleanValue() || "cas_recbill".equals(info.getValue("sourcebilltype")))) {
            if (StringUtils.isBlank((Object)info.getValue("accountbank"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((Object)info.getValue("payeebank"))) {
                errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
        if ((isCash || "cash".equals(info.getValue("biztype"))) && StringUtils.isBlank((Object)info.getValue("accountcash"))) {
            errMsg.append(ResManager.loadKDString((String)"\u73b0\u91d1\u6536\u6b3e\u5355\u73b0\u91d1\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)info.getValue("currency"))) {
            errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)info.getValue("exchangerate"))) {
            errMsg.append(ResManager.loadKDString((String)"\u6536\u6b3e\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)info.getValue("settletype"))) {
            errMsg.append(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002\n", (String)"ReceivingBillSubmitValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        return StringUtils.isNotEmpty((CharSequence)errMsg);
    }

    protected void exceptionProcess(ExtendedDataEntity dataEntity, Exception e, ErrorLevel error) {
        this.addMessage(dataEntity, e.getMessage(), error);
        this.getValidateResult().setSuccess(false);
    }
}

