/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.agent;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class AgentDcepSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(AgentDcepSubmitValidator.class);

    public void validate() {
        logger.info("AgentDcepSubmitValidator validate start");
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean iselecpayment;
            DynamicObjectCollection entryDoc;
            Set payeeAcctBanks;
            Object[] recAccBankData;
            DynamicObject info = data.getDataEntity();
            DynamicObject settleType = info.getDynamicObject("settletype");
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
            if (isDcep) {
                String businessType = info.getString("businesstype");
                DynamicObject payAccBank = info.getDynamicObject("payeracctbank");
                if (!EmptyUtil.isNoEmpty((DynamicObject)payAccBank)) continue;
                boolean isElecPaymentPay = payAccBank.getBoolean("iselecpayment");
                if (!PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) continue;
                if (!isElecPaymentPay) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                String payeeType = info.getString("payeetype");
                if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType) && !AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) && !AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) continue;
                DynamicObjectCollection entryDoc2 = info.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryDoc2) {
                    boolean checkInternalOrg = true;
                    if (!AsstActTypeEnum.COMPANY.getValue().equals(payeeType)) {
                        DynamicObject payeeObj = entry.getDynamicObject("payee");
                        DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)info.getDynamicObject("org"), (DynamicObject)payeeObj);
                        checkInternalOrg = EmptyUtil.isNoEmpty((DynamicObject)internalOrg);
                    }
                    String payeeacctbank = entry.getString("payeeacctbank");
                    DynamicObject recAccBank = AccountBankHelper.getAccountByNumber((String)payeeacctbank);
                    if (!checkInternalOrg || !EmptyUtil.isNoEmpty((DynamicObject)recAccBank) || recAccBank.getBoolean("iselecpayment")) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7ed3\u7b97\u65b9\u5f0f\u4e3a\u6570\u5e01\u94b1\u5305\u7684\u4e1a\u52a1\uff0c\u6536\u6b3e\u65b9\u8d26\u6237\u548c\u4ed8\u6b3e\u65b9\u8d26\u6237\u5fc5\u987b\u5747\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237:\u8bf7\u68c0\u67e5\u94f6\u884c\u8d26\u6237\uff1a%s\u662f\u5426\u4e3a\u6570\u5e01\u94b1\u5305\u8d26\u6237\u3002", (String)"AgentDcepSubmitValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[]{payeeacctbank}));
                }
                continue;
            }
            DynamicObject payAccBank = info.getDynamicObject("payeracctbank");
            if (!EmptyUtil.isNoEmpty((DynamicObject)payAccBank)) continue;
            boolean isElecPaymentPay = payAccBank.getBoolean("iselecpayment");
            if (isElecPaymentPay) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u4ed8\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Object[])(recAccBankData = AccountBankHelper.getAccountByNumbers(payeeAcctBanks = (entryDoc = info.getDynamicObjectCollection("entry")).stream().map(s -> s.getString("payeeacctbank")).collect(Collectors.toSet())))) || !(iselecpayment = Arrays.stream(recAccBankData).anyMatch(s -> s.getBoolean("iselecpayment")))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u975e\u6570\u5e01\u94b1\u5305\uff0c\u6536\u6b3e\u8d26\u6237\u4e0d\u5141\u8bb8\u662f\u94b1\u5305\u8d26\u6237\u3002", (String)"PaymentDcepSubmitValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        logger.info("AgentDcepSubmitValidator validate end");
    }
}

