/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.agent;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;

public class AgentRepayValidator
extends AbstractValidator {
    public void validate() {
        List repayBills = Arrays.stream(this.getDataEntities()).filter(e -> e.getDataEntity().getBoolean("isrepay")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(repayBills)) {
            return;
        }
        Long[] billIds = (Long[])repayBills.stream().map(b -> b.getDataEntity().getLong("id")).toArray(Long[]::new);
        Long[] entryIds = (Long[])repayBills.stream().flatMap(b -> b.getDataEntity().getDynamicObjectCollection("entry").stream()).map(e -> e.getLong("id")).toArray(Long[]::new);
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", "true");
        List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)"cas_agentpaybill", (String)"entry", (Long[])billIds, (Long[])entryIds, (OperateOption)option);
        if (CollectionUtils.isEmpty((Collection)bfRows)) {
            return;
        }
        Set sourceBillIds = bfRows.stream().map(bf -> bf.getSId().getBillId()).collect(Collectors.toSet());
        Set sourceEntryIds = bfRows.stream().map(bf -> bf.getSId().getEntryId()).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", sourceBillIds).and("entry.id", "in", sourceEntryIds);
        DynamicObjectCollection sourceEntryList = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,entry.id,entry.e_issuccess", (QFilter[])filter.toArray());
        for (DynamicObject sourceEntry : sourceEntryList) {
            Optional<ExtendedDataEntity> targetExtendOp;
            if (!sourceEntry.getBoolean("entry.e_issuccess")) continue;
            long sourceBillId = sourceEntry.getLong("id");
            Optional<Long> targetBillIdOp = bfRows.stream().filter(bf -> Objects.equals(bf.getSId().getBillId(), sourceBillId)).map(b -> b.getId().getBillId()).findFirst();
            if (!targetBillIdOp.isPresent() || !(targetExtendOp = repayBills.stream().filter(e -> Objects.equals(targetBillIdOp.get(), e.getDataEntity().getLong("id"))).findFirst()).isPresent()) continue;
            ExtendedDataEntity targetExtend = targetExtendOp.get();
            String msg = ResManager.loadKDString((String)"\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u7684\u4ee3\u53d1\u5355\uff0c\u6bcf\u4e00\u884c\u4ee3\u53d1\u660e\u7ec6\u5bf9\u5e94\u7684\u6e90\u4ee3\u53d1\u660e\u7ec6\u5747\u662f\u4ea4\u6613\u5931\u8d25\u7684\u624d\u5141\u8bb8\u63d0\u4ea4\uff0c\u5426\u5219\u5b58\u5728\u91cd\u590d\u652f\u4ed8\u98ce\u9669\u3002", (String)"CAS-W-846814", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(targetExtend, msg);
        }
    }
}

