/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.changebill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PayApplyRecChgAuditValidator
extends AbstractValidator {
    private static final String RECCHG = "recchg";

    public void validate() {
        List ageBillIdList = Arrays.stream(this.dataEntities).filter(o -> "cas_agentpaybill".equals(o.getDataEntity().getString("sourcetype"))).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] agentPayBillDts = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billstatus,isrepay", (QFilter[])new QFilter[]{new QFilter("id", "in", ageBillIdList)});
        Map billStatusMap = Arrays.stream(agentPayBillDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            if ("cas_agentpaybill".equals(entity.getString("sourcetype"))) {
                Boolean tempBool = true;
                DynamicObject agentBill = (DynamicObject)billStatusMap.get(entity.getLong("sourcebillid"));
                String billStatus = agentBill.getString("billstatus");
                boolean isRepay = agentBill.getBoolean("isrepay");
                if ("paychg".equals(entity.getString("chgtype"))) {
                    if ("C".equals(billStatus)) {
                        tempBool = false;
                    } else if ("A".equals(billStatus) && isRepay) {
                        tempBool = false;
                    }
                    if (tempBool.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u5ba1\u6838\u72b6\u6001\u6216\u8005\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayInfoChgSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                } else {
                    if ("C".equals(billStatus) || "A".equals(billStatus) || "B".equals(billStatus)) {
                        tempBool = false;
                    } else if ("A".equals(billStatus) && isRepay) {
                        tempBool = false;
                    }
                    if (tempBool.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u6682\u5b58\u3001\u5df2\u63d0\u4ea4\u3001\u5df2\u5ba1\u6838\u72b6\u6001\u6216\u8005\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayInfoChgSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            }
            if (!entity.getString("chgtype").equals(RECCHG) || !entity.getString("sourcetype").equals("cas_payapplybill") || !entity.getBoolean("iscashconfirm")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u786e\u8ba4\u3002", (String)"PayApplyRecChgAuditValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

