/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.changebill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ChangeStatusEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;
import kd.fi.cas.helper.SystemParameterHelper;
import org.apache.commons.lang3.StringUtils;

public class PayInfoChgConfirmValidator
extends AbstractValidator {
    public void validate() {
        List ageBillIdList = Arrays.stream(this.dataEntities).filter(o -> "cas_agentpaybill".equals(o.getDataEntity().getString("sourcetype"))).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] agentPayBillDts = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billstatus,changestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", ageBillIdList)});
        Map<Long, DynamicObject> ageBillsMap = Arrays.stream(agentPayBillDts).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        List payMentBillIdList = Arrays.stream(this.dataEntities).filter(o -> "cas_paybill".equals(o.getDataEntity().getString("sourcetype"))).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        DynamicObject[] payMentBillDts = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,changestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", payMentBillIdList)});
        Map<Long, DynamicObject> payMentbillsMap = Arrays.stream(payMentBillDts).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String sourceName;
            String errorMessage;
            DynamicObject chgBill = dataEntity.getDataEntity();
            String sourcetype = chgBill.getString("sourcetype");
            Long sourcebillid = chgBill.getLong("sourcebillid");
            if (("cas_paybill".equals(sourcetype) || "cas_agentpaybill".equals(sourcetype)) && StringUtils.isNotEmpty((CharSequence)(errorMessage = this.validateChangeStatus(sourcetype, dataEntity, sourcebillid, ageBillsMap, payMentbillsMap)))) {
                this.addErrorMessage(dataEntity, errorMessage);
                continue;
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(chgBill.getString("billstatus"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%s\u3011:\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u786e\u8ba4\u3002", (String)"PayChgReviewExecutor_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno")));
                continue;
            }
            if (chgBill.getBoolean("iscashconfirm")) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%s\u3011:\u5df2\u786e\u8ba4\uff0c\u65e0\u9700\u91cd\u590d\u786e\u8ba4\u3002", (String)"PayChgReviewExecutor_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno")));
                continue;
            }
            DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)chgBill.getLong("sourcebillid"), (String)sourcetype);
            String billStatus = sourceBill.getString("billstatus");
            if (!(SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(sourcetype) || SourceBillTypeEnum.PAYBILL.getValue().equals(sourcetype) || BillStatusEnum.AUDIT.getValue().equals(billStatus))) {
                sourceName = SourceBillTypeEnum.getName((String)sourcetype);
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u201c%1$s\u201d\uff1a\u5173\u8054\u7684%2$s\u201c%3$s\u201d\u53ea\u6709\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayChgReviewExecutor_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"), sourceName, sourceBill.getString("billno")));
                continue;
            }
            if (!SourceBillTypeEnum.PAYBILL.getValue().equals(sourcetype)) continue;
            sourceName = SourceBillTypeEnum.getName((String)sourcetype);
            Long orgId = sourceBill.getDynamicObject("org").getLong("id");
            Set cs195 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs195");
            if (cs195.contains(billStatus)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5355\u3010%1$s\u3011\uff1a\u5173\u8054\u7684%2$s\u3010%3$s\u3011\u53ea\u6709\u5728\u7cfb\u7edf\u53c2\u6570\u5141\u8bb8\u53d1\u8d77\u53d8\u66f4\u7684\u5355\u636e\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayChgReviewExecutor_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), chgBill.getString("billno"), sourceName, sourceBill.getString("billno")));
        }
    }

    private String validateChangeStatus(String sourcetype, ExtendedDataEntity dataEntity, Long sourceid, Map<Long, DynamicObject> ageBillsMap, Map<Long, DynamicObject> payMentbillsMap) {
        String errorMessage = null;
        DynamicObject payBill = "cas_agentpaybill".equals(sourcetype) ? ageBillsMap.get(sourceid) : payMentbillsMap.get(sourceid);
        if (payBill == null) {
            return null;
        }
        String changestatus = payBill.getString("changestatus");
        if (!ChangeStatusEnum.CHANGING.getValue().equals(changestatus)) {
            errorMessage = ResManager.loadKDString((String)"\u6e90\u5355\u4e3a\u4ed8\u6b3e\u5355\u6216\u4ee3\u53d1\u5355\uff0c\u53d8\u66f4\u72b6\u6001\u5fc5\u987b\u4e3a\u53d8\u66f4\u4e2d\u624d\u53ef\u4ee5\u8fdb\u884c\u786e\u8ba4\u3002", (String)"PayInfoChgConfirmValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]);
        }
        return errorMessage;
    }
}

