/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.changebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.sdk.fi.cas.extpoint.paybill.IPayChgBillInterface;

public class PayInfoChgSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PayInfoChgSaveValidator.class);

    public void validate() {
        List<Object> ids = new ArrayList(4);
        List ageBillIdList = Arrays.stream(this.dataEntities).filter(o -> "cas_agentpaybill".equals(o.getDataEntity().getString("sourcetype"))).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        Object[] agentPayBillDts = BusinessDataServiceHelper.load((String)"cas_agentpaybill", (String)"id,billstatus,isrepay,org", (QFilter[])new QFilter[]{new QFilter("id", "in", ageBillIdList)});
        if (EmptyUtil.isNoEmpty((Object[])agentPayBillDts)) {
            ids = Arrays.stream(agentPayBillDts).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        }
        Map billStatusMap = Arrays.stream(agentPayBillDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        List payBillIdList = Arrays.stream(this.dataEntities).filter(o -> "cas_paybill".equals(o.getDataEntity().getString("sourcetype"))).map(o -> o.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        Object[] PayBillDts = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,paymentidentify,org", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillIdList)});
        if (EmptyUtil.isNoEmpty((Object[])PayBillDts)) {
            List id = Arrays.stream(PayBillDts).map(o -> o.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
            ids.addAll(id);
        }
        Map payBillStatusMap = Arrays.stream(PayBillDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        Map cs195s = SystemParameterHelper.getSystemParamsByOrgIds(ids, (String)"cs195");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payBill;
            DynamicObject paymentIdentify;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Boolean payBool = false;
            if ("cas_agentpaybill".equals(dynamicObject.getString("sourcetype"))) {
                Boolean tempBool = true;
                DynamicObject agentBill = (DynamicObject)billStatusMap.get(dynamicObject.getLong("sourcebillid"));
                String billStatus = agentBill.getString("billstatus");
                String orgId = String.valueOf(agentBill.getDynamicObject("org").getLong("id"));
                String cs195 = (String)cs195s.get(orgId);
                boolean isRepay = agentBill.getBoolean("isrepay");
                if ("paychg".equals(dynamicObject.getString("chgtype"))) {
                    if (StringUtils.isNotEmpty((CharSequence)cs195) && cs195.contains(billStatus)) {
                        tempBool = false;
                    } else if ("A".equals(billStatus) && isRepay) {
                        tempBool = false;
                    }
                    if (tempBool.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u5ba1\u6838\u72b6\u6001\u6216\u8005\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u4ed8\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayInfoChgSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)cs195) && cs195.contains(billStatus)) {
                        tempBool = false;
                    } else if ("A".equals(billStatus) && isRepay) {
                        tempBool = false;
                    }
                    if (tempBool.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u6682\u5b58\u3001\u5df2\u63d0\u4ea4\u3001\u5df2\u5ba1\u6838\u72b6\u6001\u6216\u8005\u5931\u8d25\u91cd\u4ed8\u751f\u6210\u6682\u5b58\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"PayInfoChgSaveValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            } else if ("cas_paybill".equals(dynamicObject.getString("sourcetype")) && EmptyUtil.isNoEmpty((DynamicObject)(paymentIdentify = (payBill = (DynamicObject)payBillStatusMap.get(dynamicObject.getLong("sourcebillid"))).getDynamicObject("paymentidentify"))) && "1".equals(paymentIdentify.getString("type"))) {
                payBool = true;
            }
            if (dynamicObject.getString("chgtype").equals("recchg") && dynamicObject.getString("sourcetype").equals("cas_payapplybill")) {
                return;
            }
            long orgId = 0L;
            DynamicObject org = null;
            orgId = !(dynamicObject.get("org") instanceof Long) ? ((org = dynamicObject.getDynamicObject("org")) == null ? 0L : Long.parseLong(org.getPkValue().toString())) : (Long)dynamicObject.get("org");
            String sourceType = dynamicObject.getString("sourcetype");
            DynamicObjectCollection entrys = (DynamicObjectCollection)dynamicObject.get("entrys");
            for (DynamicObject entry : entrys) {
                DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)orgId);
                boolean cs103 = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs103");
                Date afterbizdate = entry.getDate("afterbizdate");
                if (!cs103 && afterbizdate != null && currentPeriod != null && afterbizdate.before(currentPeriod.getDate("beginDate"))) {
                    if ("cas_paybill".equals(sourceType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u5f53\u524d\u671f\u95f4\u4e4b\u524d\u7684\u4ed8\u6b3e\u5355\u3002", (String)"PaymentErrorCode_0", (String)"fi-cas-business", (Object[])new Object[0]));
                        continue;
                    }
                    if ("cas_agentpaybill".equals(sourceType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5f55\u5165\u5f53\u524d\u671f\u95f4\u4e4b\u524d\u7684\u4ee3\u53d1\u5355\u3002", (String)"AgentPayErrorCode_37", (String)"fi-cas-business", (Object[])new Object[0]));
                        continue;
                    }
                }
                String afterpaychannel = entry.getString("afterpaychannel");
                if (payBool.booleanValue() && PaymentChannelEnum.BEI.getValue().equals(afterpaychannel)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u5355\u4ed8\u6b3e\u6807\u8bc6\u7c7b\u522b\u4e3a\u88ab\u52a8\uff0c\u652f\u4ed8\u6e20\u9053\u4e0d\u5e94\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentSaveValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String afterRecerName = entry.getString("afterrecername");
                String changeRecAcctBank = entry.getString("changerecacctbank");
                boolean isClearValidForRecInfo = this.isClearValidForRecInfoExt();
                if (isClearValidForRecInfo || !EmptyUtil.isNoEmpty((String)afterRecerName) || !EmptyUtil.isNoEmpty((String)changeRecAcctBank)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5b9e\u540d\u548c\u6536\u6b3e\u8d26\u53f7\u4e0d\u5141\u8bb8\u540c\u65f6\u53d8\u66f4\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"PaymentSaveValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private Boolean isClearValidForRecInfoExt() {
        PluginProxy pluginProxy = PluginProxy.create(IPayChgBillInterface.class, (String)"kd.sdk.fi.cas.extpoint.paybill.IPayChgBillInterface.isClearValidForRecInfoExt");
        List resultList = pluginProxy.callReplace(p -> p.isClearValidForRecInfoExt());
        if (EmptyUtil.isNoEmpty((Object)resultList) && EmptyUtil.isNoEmpty(resultList.get(0))) {
            logger.info("\u652f\u4ed8\u4fe1\u606f\u53d8\u66f4\u5355 -- \u662f\u5426\u6e05\u9664\u201c\u6536\u6b3e\u4eba\u5b9e\u540d\u201d\u4e0e\u201c\u6536\u6b3e\u8d26\u53f7\u201d\u5b57\u6bb5\u540c\u65f6\u53d8\u66f4\u6821\u9a8c\u6269\u5c55\u8fd4\u56de\u7ed3\u679c:" + resultList.get(0));
            return (Boolean)resultList.get(0);
        }
        return Boolean.FALSE;
    }
}

