/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.claimbill;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.helper.RefundValidatorHelper;
import org.apache.commons.lang3.StringUtils;

public class ClaimBillAutoRenoteValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] claimBills = this.getDataEntities();
        List orgIds = Arrays.stream(this.dataEntities).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).distinct().collect(Collectors.toList());
        Map orgParams = SystemParameterHelper.getSystemParamsByOrgIds(orgIds);
        for (ExtendedDataEntity claimBillEntity : claimBills) {
            String msg;
            String lineInfo;
            List<Integer> lineNos;
            DynamicObject claimBill = claimBillEntity.getDataEntity();
            long orgId = DynamicObjectHelper.getPk((DynamicObject)claimBill, (String)"org");
            boolean bankAutoRefund = ((Map)orgParams.get(String.valueOf(orgId))).getOrDefault("detail_auto_refund", false);
            if (!bankAutoRefund || !this.checkHasRenoteSource(claimBill)) continue;
            DynamicObjectCollection entryList = claimBill.getDynamicObjectCollection("entryentity");
            Set<String> coreBillTypes = RefundValidatorHelper.getPayAndAgentCoreBillTypes(entryList);
            if (coreBillTypes.size() > 1) {
                String msg2 = ResManager.loadKDString((String)"\u5f53\u524d\u8ba4\u9886\u6d41\u6c34\u4e3a\u9000\u7968\u6d41\u6c34\uff0c\u53ea\u5141\u8bb8\u5173\u8054\u540c\u4e00\u7c7b\u5355\u636e\u8fdb\u884c\u9000\u7968\uff0c\u8bf7\u4fee\u6539\u8ba4\u9886\u660e\u7ec6\u4e2d\u7684\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u540c\u4e00\u7c7b\u3002", (String)"ClaimBillAutoRenoteValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(claimBillEntity, msg2);
                continue;
            }
            if (coreBillTypes.contains("cas_paybill")) {
                lineNos = RefundValidatorHelper.checkPayBillIsSelectSame(entryList);
                if (!lineNos.isEmpty()) {
                    lineInfo = StringUtils.join(lineNos, (String)"\u3001");
                    msg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5173\u8054\u7684\u662f\u540c\u4e00\u5355\u636e\uff0c\u8bf7\u4fdd\u8bc1\u5173\u8054\u7ef4\u5ea6\u7edf\u4e00\uff08\u5168\u90e8\u5173\u8054\u5230\u6574\u5355\u6216\u5168\u90e8\u5173\u8054\u5230\u660e\u7ec6\uff09\u3002", (String)"ClaimBillAutoRenoteValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(claimBillEntity, String.format(msg, lineInfo));
                    continue;
                }
                List<DynamicObject> payBills = RefundValidatorHelper.getPayBillsByCoreEntrys(entryList);
                if (RefundValidatorHelper.checkDifferCurrencyPay(payBills)) {
                    msg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u4e0e\u975e\u5f02\u5e01\u79cd\u4ed8\u6b3e\u5355\u540c\u65f6\u5173\u8054\u540c\u4e00\u7b14\u6536\u6b3e\u8fdb\u884c\u9000\u7968\u6216\u9000\u6b3e\u3002", (String)"RecAutoRenoteValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(claimBillEntity, msg);
                    continue;
                }
                if (!RefundValidatorHelper.checkPayBillIsFullRenote(entryList, payBills, "e_receivableamt")) {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u8ba4\u9886\u6d41\u6c34\u4e3a\u9000\u7968\u6d41\u6c34\uff0c\u5373\u4e00\u6b21\u6027\u5168\u989d\u9000\u56de\u3002\u56e0\u6b64\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u6216\u4ee3\u53d1\u5206\u5f55\u7684\u53ef\u9000\u91d1\u989d\u9700\u4e0e\u6240\u5728\u884c\u6536\u6b3e\u91d1\u989d\u5b8c\u5168\u4e00\u81f4\u3002", (String)"ClaimBillAutoRenoteValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(claimBillEntity, msg);
                    continue;
                }
            }
            if (!coreBillTypes.contains("cas_agentpaybill")) continue;
            lineNos = RefundValidatorHelper.checkAgentBillIsSelectEntry(entryList);
            if (!lineNos.isEmpty()) {
                lineInfo = StringUtils.join(lineNos, (String)"\u3001");
                msg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u5173\u8054\u7684\u6838\u5fc3\u5355\u636e\u662f\u4ee3\u53d1\u5355\uff0c\u8bf7\u4fdd\u8bc1\u5173\u8054\u5230\u4ee3\u53d1\u660e\u7ec6\u3002", (String)"RecAutoRenoteValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(claimBillEntity, String.format(msg, lineInfo));
                continue;
            }
            if (RefundValidatorHelper.checkAgentBillIsFullRenote(entryList, "e_receivableamt")) continue;
            String msg3 = ResManager.loadKDString((String)"\u5f53\u524d\u8ba4\u9886\u6d41\u6c34\u4e3a\u9000\u7968\u6d41\u6c34\uff0c\u5373\u4e00\u6b21\u6027\u5168\u989d\u9000\u56de\u3002\u56e0\u6b64\u5173\u8054\u7684\u4ed8\u6b3e\u5355\u6216\u4ee3\u53d1\u5206\u5f55\u7684\u53ef\u9000\u91d1\u989d\u9700\u4e0e\u6240\u5728\u884c\u6536\u6b3e\u91d1\u989d\u5b8c\u5168\u4e00\u81f4\u3002", (String)"ClaimBillAutoRenoteValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(claimBillEntity, msg3);
        }
    }

    private boolean checkHasRenoteSource(DynamicObject claimBill) {
        QFilter filter;
        DynamicObject claimNoticeBill;
        Long sourceId;
        HashSet<String> transDetailNos = new HashSet<String>();
        String tradedetailno = claimBill.getString("tradedetailno");
        if (StringUtils.isNotBlank((CharSequence)tradedetailno)) {
            transDetailNos.add(tradedetailno);
        }
        if (EmptyUtil.isNoEmpty((Long)(sourceId = Long.valueOf(claimBill.getLong("sourceid")))) && (claimNoticeBill = QueryServiceHelper.queryOne((String)"cas_claimcenterbill", (String)"id,mergestatus", (QFilter[])(filter = new QFilter("id", "=", (Object)sourceId)).toArray())) != null && MergeStatusEnum.ALMARGE.getValue().equals(claimNoticeBill.getString("mergestatus"))) {
            List margeBills = RecClaimHelper.getAllChildNoticeBill((Object)sourceId);
            Set mergeTradeDetailNos = margeBills.stream().map(m -> m.getString("tradedetailno")).collect(Collectors.toSet());
            transDetailNos.addAll(mergeTradeDetailNos);
        }
        if (!transDetailNos.isEmpty()) {
            filter = new QFilter("billno", "in", (Object)tradedetailno);
            DynamicObjectCollection transDetailList = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,refundsource", (QFilter[])filter.toArray());
            return transDetailList.stream().allMatch(d -> StringUtils.isNotBlank((CharSequence)d.getString("refundsource")));
        }
        return false;
    }
}

