/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.entrust;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasBotpHelper;

public class PaymentOrAgentEntrustValidator
extends AbstractValidator {
    public void validate() {
        String entrustOrgKey;
        String billName;
        ExtendedDataEntity[] payOrAgentEntitys = this.getDataEntities();
        String entityType = this.getEntityKey();
        if ("cas_paybill".equals(entityType)) {
            billName = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355", (String)"PaymentOrAgentEntrustValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            entrustOrgKey = "entrustorg";
        } else {
            billName = ResManager.loadKDString((String)"\u4ee3\u53d1\u5355", (String)"PaymentOrAgentEntrustValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            entrustOrgKey = "delegorg";
        }
        for (ExtendedDataEntity payOrAgentEntity : payOrAgentEntitys) {
            QFilter qFilter;
            boolean existEntrustBill;
            DynamicObject payOrAgentBill = payOrAgentEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(payOrAgentBill.getString("billstatus"))) {
                String msg = ResManager.loadKDString((String)"\u975e\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\u4e0d\u80fd\u59d4\u6258\u4ed8\u6b3e\u3002", (String)"PaymentOrAgentEntrustValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, msg);
                continue;
            }
            Object entrustOrg = payOrAgentBill.get(entrustOrgKey);
            if (entrustOrg == null) {
                String msg = ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentOrAgentEntrustValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, msg);
                continue;
            }
            Set targetBillIds = CasBotpHelper.getDestBillBySrcBill((String)entityType, (Long)((Long)payOrAgentBill.getPkValue()), (String)entityType);
            if (!targetBillIds.isEmpty() && (existEntrustBill = QueryServiceHelper.exists((String)entityType, (QFilter[])(qFilter = new QFilter("id", "in", (Object)targetBillIds).and("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue())).toArray()))) {
                String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u59d4\u6258\u4ed8\u6b3e\u5355\u636e\u3002", (String)"PaymentOrAgentEntrustValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(payOrAgentEntity, msg);
                continue;
            }
            BigDecimal entrustAmt = payOrAgentBill.getBigDecimal("entrustamt");
            if (entrustAmt.abs().compareTo(payOrAgentBill.getBigDecimal("dpamt").abs()) < 0) continue;
            String msgFmt = ResManager.loadKDString((String)"\u59d4\u6258\u4ed8\u6b3e\u5931\u8d25\uff0c%1$s[%2$s]\u5df2\u5168\u989d\u59d4\u6258\u4ed8\u6b3e\u3002", (String)"PaymentOrAgentEntrustValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(payOrAgentEntity, String.format(msgFmt, billName, payOrAgentBill.getString("billno")));
        }
    }
}

