/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.journal;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.BalanceAdjustHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.StringUtils;

public class BankJournalDeleteValidate
extends AbstractValidator {
    private static final String SOURCE_ONE = "1";
    private static final String SOURCE_THREE = "3";
    private static final String SOURCE_FIVE = "5";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Date bookDate;
            DynamicObject balanceAdust;
            String entryName;
            QFilter filter;
            DynamicObject[] initDys;
            if (this.getOption() != null && this.getOption().containsVariable("delByOp")) continue;
            DynamicObject bankJournal = dataEntity.getDataEntity();
            DynamicObject org = bankJournal.getDynamicObject("org");
            DynamicObject currency = bankJournal.getDynamicObject("currency");
            if (!StringUtils.equalAllValues((String)bankJournal.getString("source"), (String[])new String[]{SOURCE_ONE, SOURCE_THREE, SOURCE_FIVE}).booleanValue()) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53ea\u80fd\u522a\u9664\u624b\u5de5\u5f55\u5165/\u6807\u51c6\u5bfc\u5165/\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u65e5\u8bb0\u8d26\u6570\u636e\u3002", (String)"ManualJournalFromPlugin_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (!CasHelper.isEmpty((DynamicObject[])(initDys = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"startperiod,currentperiod", (QFilter[])new QFilter[]{filter = new QFilter("org", "=", (Object)org.getLong("id"))})))) {
                DynamicObject init = initDys[0];
                DynamicObject currPeriod = init.getDynamicObject("currentperiod");
                DynamicObject period = bankJournal.getDynamicObject("period");
                if (currPeriod != null && period != null && PeriodHelper.before((DynamicObject)bankJournal.getDynamicObject("period"), (DynamicObject)currPeriod)) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"ManualJournalFromPlugin_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
            if (!"cas_bankjournal".equals(entryName = bankJournal.getDynamicObjectType().getName())) continue;
            if (bankJournal.getBoolean("ischeck")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5df2\u52fe\u5bf9\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ManualJournalFromPlugin_5", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            DynamicObject accountBank = bankJournal.getDynamicObject("accountbank");
            boolean parameterBoolean = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"cs095");
            if (parameterBoolean || (balanceAdust = BalanceAdjustHelper.getLastBalanceAdjust((Long)org.getLong("id"), (Long)accountBank.getLong("id"), (Long)currency.getLong("id"))) == null || !BillStatusEnum.AUDIT.getValue().equals(balanceAdust.getString("billstatus")) && !BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")) || (bookDate = bankJournal.getDate("bookdate")) == null) continue;
            Date date = balanceAdust.getDate("bizdate");
            if (date.after(bookDate)) {
                String billSatus = BillStatusEnum.SUBMIT.getValue().equals(balanceAdust.getString("billstatus")) ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"ManualJournalFromPlugin_0", (String)"fi-cas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ManualJournalFromPlugin_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e5\u8bb0\u8d26\u5df2\u751f\u6210\u201c%1$s\u201d\u72b6\u6001\u7684\u4f59\u989d\u8c03\u8282\u8868\u201c%2$s\u201d\u3002", (String)"ManualJournalFromPlugin_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), billSatus, balanceAdust.getString("billno")));
            }
            if (CasHelper.isEmpty((DynamicObject[])initDys)) continue;
            DynamicObject init = initDys[0];
            DynamicObject currPeriod = init.getDynamicObject("currentperiod");
            DynamicObject period = bankJournal.getDynamicObject("period");
            if (currPeriod == null || period == null || !PeriodHelper.before((DynamicObject)bankJournal.getDynamicObject("period"), (DynamicObject)currPeriod)) continue;
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u7ed3\u8d26\u3002", (String)"ManualJournalFromPlugin_3", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

