/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.Date;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.fi.cas.util.DateUtils;

public class PaymentCrossTranValidator
extends AbstractValidator {
    private static Pattern pattern = Pattern.compile("[0-9]*");

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Date maxDate;
            Date expectDate;
            boolean isCrossPay;
            DynamicObject info = dataEntity.getDataEntity();
            boolean isdiffcur = info.getBoolean("isdiffcur");
            if (isdiffcur) {
                DynamicObject currency = info.getDynamicObject("currency");
                DynamicObject recCurrency = info.getDynamicObject("dpcurrency");
                if (currency != null && recCurrency != null && ((Long)currency.getPkValue()).longValue() == ((Long)recCurrency.getPkValue()).longValue()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u4ed8\u6b3e\u5e01\u79cd\u4e00\u81f4\uff0c\u8bf7\u9009\u62e9\u975e\u5f02\u5e01\u79cd\u4ed8\u6b3e\u3002", (String)"PaymentCrossTranValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                } else {
                    String contractno = info.getString("contractno");
                    if (StringUtils.hasLength((String)contractno) && (contractno.length() != 6 || !this.isNumeric(contractno))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5151\u6362\u5408\u7ea6\u53f7\u5fc5\u987b\u4e3a\u516d\u4f4d\u6570\u5b57\u3002", (String)"PaymentCrossTranValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            if (!(isCrossPay = info.getBoolean("iscrosspay"))) continue;
            DynamicObject crossTranType = info.getDynamicObject("crosstrantype");
            if (crossTranType == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8de8\u5883\u652f\u4ed8\u65f6\uff0c\u4ea4\u6613\u7c7b\u578b\u5fc5\u586b\u3002", (String)"PaymentCrossTranValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((expectDate = info.getDate("expectdate")) == null || expectDate.compareTo(maxDate = DateUtils.getNextDay((Date)DateUtils.getCurrentDate(), (int)50)) <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u4ec5\u652f\u630150\u5929\u5185\u7684\u9884\u7ea6\u4ea4\u6613\uff0c\u671f\u671b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u5f97\u8d85\u51fa\u8303\u56f4\u3002", (String)"PaymentCrossTranValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNumeric(String str) {
        return pattern.matcher(str).matches();
    }
}

