/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PaymentTypeEnum;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentTypeValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(PaymentTypeValidator.class);

    public void validate() {
        logger.info("PaymentTypeValidator validate start");
        List orgIds = Arrays.stream(this.dataEntities).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("org"))).map(s -> s.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map selectallpayeetypes = SystemParameterHelper.getSystemParamsByOrgIds(orgIds, (String)"selectallpayeetype");
        block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean ispartpayment;
            DynamicObject e_paymenttype;
            DynamicObject info = dataEntity.getDataEntity();
            String sourceBillType = info.getString("sourcebilltype");
            String orgId = String.valueOf(EmptyUtil.isNoEmpty((DynamicObject)info.getDynamicObject("org")) ? info.getDynamicObject("org").getLong("id") : 0L);
            String entrance = info.getString("entrance");
            boolean multipaymenttype = info.getBoolean("multipaymenttype");
            String payeetype = info.getString("payeetype");
            DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
            if (PaymentTypeValidator.isApAr(sourceBillType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                for (DynamicObject entry : entrys) {
                    e_paymenttype = entry.getDynamicObject("e_paymenttype");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)e_paymenttype) || (ispartpayment = e_paymenttype.getBoolean("ispartpayment"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u6709\u8d22\u52a1\u5e94\u4ed8\u5355\u3001\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u4ed8\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u3002", (String)"PaymentTypeValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) && "pm_purorderbill".equals(sourceBillType)) {
                for (DynamicObject entry : entrys) {
                    e_paymenttype = entry.getDynamicObject("e_paymenttype");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)e_paymenttype)) continue;
                    ispartpayment = e_paymenttype.getBoolean("ispartpayment");
                    String biztype = e_paymenttype.getString("biztype");
                    if (ispartpayment && "202".equals(biztype)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u662f\u91c7\u8d2d\u8ba2\u5355\uff0c\u4ed8\u6b3e\u7c7b\u578b\u5fc5\u987b\u662f\u53c2\u4e0e\u5e94\u4ed8\u7ed3\u7b97\u4e14\u4e1a\u52a1\u7c7b\u578b\u4e3a\u9884\u4ed8\u6b3e\u3002", (String)"PaymentTypeValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            boolean selectallPayertype = (Boolean)selectallpayeetypes.get(orgId);
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys) || !multipaymenttype || selectallPayertype || !PaymentTypeEnum.AP.name().equals(entrance) && !PaymentTypeEnum.OTR.name().equals(entrance)) continue;
            for (DynamicObject entry : entrys) {
                boolean ispartpayment2;
                DynamicObject e_paymenttype2 = entry.getDynamicObject("e_paymenttype");
                if (e_paymenttype2 == null || !(ispartpayment2 = e_paymenttype2.getBoolean("ispartpayment")) || !AsstActTypeEnum.OTHER.getValue().equals(payeetype) && !AsstActTypeEnum.COMPANY.getValue().equals(payeetype)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u4e2d\u5b58\u5728\u53c2\u4e0e\u7ed3\u7b97\u7684\u4ed8\u6b3e\u7c7b\u578b\uff0c\u5339\u914d\u7684\u6536\u6b3e\u4eba\u7c7b\u578b\u662f\u3010\u4f9b\u5e94\u5546/\u5ba2\u6237/\u804c\u5458\u3011\u3002", (String)"PaymentTypeValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
        logger.info("PaymentTypeValidator validate end");
    }

    private static boolean isApAr(String sourceBillType) {
        return "ar_finarbill".equals(sourceBillType) || "ap_finapbill".equals(sourceBillType);
    }
}

