/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.paymentbill;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.cas.enums.BillStatusEnum;

public class UrgentPayValidator
extends AbstractValidator {
    public void validate() {
        Set statusList = Stream.of(BillStatusEnum.PAY.getValue(), BillStatusEnum.BEING.getValue(), BillStatusEnum.DRAFTING.getValue(), BillStatusEnum.RENOTE.getValue(), BillStatusEnum.REFUND.getValue(), BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue()).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject payBill = dataEntity.getDataEntity();
            if (!statusList.contains(payBill.get("billstatus")) && !Boolean.TRUE.equals(payBill.getBoolean("urgentflag"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58/\u5df2\u63d0\u4ea4/\u5df2\u5ba1\u6838\u7684 \u4e14 \u52a0\u6025\u652f\u4ed8\u6807\u8bc6\u4e3a\u5426 \u652f\u6301\u52a0\u6025\u4ed8\u6b3e\u3002", (String)"UrgentPayValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

