/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recchg;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;

public class ReceivingBillChgValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            BigDecimal actrecAmt;
            BigDecimal actrecAmtsour;
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)data.get("sourcebillid"), (String)data.getString("sourcebilltype"));
            if (recBill == null) continue;
            String sourcebillNumber = recBill.getString("billno");
            if (CasHelper.isNotEmpty((Object)recBill.getString("hotaccount"))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u201c%s\u201d\u5df2\u53d1\u751f\u7ea2\u51b2\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4e1a\u52a1\u53d8\u66f4\u3002", (String)"ReceivingBillChgValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), sourcebillNumber), ErrorLevel.Error);
            }
            if ((actrecAmtsour = data.getBigDecimal("actrecamtsour")).compareTo(actrecAmt = data.getBigDecimal("actrecamt")) == 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u660e\u7ec6\u603b\u91d1\u989d\u4e0e\u539f\u6536\u6b3e\u5355\u7684\u6536\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4\u3002", (String)"ReceivingBillChgValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

