/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.util.StringUtils;

public class ClaimControlSaveValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ClaimControlSaveValidator.class);

    public void validate() {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        boolean currentUserPer = PermissionHelper.checkCurrentUserPermission((String)appId, (long)RequestContext.get().getOrgId(), (String)"cas_claimcontrol", (String)"0=KX5+QVF5+R");
        logger.info("ClaimControlSaveValidator+CurrentUserPermission:" + currentUserPer);
        for (ExtendedDataEntity data : this.dataEntities) {
            if (!currentUserPer) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u8ba4\u9886\u63a7\u5236\u8bbe\u7f6e\u201d\u7684\u201c\u4fdd\u5b58\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ClaimBillSaveValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
            DynamicObject claimConData = data.getDataEntity();
            DynamicObjectCollection entryCol = claimConData.getDynamicObjectCollection("entry");
            Map<String, List<DynamicObject>> coreBillTypeMap = entryCol.stream().filter(k -> StringUtils.isNotEmpty((String)k.getString("corebilltype"))).collect(Collectors.groupingBy(o -> o.getString("corebilltype")));
            for (DynamicObject entry : entryCol) {
                String coreBillType = entry.getString("corebilltype");
                if (CasHelper.isNotEmpty((Object)coreBillType)) {
                    List<DynamicObject> list = coreBillTypeMap.get(coreBillType);
                    if (null != list && list.size() > 1) {
                        String msg = ResManager.loadKDString((String)"\u8ba4\u9886\u63a7\u5236\u9762\u677f\u4e2d\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u552f\u4e00\u3002", (String)"ClaimBillSaveValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                        this.addMessage(data, msg, ErrorLevel.Error);
                        continue;
                    }
                    String lat = entry.getString("claimdimension");
                    if (!StringUtils.isEmpty((String)lat)) continue;
                    String msg = ResManager.loadKDString((String)"\u8ba4\u9886\u63a7\u5236\u9762\u677f\u4e2d\u8ba4\u9886\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSaveValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, msg, ErrorLevel.Error);
                    continue;
                }
                String msg = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClaimBillSaveValidator_13", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
    }
}

