/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recclaim;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;

public class RecClaimToAccountValidator
extends AbstractValidator {
    public void validate() {
        List claimIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getPkValue()).collect(Collectors.toList());
        DynamicObject[] claimNoticeDts = BusinessDataServiceHelper.load((Object[])claimIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"));
        Map claimNoticeMap = Arrays.stream(claimNoticeDts).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"cas_claimcenterbill").and(new QFilter("sourcebillid", "in", claimIdList).and(new QFilter("billstatus", "in", (Object)new Object[]{BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), "E"})));
        DynamicObject[] recBillDts = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,sourcebillid,billno,billstatus", (QFilter[])new QFilter[]{qFilter});
        Map<Object, List<DynamicObject>> recBillGroupMap = Arrays.stream(recBillDts).collect(Collectors.groupingBy(o -> o.get("sourcebillid")));
        List orgIdList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toList());
        Map pushMap = SystemParameterHelper.getSystemParamsByOrgIds(orgIdList, (String)"cs113");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String msg;
            DynamicObject info = dataEntity.getDataEntity();
            BigDecimal payAmount = info.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal claimedamount = info.getBigDecimal("claimedamount");
                BigDecimal sumpay = BigDecimal.ZERO;
                BigDecimal sumact = BigDecimal.ZERO;
                BigDecimal claimNotAmount = BigDecimal.ZERO;
                DynamicObjectCollection payentityCol = info.getDynamicObjectCollection("payentity");
                for (DynamicObject payentity : payentityCol) {
                    sumpay = sumpay.add(payentity.getBigDecimal("e_payableamt"));
                    sumact = sumact.add(payentity.getBigDecimal("e_payactamt"));
                }
                claimNotAmount = payAmount.subtract(info.getBigDecimal("fee")).add(sumpay).subtract(sumact);
                if (null == claimedamount || claimedamount.compareTo(claimNotAmount) == 0) continue;
                String msg2 = ResManager.loadKDString((String)"\u5df2\u8ba4\u9886\u91d1\u989d\u4e0d\u7b49\u4e8e\u53ef\u8ba4\u9886\u91d1\u989d\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u9a73\u56de\u6709\u8bef\u7684\u8ba4\u9886\u5355\u3002", (String)"RecClaimToAccountValidator_1_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg2, ErrorLevel.Error);
                continue;
            }
            info = (DynamicObject)claimNoticeMap.get(info.getPkValue());
            String claimstatus = info.getString("claimstatus");
            if (!(ClaimStatusEnum.CLAIMED.getValue().equals(claimstatus) || ClaimStatusEnum.APPEAL.getValue().equals(claimstatus) || ClaimStatusEnum.CHANGE.getValue().equals(claimstatus))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6536\u6b3e\u8ba4\u9886\u901a\u77e5\u5355\u72b6\u6001\u4e3a\u201c\u5df2\u8ba4\u9886\u201d\u3001\u201c\u7533\u8bc9\u4e2d\u201d\u6216\u201c\u53d8\u66f4\u4e2d\u201d\u65f6\uff0c\u65b9\u53ef\u8fdb\u884c\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u64cd\u4f5c\u3002", (String)"RecClaimToAccountValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            } else {
                BigDecimal oldrec = info.getDynamicObjectCollection("entryentity").stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal actAmt = info.getDynamicObjectCollection("entryentity").stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal oldfee = info.getDynamicObjectCollection("entryentity").stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal claimedamount = oldrec;
                BigDecimal reamount = info.getBigDecimal("reamount").add(info.getBigDecimal("fee")).subtract(oldfee).add(oldrec).subtract(actAmt);
                if (reamount.compareTo(claimedamount) != 0) {
                    String msg3 = ResManager.loadKDString((String)"\u5df2\u8ba4\u9886\u91d1\u989d\u4e0d\u7b49\u4e8e\u53ef\u8ba4\u9886\u91d1\u989d\uff08\u6536\u6b3e\u91d1\u989d+\u624b\u7eed\u8d39\u91d1\u989d+\u73b0\u91d1\u6298\u6263\u5408\u8ba1\uff09\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u9a73\u56de\u6709\u8bef\u7684\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimToAccountValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    this.addMessage(dataEntity, msg3, ErrorLevel.Error);
                }
            }
            Object billno = info.get("billno");
            Object currency = info.get("currency");
            Object bizdate = info.get("bizdate");
            Object recpaytype = info.get("recpaytype");
            Object paymenttype = info.get("paymenttype");
            Object recpayer = info.get("recpayer");
            if (billno == null || currency == null || bizdate == null || recpaytype == null || paymenttype == null || recpayer == null) {
                msg = ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u6709\u5fc5\u5f55\u5b57\u6bb5\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RecClaimToAccountValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
            }
            if (ClaimStatusEnum.SURE.getValue().equals(claimstatus)) {
                msg = ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u5df2\u7ecf\u786e\u8ba4\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"RecClaimToAccountValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
            }
            if (MergeStatusEnum.MARFED.getValue().equals(info.getString("mergestatus"))) {
                msg = ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u5355\u5df2\u7ecf\u88ab\u5408\u5e76\uff0c\u8bf7\u64cd\u4f5c\u5408\u5e76\u5355\u3002", (String)"RecClaimToAccountValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
            }
            List<DynamicObject> recBillList = recBillGroupMap.get(info.getPkValue());
            String changeType = (String)pushMap.get(info.getDynamicObject("org").getString("id"));
            if (CasHelper.isEmpty(recBillList)) continue;
            for (DynamicObject recBill : recBillList) {
                if (BillStatusEnum.SUBMIT.getValue().equals(recBill.getString("billstatus"))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u539f\u4e0b\u6e38\u6536\u6b3e\u5355\u201c%s\u201d\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\uff0c\u8bf7\u5148\u64a4\u9500\u6536\u6b3e\u5355\uff0c\u518d\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimToAccountValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]), recBill.getString("billno"), ErrorLevel.Error));
                    continue;
                }
                if (BillStatusEnum.AUDIT.getValue().equals(recBill.getString("billstatus"))) {
                    if (!"1".equals(changeType)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u539f\u4e0b\u6e38\u6536\u6b3e\u5355(%s)\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u53cd\u5ba1\u6838\u6536\u6b3e\u5355\uff0c\u518d\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimToAccountValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]), recBill.getString("billno"), ErrorLevel.Error));
                    continue;
                }
                if (!"E".equals(recBill.getString("billstatus"))) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u539f\u4e0b\u6e38\u6536\u6b3e\u5355\u201c%s\u201d\u72b6\u6001\u4e3a\u53d8\u66f4\u4e2d\uff0c\u8bf7\u53d6\u6d88\u53d8\u66f4\u6216\u8005\u8d70\u5b8c\u53d8\u66f4\u6d41\u7a0b\uff0c\u518d\u786e\u8ba4\u8ba4\u9886\u7ed3\u679c\u3002", (String)"RecClaimToAccountValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]), recBill.getString("billno"), ErrorLevel.Error));
            }
        }
    }
}

