/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbill;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.ManualMatchHelper;
import kd.fi.cas.dao.MatchRangeInfo;

public class BizBillMatchDetailValidator
extends AbstractValidator {
    private Set<String> withoutStatus;

    public BizBillMatchDetailValidator(Set<String> withoutStatus) {
        this.withoutStatus = withoutStatus;
    }

    public void validate() {
        Set matchFlagSet = Stream.of("0", "2").collect(Collectors.toSet());
        if (this.dataEntities.length == 1) {
            boolean checkPass;
            DynamicObject bizBill = this.dataEntities[0].getDataEntity();
            String matchFlag = bizBill.getString("matchflag");
            String billStatus = bizBill.getString("billstatus");
            boolean bl = checkPass = matchFlagSet.contains(matchFlag) && !this.withoutStatus.contains(billStatus);
            if (!checkPass) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u65e0\u9700\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u3002", (String)"BizBillMatchDetailValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                return;
            }
            Set<Long> idSet = this.getDataByRangeQFilter(bizBill, Collections.singleton(bizBill.getLong("id")));
            if (idSet.size() < this.dataEntities.length) {
                this.addErrorMessage(this.dataEntities[0], ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u65e0\u9700\u5339\u914d\u4ea4\u6613\u660e\u7ec6\u3002", (String)"BizBillMatchDetailValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        } else if (this.dataEntities.length > 1) {
            LinkedHashMap<Long, String> noMatchBillMap = new LinkedHashMap<Long, String>(this.dataEntities.length);
            Map<Long, String> allDataMap = Arrays.stream(this.dataEntities).collect(Collectors.toMap(d -> d.getDataEntity().getLong("id"), d -> d.getDataEntity().getString("billno")));
            List checkNoPassList = Arrays.stream(this.dataEntities).filter(d -> !matchFlagSet.contains(d.getDataEntity().getString("matchflag")) || this.withoutStatus.contains(d.getDataEntity().getString("billstatus"))).collect(Collectors.toList());
            for (ExtendedDataEntity data : checkNoPassList) {
                noMatchBillMap.put(data.getDataEntity().getLong("id"), data.getDataEntity().getString("billno"));
            }
            Set<Long> allIdSet = allDataMap.keySet();
            allIdSet.removeAll(noMatchBillMap.keySet());
            DynamicObject bizBill = this.dataEntities[0].getDataEntity();
            Set<Long> idSet = this.getDataByRangeQFilter(bizBill, allIdSet);
            allIdSet.removeAll(idSet);
            noMatchBillMap.putAll(allDataMap);
            if (!noMatchBillMap.isEmpty()) {
                this.getOption().setVariableValue("noMatchBillNo", JSON.toJSONString(noMatchBillMap));
            }
        }
    }

    private Set<Long> getDataByRangeQFilter(DynamicObject bizBill, Set<Long> idSet) {
        String entryName;
        Long orgId = (Long)bizBill.getDynamicObject("org").getPkValue();
        MatchRangeInfo rangeInfo = ManualMatchHelper.getBizBillQFilter((Long)orgId, (String)(entryName = bizBill.getDynamicObjectType().getName()), (Boolean)true);
        if (rangeInfo.getRangeQFilter() != null) {
            QFilter idQFilter = new QFilter("id", "in", idSet);
            idQFilter.and(rangeInfo.getRangeQFilter());
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{idQFilter});
            return queryData.stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
        }
        return idSet;
    }
}

