/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingRefundAndReturnMoneyBackValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(ReceivingRefundAndReturnMoneyBackValidator.class);

    public void validate() {
        Map variables = this.getOption().getVariables();
        String billType = (String)variables.get("billtype");
        Long billId = Long.valueOf(variables.get("billid") == null ? "0" : (String)variables.get("billid"));
        Long entryId = Long.valueOf(variables.get("entryid") == null ? "0" : (String)variables.get("entryid"));
        ExtendedDataEntity data = this.dataEntities[0];
        DynamicObject recbill = data.getDataEntity();
        long rebillId = recbill.getLong("id");
        BigDecimal actrecamt = recbill.getBigDecimal("actrecamt");
        DynamicObjectCollection recCol = recbill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_receivableamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ("cas_paybill".equals(billType)) {
            DynamicObjectCollection payCol;
            BigDecimal payAmtSum;
            DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_paybill");
            boolean isDiffCurrency = payBill.getBoolean("isdiffcur");
            if (isDiffCurrency) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\u9000\u6b3e\u9000\u7968\uff0c\u656c\u8bf7\u671f\u5f85\u540e\u7eed\u4f18\u5316\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (recAmtSum.compareTo(payAmtSum = (payCol = payBill.getDynamicObjectCollection("entry")).stream().map(o -> o.getBigDecimal("e_payableamt")).reduce(BigDecimal.ZERO, BigDecimal::add)) > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5e94\u6536\u91d1\u989d\u8d85\u8fc7\u6240\u9009\u4ed8\u6b3e\u5355\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u64cd\u4f5c\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            this.feeBillRefundVerify(payBill, payAmtSum, actrecamt, data);
            HashMap<Long, BigDecimal> refundAMtMap = new HashMap<Long, BigDecimal>(payCol.size());
            for (DynamicObject d : payCol) {
                BigDecimal e_refundamt_i = d.getBigDecimal("e_payableamt");
                if (e_refundamt_i.compareTo(recAmtSum) <= 0) {
                    recAmtSum = recAmtSum.subtract(e_refundamt_i);
                    refundAMtMap.put(d.getLong("id"), e_refundamt_i);
                    continue;
                }
                refundAMtMap.put(d.getLong("id"), recAmtSum);
                recAmtSum = BigDecimal.ZERO;
            }
            HashMap<String, HashMap<Long, BigDecimal>> params = new HashMap<String, HashMap<Long, BigDecimal>>();
            params.put("refundrowamts", refundAMtMap);
            WriteBackOperateEnum operateEnum = WriteBackOperateEnum.RENOTEVALIDATE;
            WriteBackValidateHelper.writeBackValidate((DynamicObject)payBill, (WriteBackOperateEnum)operateEnum, PaymentDisposeConsumer.class, params);
            String sourcebilltype = payBill.getString("sourcebilltype");
            if (!WriteBackValidateHelper.getOldValidateTypeBills().contains(sourcebilltype)) {
                boolean erValidateBill = WriteBackValidateHelper.isErValidateBill((String)sourcebilltype);
                String msg = WriteBackServiceImpl.getInstance().validate(payBill, operateEnum, PaymentDisposeConsumer.class, sourcebilltype, !erValidateBill);
                if (EmptyUtil.isNoEmpty((String)msg)) {
                    this.addErrorMessage(data, msg);
                }
            }
            List<String> tradeBillType = Arrays.asList("fl_rentpaybill", "lc_arrival", "lc_buyerint", "cim_finsubscribe", "cim_deposit", "cim_noticedeposit", "cim_invest_loanbill", "cfm_repaymentbill", "cfm_interestbill", "gm_letterofguarantee", "fbd_suretybill", "fbd_suretyreleasebill", "fbd_surety_append", "scf_fincreditbill", "scf_finrepaybill", "tm_businessbill", "tm_structdeposit", "tm_rateswap", "tm_forex_options");
            BigDecimal refundAmt = recbill.getBigDecimal("actrecamt");
            BigDecimal actRecAmtFee = refundAmt.add(recbill.getBigDecimal("fee"));
            BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
            Boolean isfullrefund = Boolean.TRUE;
            if (actRecAmtFee.compareTo(actpayamt) != 0) {
                isfullrefund = Boolean.FALSE;
            }
            logger.info(rebillId + "\u4ed8\u6b3e\u5355\u7f16\u53f7\uff1a" + payBill.getString("billno") + "\u4ed8\u6b3e\u5355\u91d1\u989d\uff1a" + actpayamt + "\u6536\u6b3e\u5355\u91d1\u989d\uff1a" + actRecAmtFee);
            if (!isfullrefund.booleanValue() && tradeBillType.contains(payBill.getString("sourcebilltype"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5b58\u5728\u4e0a\u6e38:%s\u4e0d\u5141\u8bb8\u64cd\u4f5c\u90e8\u5206\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[]{payBill.getString("sourcebillnumber")}));
            }
        } else if ("cas_agentpaybill".equals(billType)) {
            QFilter queryFilter = new QFilter("entry.id", "=", (Object)entryId);
            DynamicObject agentBill = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (String)"sourcebilltype,isdiffcur,entry.sourceentryid,entry.e_issuccess,entry.e_amount,entry.e_isrefund,entry.e_refundamt,entry.e_refunddes,entry.refundbillid,entry.refundtype", (QFilter[])new QFilter[]{queryFilter});
            boolean isDiffCurrency = agentBill.getBoolean("isdiffcur");
            if (isDiffCurrency) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\u9000\u6b3e\u9000\u7968\uff0c\u656c\u8bf7\u671f\u5f85\u540e\u7eed\u4f18\u5316\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = agentBill.getDynamicObjectCollection("entry");
            HashMap<String, Comparable<Boolean>> refundAInfoMap = new HashMap<String, Comparable<Boolean>>(0);
            for (DynamicObject row : entrys) {
                if (!entryId.equals(row.getLong("id"))) continue;
                refundAInfoMap.put("e_issuccess", Boolean.valueOf(false));
                refundAInfoMap.put("e_isrefund", Boolean.valueOf(true));
                refundAInfoMap.put("e_refundamt", recAmtSum);
                break;
            }
            HashMap params = new HashMap();
            WriteBackOperateEnum operateEnum = WriteBackOperateEnum.RENOTEVALIDATE;
            params.put("entryPks", Collections.singletonList(entryId));
            params.put("refundAInfoMap", refundAInfoMap);
            WriteBackValidateHelper.writeBackValidate((DynamicObject)agentBill, (WriteBackOperateEnum)operateEnum, AgentWriteBackConsumer.class, (Map)params);
            String sourcebilltype = agentBill.getString("sourcebilltype");
            if (!WriteBackValidateHelper.getOldValidateTypeBills().contains(sourcebilltype)) {
                boolean erValidateBill = WriteBackValidateHelper.isErValidateBill((String)sourcebilltype);
                String msg = WriteBackServiceImpl.getInstance().validate(agentBill, operateEnum, AgentWriteBackConsumer.class, sourcebilltype, !erValidateBill);
                if (EmptyUtil.isNoEmpty((String)msg)) {
                    this.addErrorMessage(data, msg);
                }
            }
        }
    }

    private void feeBillRefundVerify(DynamicObject payBill, BigDecimal payAmtSum, BigDecimal actrecamt, ExtendedDataEntity data) {
        String paySourceBillType = payBill.getString("sourcebilltype");
        if (EmptyUtil.isNotEmpty((String)paySourceBillType) && "cfm_feebill".equals(paySourceBillType)) {
            long feeBillId;
            DynamicObject feeBill;
            boolean issettle;
            if (payAmtSum.compareTo(actrecamt) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0e\u6536\u6b3e\u91d1\u989d\u4e0d\u76f8\u7b49\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!(issettle = (feeBill = QueryServiceHelper.queryOne((String)"cfm_feebill", (String)"id,issettle", (QFilter[])new QFilter("id", "=", (Object)(feeBillId = payBill.getLong("sourcebillid"))).toArray())).getBoolean("issettle"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6\u5355\u672a\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"ReceivingRefundAndReturnMoneyBackValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

