/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.receivingbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingRefundAndReturnMoneyContainIfmBackValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ReceivingRefundAndReturnMoneyContainIfmBackValidator.class);

    public void validate() {
        boolean isSettle;
        Map variables = this.getOption().getVariables();
        logger.info("ReceivingRefundBackVariables:" + variables.toString());
        String billType = (String)variables.get("billtype");
        Long billId = Long.valueOf(variables.get("billid") == null ? "0" : (String)variables.get("billid"));
        Long entryId = Long.valueOf(variables.get("entryid") == null ? "0" : (String)variables.get("entryid"));
        ExtendedDataEntity data = this.dataEntities[0];
        DynamicObject recBill = data.getDataEntity();
        Long rebillId = recBill.getLong("id");
        String operateKey = this.getOperateKey();
        if (EmptyUtil.isEmpty((String)billType) || EmptyUtil.isEmpty((Long)billId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u53c2\u6570\u5355\u636e\u7c7b\u578b\u548c\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        List<String> billTypes = Arrays.asList("cas_paybill", "cas_agentpaybill", "ifm_transhandlebill");
        if (!billTypes.contains(billType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u53c2\u6570\u7684\u5355\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if ("cas_agentpaybill".equals(billType) && EmptyUtil.isEmpty((Long)entryId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u5355\u636e\u7c7b\u578b\u4e3a\u4ee3\u53d1\u5904\u7406\u65f6\u4e3a\u53c2\u6570\u5206\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        String receivingTypeBizType = recBill.getString("receivingtype.biztype");
        boolean isSettleCenterCollect = PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue().equals(receivingTypeBizType);
        boolean isRefund = "refund_back".equals(operateKey) || "ifm_refund_back".equals(operateKey);
        boolean isReturnMoney = "returnmoney_back".equals(operateKey) || "ifm_returnmoney_back".equals(operateKey);
        logger.info("isSettleCenterCollect:" + isSettleCenterCollect);
        DynamicObjectCollection recCol = recBill.getDynamicObjectCollection("entry");
        BigDecimal recAmtSum = recCol.stream().map(o -> o.getBigDecimal("e_settledamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean bl = isSettle = recAmtSum.compareTo(BigDecimal.ZERO) > 0;
        if (isRefund) {
            Set srcBill;
            boolean isExist;
            if (DraftHelper.isDraftBill((Long)rebillId, (String)"cas_recbill")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u4e3a\u627f\u5151\u6c47\u7968\u3001\u652f\u7968\u6216\u672c\u7968\u7684\u6536\u6b3e\u5355\u4e0d\u652f\u6301\u9000\u7968\u64cd\u4f5c\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!RefundHelper.isPaid((Long)rebillId)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u786e\u8ba4\u9000\u7968\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u91cd\u590d\u9000\u7968\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!(isExist = this.checkBillOfRefund(isSettleCenterCollect, recBill, billType, billId, entryId))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u7968\u5931\u8d25\uff0c\u5173\u8054\u652f\u4ed8\u5355\u636e\u4e0d\u6ee1\u8db3\u786e\u8ba4\u9000\u7968\u6761\u4ef6\uff0c\u5177\u4f53\u786e\u8ba4\u9000\u7968\u6761\u4ef6\u8bf7\u67e5\u9605\u91d1\u8776\u4e91\u793e\u533a\u64cd\u4f5c\u624b\u518c\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isEmpty((Collection)(srcBill = CasBotpHelper.getSrcBillByDestBill((Long)rebillId, (String)"cas_recbill", (String)"cas_paybill")))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u7968\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_6", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (isSettle) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u9000\u7968\uff0c\u8bf7\u5148\u624b\u5de5\u53d6\u6d88\u7ed3\u7b97\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_7", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        } else if (isReturnMoney) {
            Set srcBill;
            boolean isExist;
            if (!RefundHelper.isPaid((Long)rebillId)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u6536\u6b3e\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_8", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (RefundHelper.isRefund((Long)rebillId)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u9000\u6b3e\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u91cd\u590d\u9000\u6b3e\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_9", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!(isExist = this.checkBillOfReturnMoney(isSettleCenterCollect, recBill, billType, billId, entryId))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u786e\u8ba4\u9000\u6b3e\u5931\u8d25\uff0c\u5173\u8054\u652f\u4ed8\u5355\u636e\u4e0d\u6ee1\u8db3\u786e\u8ba4\u9000\u6b3e\u6761\u4ef6\uff0c\u5177\u4f53\u786e\u8ba4\u9000\u6b3e\u6761\u4ef6\u8bf7\u67e5\u9605\u91d1\u8776\u4e91\u793e\u533a\u64cd\u4f5c\u624b\u518c\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_10", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!CasHelper.isEmpty((Object)(srcBill = CasBotpHelper.getSrcBillByDestBill((Long)rebillId, (String)"cas_recbill", (String)"cas_paybill")))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u9000\u6b3e\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_11", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (isSettle) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u7ed3\u7b97\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u9000\u6b3e\uff0c\u8bf7\u5148\u624b\u5de5\u53d6\u6d88\u7ed3\u7b97\u3002", (String)"ReceivingRefundAndReturnMoneyContainIfmBackValidator_12", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkBillOfRefund(boolean isSettleCenterCollect, DynamicObject recBill, String billType, Long billId, Long entryId) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(10);
        if (isSettleCenterCollect && "ifm_refund_back".equals(this.getOperateKey())) {
            lstFilters.add(new QFilter("id", "=", (Object)billId));
            lstFilters.add(new QFilter("agentpayeraccount.id", "=", (Object)recBill.getLong("accountbank.id")));
            return QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])RefundHelper.buildIfmQFilter((DynamicObject)recBill, lstFilters).toArray(new QFilter[0]));
        }
        if ("refund_back".equals(this.getOperateKey())) {
            if ("cas_paybill".equals(billType)) {
                DynamicObjectCollection paybills = null;
                if (StringUtils.isNotEmpty((CharSequence)recBill.getString("refundbatchseqid"))) {
                    lstFilters.add(new QFilter("batchseqid", "=", recBill.get("refundbatchseqid")));
                    paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                }
                if (null == paybills || paybills.size() == 0) {
                    lstFilters.add(new QFilter("payeracctbank", "=", (Object)recBill.getLong("accountbank.id")));
                    lstFilters.add(new QFilter("org.id", "=", (Object)recBill.getLong("org.id")));
                    lstFilters.add(new QFilter("actpayamt", ">=", (Object)recBill.getBigDecimal("actrecamt").add(recBill.getBigDecimal("fee"))));
                    lstFilters.add(new QFilter("currency", "=", (Object)recBill.getLong("currency.id")));
                    lstFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
                    lstFilters.add(new QFilter("paymenttype.ispartpayment", "=", recBill.get("receivingtype.ispartreceivable")));
                    paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                }
                if (null != paybills && paybills.size() > 0) {
                    paybills = paybills.stream().filter(s -> billId.equals(s.getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                }
                return null != paybills && paybills.size() > 0;
            }
            if ("cas_agentpaybill".equals(billType)) {
                DynamicObjectCollection agentpaybills = null;
                boolean ispartreceivable = recBill.getBoolean("receivingtype.ispartreceivable");
                if (!ispartreceivable) {
                    if (StringUtils.isNotEmpty((CharSequence)recBill.getString("refundbatchseqid"))) {
                        lstFilters.add(new QFilter("batchseqid", "=", recBill.get("refundbatchseqid")));
                        agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,entry.id", (QFilter[])lstFilters.toArray(new QFilter[0]));
                    }
                    if (null == agentpaybills || agentpaybills.size() == 0) {
                        lstFilters.add(new QFilter("payeracctbank", "=", (Object)recBill.getLong("accountbank.id")));
                        lstFilters.add(new QFilter("org.id", "=", (Object)recBill.getLong("org.id")));
                        lstFilters.add(new QFilter("currency", "=", (Object)recBill.getLong("currency.id")));
                        lstFilters.add(new QFilter("entry.e_issuccess", "=", (Object)"1"));
                        lstFilters.add(new QFilter("entry.e_isrefund", "=", (Object)"0"));
                        agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"id,entry.id,entry.e_encryptamount e_encryptamount", (QFilter[])lstFilters.toArray(new QFilter[0]));
                    }
                    if (null != agentpaybills && agentpaybills.size() > 0) {
                        if ((agentpaybills = agentpaybills.stream().filter(s -> billId.equals(s.getLong("id")) && entryId.equals(s.getLong("entry.id"))).collect(Collectors.toCollection(DynamicObjectCollection::new))).size() > 0) {
                            BigDecimal recAmt = recBill.getBigDecimal("actrecamt");
                            BigDecimal actRecAmtFee = recAmt.add(recBill.getBigDecimal("fee"));
                            BigDecimal agentPayAmt = AgentPayBillHelper.decodeAmount((String)((DynamicObject)agentpaybills.get(0)).getString("e_encryptamount"));
                            return agentPayAmt.compareTo(actRecAmtFee) >= 0;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }
        logger.info("checkBillOfRefund is false");
        return false;
    }

    private boolean checkBillOfReturnMoney(boolean isSettleCenterCollect, DynamicObject recBill, String billType, Long billId, Long entryId) {
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(10);
        if (isSettleCenterCollect && "ifm_returnmoney_back".equals(this.getOperateKey())) {
            lstFilters.add(new QFilter("id", "=", (Object)billId));
            lstFilters.add(new QFilter("payee", "=", recBill.get("payer")));
            return QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])RefundHelper.buildIfmQFilter((DynamicObject)recBill, lstFilters).toArray(new QFilter[0]));
        }
        if ("returnmoney_back".equals(this.getOperateKey())) {
            if ("cas_paybill".equals(billType)) {
                lstFilters.add(new QFilter("id", "=", (Object)billId));
                lstFilters.add(new QFilter("billtype", "not in", Arrays.asList(BillTypeConstants.PAYBILL_SYN, BillTypeConstants.PAYBILL_SPAN)));
                lstFilters.add(new QFilter("currency", "=", (Object)recBill.getLong("currency.id")));
                lstFilters.add(new QFilter("org.id", "=", (Object)recBill.getLong("org.id")));
                lstFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
                lstFilters.add(new QFilter("actpayamt", ">=", (Object)recBill.getBigDecimal("actrecamt").add(recBill.getBigDecimal("fee"))));
                lstFilters.add(new QFilter("paymenttype.ispartpayment", "=", recBill.get("receivingtype.ispartreceivable")));
                DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,actpayamt", (QFilter[])lstFilters.toArray(new QFilter[0]));
                if (null != paybills && paybills.size() > 0) {
                    this.getOption().setVariableValue("actpayamt", ((DynamicObject)paybills.get(0)).get("actpayamt").toString());
                    return true;
                }
                return false;
            }
            if ("cas_agentpaybill".equals(billType)) {
                DynamicObjectCollection agentpaybills = null;
                boolean ispartreceivable = recBill.getBoolean("receivingtype.ispartreceivable");
                if (!ispartreceivable) {
                    lstFilters.add(new QFilter("entry.id", "=", (Object)entryId));
                    String agentpaybillSelectProperties = "id,billno,payeracctbank,payamount,currency,isencryption,entry.id,entry.payeename,entry.e_encryptamount,entry.payeeacctbank,entry.e_remark,sourcebilltype,description,entry.e_issuccess,entry.e_isrefund,fee";
                    lstFilters.add(new QFilter("currency", "=", (Object)recBill.getLong("currency.id")));
                    lstFilters.add(new QFilter("org.id", "=", (Object)recBill.getLong("org.id")));
                    lstFilters.add(new QFilter("entry.e_issuccess", "=", (Object)"1"));
                    lstFilters.add(new QFilter("entry.e_isrefund", "=", (Object)"0"));
                    agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)"entry.id,entry.e_encryptamount e_encryptamount", (QFilter[])lstFilters.toArray(new QFilter[0]));
                    if (null != agentpaybills && agentpaybills.size() > 0) {
                        BigDecimal recAmt = recBill.getBigDecimal("actrecamt");
                        BigDecimal actRecAmtFee = recAmt.add(recBill.getBigDecimal("fee"));
                        BigDecimal agentPayAmt = AgentPayBillHelper.decodeAmount((String)((DynamicObject)agentpaybills.get(0)).getString("e_encryptamount"));
                        this.getOption().setVariableValue("actpayamt", agentPayAmt.toString());
                        return agentPayAmt.compareTo(actRecAmtFee) >= 0;
                    }
                    return false;
                }
            }
        }
        logger.info("checkBillOfReturnMoney is false");
        return false;
    }
}

