/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.recinit;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.InitCashHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecInitSaveValidator
extends AbstractValidator {
    public void validate() {
        Set orgIdList = Arrays.stream(this.dataEntities).filter(c -> c.getDataEntity().getDynamicObject("org") != null).map(c -> c.getDataEntity().getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(orgIdList)) {
            return;
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject casRecInit;
            DynamicObject existRecInit;
            DynamicObject recInit = dataEntity.getDataEntity();
            DynamicObject org = recInit.getDynamicObject("org");
            DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
            DynamicObject currentPeriod = orgInit.getDynamicObject("currentperiod");
            Long recInitId = recInit.getLong("id");
            if (recInitId != null && (existRecInit = InitCashHelper.getRecInit((Long)recInitId, (Long)org.getLong("id"), (long)currentPeriod.getLong("id"))) != null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u5df2\u5b58\u5728%2$s\u671f\u95f4\u7684\u5bf9\u8d26\u521d\u59cb\u5316\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RecInitEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), CasHelper.getLocalValue((DynamicObject)org, (String)"name"), CasHelper.getLocalValue((DynamicObject)currentPeriod, (String)"name")));
            }
            boolean isfinishinit = recInit.getBoolean("isfinishinit");
            Long id = recInit.getLong("id");
            if (id != null && EmptyUtil.isNoEmpty((DynamicObject)(casRecInit = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})))) {
                isfinishinit = casRecInit.getBoolean("isfinishinit");
            }
            if (isfinishinit) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u5bf9\u8d26\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"RecInitSaveValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (orgInit == null || currentPeriod == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u51fa\u7eb3\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"RecInitSaveValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            DynamicObject recInitPeriod = recInit.getDynamicObject("initperiod");
            if (currentPeriod == null || currentPeriod.getPkValue().equals(recInitPeriod.getPkValue())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u5df2\u53d8\u5316\uff0c\u8bf7\u786e\u8ba4\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u95f4\u662f\u5426\u6b63\u786e\u3002", (String)"RecInitSaveValidator_2", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }
}

