/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.smartmatch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.enums.ResultSaveAutoMatchStatus;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class ConfirmMatchValidator
extends AbstractValidator {
    public void validate() {
        if (this.getOption().containsVariable("selectedRowsData")) {
            String selectedRowsDatas = this.getOption().getVariableValue("selectedRowsData");
            String[] selectedPkDatas = selectedRowsDatas.split(",");
            if (CasHelper.isEmpty((Object)selectedRowsDatas) || selectedPkDatas.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c\u3002", (String)"ConfirmMatchValidator_01", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_autocalresult");
            List selectedPkDatasNew = Arrays.stream(selectedPkDatas).map(o -> Long.valueOf(o)).collect(Collectors.toList());
            DynamicObject[] objs = BusinessDataServiceHelper.load((Object[])selectedPkDatasNew.toArray(), (DynamicObjectType)mainEntityType);
            HashMap<String, String> matchMap = new HashMap<String, String>(objs.length);
            HashSet<String> repDetailBillNo = new HashSet<String>(16);
            ArrayList<Long> detailBillIdList = new ArrayList<Long>(objs.length);
            HashMap<Long, Boolean> matchHeadEntry = new HashMap<Long, Boolean>(16);
            for (DynamicObject obj : objs) {
                DynamicObjectCollection entryColl = obj.getDynamicObjectCollection("entryentity");
                DynamicObject record = entryColl.stream().filter(item -> "0".equals(item.get("record"))).findFirst().get();
                List billList = entryColl.stream().filter(item -> !item.get("record").equals("0")).collect(Collectors.toList());
                String detailBillNo = record.getString("num");
                Long detailBillId = record.getLong("billid");
                detailBillIdList.add(detailBillId);
                if (matchMap.containsKey(detailBillNo)) {
                    repDetailBillNo.add(detailBillNo);
                }
                if (ResultSaveAutoMatchStatus.AlMATCH.getValue().equals(obj.get("matchstatus"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5339\u914d\u7684\u8bb0\u5f55\u5df2\u5305\u542b\u5728\u6240\u9009\u8bb0\u5f55\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmMatchValidator_02", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                DynamicObject bizRecord = entryColl.stream().filter(item -> !"0".equals(item.get("record"))).findFirst().get();
                String bizBillDesc = bizRecord.getString("record");
                matchMap.put(detailBillNo, bizBillDesc);
                BigDecimal detailAmt = entryColl.stream().filter(item -> "0".equals(item.get("record"))).map(v -> EmptyUtil.isEmpty((BigDecimal)v.getBigDecimal("payamount")) ? v.getBigDecimal("amount") : v.getBigDecimal("payamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal billAmt = BigDecimal.ZERO;
                for (DynamicObject b : billList) {
                    long billId = b.getLong("billid");
                    long billEntryid = b.getLong("billentryid");
                    billAmt = billAmt.add(EmptyUtil.isEmpty((BigDecimal)b.getBigDecimal("payamount")) ? b.getBigDecimal("amount") : b.getBigDecimal("payamount"));
                    if (!matchHeadEntry.containsKey(billId)) {
                        if (b.get("billentryid") != null) {
                            matchHeadEntry.put(billId, true);
                            continue;
                        }
                        matchHeadEntry.put(billId, false);
                        continue;
                    }
                    if ((!((Boolean)matchHeadEntry.get(billId)).booleanValue() || billEntryid != 0L) && (((Boolean)matchHeadEntry.get(billId)).booleanValue() || billEntryid == 0L)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5339\u914d\u7684\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u4e0d\u80fd\u540c\u65f6\u5339\u914d\u5206\u5f55\u548c\u5355\u636e\u5934\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmMatchValidator_04", (String)"fi-cas-opplugin", (Object[])new Object[0]), b.getString("num")));
                }
                if (detailAmt.compareTo(billAmt) == 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e2d\uff0c\u4ea4\u6613\u660e\u7ec6\u548c\u4e1a\u52a1\u5355\u636e\u7684\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmMatchValidator_06", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (repDetailBillNo.size() > 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u4e2d\u5305\u542b%1$s\u6761\u4ea4\u6613\u660e\u7ec6\u8bb0\u5f55\uff08\u4ea4\u6613\u660e\u7ec6\u5355\u636e\u7f16\u53f7\uff1a%2$s\uff09\u5339\u914d\u4e86\u591a\u4e2a\u4e0d\u540c\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmMatchValidator_03", (String)"fi-cas-opplugin", (Object[])new Object[0]), repDetailBillNo.size(), String.join((CharSequence)",", repDetailBillNo)));
            }
            DynamicObject[] detailArr = BusinessDataServiceHelper.load((Object[])detailBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bei_transdetail_cas"));
            List smartMatchList = Arrays.stream(detailArr).filter(item -> item.getBoolean("smartmatch")).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(smartMatchList)) {
                List billNoList = smartMatchList.stream().map(item -> item.getString("billno")).collect(Collectors.toList());
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6(\u4ea4\u6613\u660e\u7ec6\u5355\u636e\u7f16\u53f7\uff1a%s)\u5df2\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmMatchValidator_05", (String)"fi-cas-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", billNoList)));
            }
        }
    }
}

