/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator.transferapply;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class TransferApplyOrgFinishinitValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(TransferApplyOrgFinishinitValidator.class);

    public void validate() {
        logger.info("TransferApplyOrgFinishinitValidator validate start");
        HashSet<Long> orgIdList = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entry = info.getDynamicObjectCollection("cas_transferapply_entry");
            if (entry == null || entry.size() <= 0) continue;
            for (DynamicObject row : entry) {
                if (row.getDynamicObject("e_payorg") == null) continue;
                orgIdList.add(row.getDynamicObject("e_payorg").getLong("id"));
            }
        }
        if (EmptyUtil.isEmpty(orgIdList)) {
            return;
        }
        Map orgInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(orgIdList);
        block2: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObjectCollection entry = info.getDynamicObjectCollection("cas_transferapply_entry");
            if (entry == null || entry.size() <= 0) continue;
            for (DynamicObject row : entry) {
                DynamicObject org = row.getDynamicObject("e_payorg");
                DynamicObject orgInit = (DynamicObject)orgInitMap.get(org.getString("id"));
                if (org == null || SystemStatusCtrolHelper.isInitEnable((DynamicObject)orgInit)) continue;
                this.addErrorMessage(dataEntity, SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                continue block2;
            }
        }
        logger.info("TransferApplyOrgFinishinitValidator validate end");
    }
}

