/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.print;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.print.core.data.DataRowSet;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.report.capitalreport.print.ICapitalDataPrint;
import kd.fi.cas.report.capitalreport.report.CapitalDataSum;

public class CapitalDataSumPrint
extends CapitalDataSum
implements ICapitalDataPrint {
    private static final List<String> MONTH_AMT_FIELDS = Arrays.asList("monthstart", "debitamount", "creditamount", "monthbalance");
    private static final List<String> MONTH_AMT_FIELDS_CALC = Arrays.asList("monthstartcalc", "debitamountcalc", "creditamountcalc", "monthbalancecalc");
    private static final List<String> DAY_AMT_FIELDS = Arrays.asList("daystart", "daydebitamount", "daycreditamount", "daybalance");
    private static final List<String> DAY_AMT_FIELDS_CALC = Arrays.asList("daystartcalc", "daydebitamountcalc", "daycreditamountcalc", "daybalancecalc");

    @Override
    public List<DataRowSet> queryRowSet(ReportQueryParam arg0, Object arg1, boolean showCalc) {
        return this.convert2DataRowSet(arg0, super.query(arg0, arg1, false), showCalc);
    }

    private List<DataRowSet> convert2DataRowSet(ReportQueryParam arg0, DataSet ds, boolean showCalc) {
        List<String> needFields = null;
        FilterInfo filterInfo = arg0.getFilter();
        log.info("{}CapitalDataSumPrint_convert2DataRowSet_begin.", (Object)"CapitalReportData:");
        int timeType = filterInfo.getInt("timetype");
        needFields = TimeTypeEnum.BYPERIOD.getValue() == timeType ? this.getNeedFields(showCalc, MONTH_AMT_FIELDS, MONTH_AMT_FIELDS_CALC) : this.getNeedFields(showCalc, DAY_AMT_FIELDS, DAY_AMT_FIELDS_CALC);
        List<DataRowSet> returns = this.getDataRowSet(arg0, this.addDateField(filterInfo, ds), needFields, showCalc);
        this.closeDS(ds);
        log.info("{}CapitalDataSumPrint_convert2DataRowSet_end.", (Object)"CapitalReportData:");
        return returns;
    }

    private DataSet addDateField(FilterInfo filters, DataSet ds) {
        Date datefrom = filters.getDate("datefrom");
        Date dateto = filters.getDate("dateto");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
        String periodName = String.format("'%s-%s'", sdf.format(datefrom), sdf.format(dateto));
        ds = ds.addField(periodName, "periodName2");
        return ds;
    }
}

