/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.print;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ObjectField;
import kd.bos.print.core.data.field.TextField;
import kd.fi.cas.enums.CategoryEnum;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.util.EmptyUtil;

public interface ICapitalDataPrint {
    public static final Log loger = LogFactory.getLog(ICapitalDataPrint.class);
    public static final String LOGINFO = "CapitalReportData:";

    public List<DataRowSet> queryRowSet(ReportQueryParam var1, Object var2, boolean var3);

    default public List<DataRowSet> getDataRowSet(ReportQueryParam arg0, DataSet ds, List<String> amtFields, boolean showCalc) {
        ArrayList<DataRowSet> returns = new ArrayList<DataRowSet>(16);
        loger.info("{}ICapitalDataPrint_ICapitalDataPrint_begin.", (Object)LOGINFO);
        while (ds.hasNext()) {
            Row row = ds.next();
            DataRowSet capitalsumbody = new DataRowSet();
            FilterInfo filterInfo = arg0.getFilter();
            int timeType = filterInfo.getInt("timetype");
            if (TimeTypeEnum.BYPERIOD.getValue() == timeType) {
                capitalsumbody.put("period", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("periodname"))));
            }
            if (TimeTypeEnum.BYDATE.getValue() == timeType) {
                capitalsumbody.put("period", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("periodname2"))));
            }
            capitalsumbody.put("org", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("orgname"))));
            capitalsumbody.put("fundtype", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("capitaltype"))));
            capitalsumbody.put("account", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("acctname"))));
            capitalsumbody.put("currencyname", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("currencyname"))));
            int category = filterInfo.getInt("category");
            if (CategoryEnum.CASH.getValue().compareTo(category) != 0) {
                capitalsumbody.put("acctpurpose", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("acctpurpose"))));
                capitalsumbody.put("bank", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("finorginfo"))));
                capitalsumbody.put("rptbanktype", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("rptbanktype"))));
            }
            capitalsumbody.put("bankno", (Field)new TextField(ICapitalDataPrint.dealNull(row.getString("accountnumber"))));
            String sign = row.getString("sign") == null ? "" : row.getString("sign");
            capitalsumbody.put("startcurr", (Field)new ObjectField((Object)(sign + (row.getBigDecimal(amtFields.get(0)) == null ? "0" : row.getBigDecimal(amtFields.get(0))))));
            capitalsumbody.put("reccurr", (Field)new ObjectField((Object)(sign + (row.getBigDecimal(amtFields.get(1)) == null ? "0" : row.getBigDecimal(amtFields.get(1))))));
            capitalsumbody.put("paycurr", (Field)new ObjectField((Object)(sign + (row.getBigDecimal(amtFields.get(2)) == null ? "0" : row.getBigDecimal(amtFields.get(2))))));
            capitalsumbody.put("endcurr", (Field)new ObjectField((Object)(sign + (row.getBigDecimal(amtFields.get(3)) == null ? "0" : row.getBigDecimal(amtFields.get(3))))));
            if (showCalc) {
                String rptsign = row.getString("frptsign") == null ? "" : row.getString("frptsign");
                capitalsumbody.put("startbdcurr", (Field)new ObjectField((Object)(rptsign + (row.getBigDecimal(amtFields.get(4)) == null ? "0" : row.getBigDecimal(amtFields.get(4))))));
                capitalsumbody.put("recbdcurr", (Field)new ObjectField((Object)(rptsign + (row.getBigDecimal(amtFields.get(5)) == null ? "0" : row.getBigDecimal(amtFields.get(5))))));
                capitalsumbody.put("paybdcurr", (Field)new ObjectField((Object)(rptsign + (row.getBigDecimal(amtFields.get(6)) == null ? "0" : row.getBigDecimal(amtFields.get(6))))));
                capitalsumbody.put("endbdcurr", (Field)new ObjectField((Object)(rptsign + (row.getBigDecimal(amtFields.get(7)) == null ? "0" : row.getBigDecimal(amtFields.get(7))))));
            }
            returns.add(capitalsumbody);
        }
        if (EmptyUtil.isNoEmpty((Object)ds)) {
            ds.close();
        }
        loger.info("{}ICapitalDataPrint_ICapitalDataPrint_end.", (Object)LOGINFO);
        return returns;
    }

    public static String dealNull(String obj) {
        if (obj == null) {
            return "";
        }
        return obj;
    }

    default public List<String> getNeedFields(boolean showCalc, List<String> fields, List<String> fields_calc) {
        ArrayList<String> returns = new ArrayList<String>(fields);
        if (showCalc) {
            returns.addAll(fields_calc);
            return returns;
        }
        return returns;
    }
}

