/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.report;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.business.balancemodel.service.report.DealDsUtil;
import kd.fi.cas.business.balancemodel.service.report.ExchangeRateService;
import kd.fi.cas.business.balancemodel.service.report.ReportBalanceService;
import kd.fi.cas.enums.CategoryEnum;
import kd.fi.cas.report.CapitalSumListDataRpt;
import kd.fi.cas.report.CapitalSumParam;
import kd.fi.cas.report.capitalreport.enums.QueryTypeEnum;
import kd.fi.cas.report.capitalreport.service.TotalRowService;

public abstract class CapitalDataAbstract {
    private static final Set<String> acctStatus = Sets.newHashSet((Object[])new String[]{"normal", "freeze", "closing"});
    private static final Long nullId = -111111L;
    protected CapitalSumParam params;
    protected static final int iniSize = 16;
    protected static final String REPORTTYPE = "reporttype";
    protected static final String LOGTIP = "CapitalReportData:";
    protected static final Log log = LogFactory.getLog(CapitalDataAbstract.class);
    protected String unit = "";

    protected DataSet query(ReportQueryParam arg0, Object arg1, boolean isQing) {
        DataSet ds = null;
        log.info("{}CapitalDataAbstract_query_begin.", (Object)LOGTIP);
        try {
            this.params = this.getCapitalSumParam(arg0);
            this.unit = this.getUnit(this.params);
            ds = this.getQueryData(this.params);
            ds = this.dealDataSet(this.params, ds, isQing);
            log.info("{}CapitalDataAbstract_query_end.", (Object)LOGTIP);
        }
        catch (KDBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error("{}query_error:{}", (Object)LOGTIP, (Object)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u6c47\u603b\u8868\u67e5\u8be2\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[traceId:%1$s]", (String)"CapitalDataAbstract_1", (String)"fi-cas-report", (Object[])new Object[0]), RequestContext.get().getTraceId()));
        }
        return ds;
    }

    protected CapitalSumParam getCapitalSumParam(ReportQueryParam arg0) {
        return null;
    }

    private DataSet getQueryData(CapitalSumParam param) throws Exception {
        Set<Long> cashAcctScope = this.getCashAcctScope(param);
        Set<Long> bankAcctScope = this.getBankAcctScope(param);
        DataSet ds = this.getReportData(param, cashAcctScope, bankAcctScope);
        return ds;
    }

    private DataSet dealDataSet(CapitalSumParam param, DataSet ds, boolean isQing) {
        log.info("{}dealDataSet.", (Object)LOGTIP);
        ds = this.dealTotal(param, this.dealAmtDecimal(param, this.dealExchangeRate(param, ds, isQing)));
        Long rptCurrencyId = param.getCalcCurrency().getLong("id");
        String rptSign = param.getCalcCurrency().getString("sign");
        ds = ds.addField("'" + rptSign + "'", "frptsign").addField(rptCurrencyId + "", "frptcurrency1");
        return ds;
    }

    private int getRptCurrencyDecimal(Long id) {
        log.info("{}getRptCurrencyDecimal:{}", (Object)LOGTIP, (Object)id);
        DynamicObject cnyDynamicObj = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (cnyDynamicObj != null) {
            return cnyDynamicObj.getInt("amtprecision");
        }
        return 10;
    }

    private DataSet dealExchangeRate(CapitalSumParam param, DataSet ds, boolean isQing) {
        log.info("{}dealExchangeRate.", (Object)LOGTIP);
        Long rptCurrencyId = param.getCalcCurrency().getLong("id");
        Long exchangeRateTableId = param.getExrateTable() == null ? null : Long.valueOf(param.getExrateTable().getLong("id"));
        Date conversionDate = param.getExchangedate();
        int rptCurryDecimal = this.getRptCurrencyDecimal(rptCurrencyId);
        String[] fields = new String[]{"fexchgRate", rptCurryDecimal + " as frptamtdecimal", rptCurrencyId + " as frptcurrency"};
        DataSet rateDs = new ExchangeRateService().getExchgRateDs(ds, rptCurrencyId, exchangeRateTableId, conversionDate, isQing);
        log.info("{}dealExchangeRate_getLeftJoinDs.", (Object)LOGTIP);
        ds = DealDsUtil.getLeftJoinDs((DataSet)ds, (DataSet)rateDs, (String)"fcurrencyid", (String)"fcurrencyid", (String[])fields);
        this.closeDS(rateDs);
        return ds;
    }

    private DataSet dealAmtDecimal(CapitalSumParam param, DataSet ds) {
        log.info("{}dealAmtDecimal.", (Object)LOGTIP);
        String cashType = ResManager.loadKDString((String)"'\u73b0\u91d1'", (String)"CapitalDataAbstract_2", (String)"fi-cas-report", (Object[])new Object[0]);
        String bankType = ResManager.loadKDString((String)"'\u94f6\u884c\u5b58\u6b3e'", (String)"CapitalDataAbstract_3", (String)"fi-cas-report", (Object[])new Object[0]);
        ds = ds.select(new String[]{"forgid", "facctid", "fcurrencyid", "fperiod", "fperiodname", "sumlevel", "fcurrencyname", "forgname", "frptcurrency", "frptamtdecimal", "fexchgRate", "fsign", "famtdecimal", String.format("case when ftype = '1' then %1$s else %2$s end as ftype", cashType, bankType), "case when facctname = null then '' else facctname end as facctname", "case when facctshortname = null then '' else facctshortname end as facctshortname", "case when facctnumber = null then '' else facctnumber end as facctnumber", "case when facctpurpose = null then '' else facctpurpose end as facctpurpose", "case when facctstyle = null then '' else facctstyle end as facctstyle", "case when faccttype = null then '' else faccttype end as faccttype", "case when fbankname = null then '' else fbankname end as fbankname", "case when frptbanktype = null then '' else frptbanktype end as frptbanktype", "case when fbalance = null then 0 else fbalance end as fbalance", "case when fbalance = null then 0 else fbalance * fexchgRate end as fbalancerpt", "case when fdebitamount = null then 0 else fdebitamount end as fdebitamount", "case when fdebitamount = null then 0 else fdebitamount * fexchgRate end as fdebitamountrpt", "case when fcreditamount = null then 0 else fcreditamount end as fcreditamount", "case when fcreditamount = null then 0 else fcreditamount * fexchgRate end as fcreditamountrpt", "case when fyearbalance = null then 0 else fyearbalance end as fyearbalance", "case when fyearbalance = null then 0 else fyearbalance * fexchgRate end as fyearbalancerpt", "case when fyeardebitamount = null then 0 else fyeardebitamount end as fyeardebitamount", "case when fyeardebitamount = null then 0 else fyeardebitamount * fexchgRate end as fyeardebitamountrpt", "case when fyearcreditamount = null then 0 else fyearcreditamount end as fyearcreditamount", "case when fyearcreditamount = null then 0 else fyearcreditamount * fexchgRate end as fyearcreditamountrpt"});
        return ds;
    }

    private DataSet dealTotal(CapitalSumParam param, DataSet ds) {
        List<String> groupFields_sum = this.getGroupFields(param);
        if (groupFields_sum == null || groupFields_sum.size() == 0) {
            return ds;
        }
        List<String> sumFields = Arrays.asList("fbalancerpt", "fdebitamountrpt", "fcreditamountrpt", "fyearbalancerpt", "fyeardebitamountrpt", "fyearcreditamountrpt", "frptamtdecimal", "famtdecimal");
        log.info("{}dealTotal.", (Object)LOGTIP);
        return new TotalRowService().addTotalRowAndSort(groupFields_sum, sumFields, ds, "sumlevel", param.getShowsubtotal());
    }

    protected List<String> getGroupFields(CapitalSumParam param) {
        return null;
    }

    private DataSet getReportData(CapitalSumParam param, Set<Long> cashAcctScope, Set<Long> bankAcctScope) throws Exception {
        return ReportBalanceService.getInstance().getBalances(param.getDatasource(), param.getCategory(), param.getTimeType(), BalanceQueryType.BEGINDATE_ENDOCCUR.getValue(), param.getDateFrom(), param.getDateTo(), Long.valueOf(param.getPeriodFrom() == null ? 0L : param.getPeriodFrom().getLong("id")), Long.valueOf(param.getPeriodTo() == null ? 0L : param.getPeriodTo().getLong("id")), cashAcctScope, bankAcctScope, this.filterSet(param.getCurrencys()), this.filterSet(param.getOrgs()));
    }

    private Set<Long> getCashAcctScope(CapitalSumParam param) {
        log.info("{}getCashAcctScope_begin.", (Object)LOGTIP);
        HashSet<Long> returns = new HashSet<Long>(16);
        if (CategoryEnum.BANK.getValue().intValue() == param.getCategory()) {
            returns.add(nullId);
            return returns;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        this.addFilter(param.getOrgs(), filters, QueryTypeEnum.COMPANY.getValue().equals(param.getQueryOrgType()) ? "openorg.id" : "org.id");
        this.addFilter(param.getAccountcashs(), filters, "id");
        this.addFilter(param.getCurrencys(), filters, "currency.fbasedataid");
        QFilter acctStatusFilter = this.getCashAcctStatusFilter(param);
        if (acctStatusFilter != null) {
            filters.add(acctStatusFilter);
        }
        log.info("{}getCashAcctScope:form:{};filter:{}", new Object[]{LOGTIP, "cas_accountcash", ((Object)filters).toString()});
        DynamicObjectCollection cashAccs = QueryServiceHelper.query((String)"cas_accountcash", (String)"id,openorg,currency", (QFilter[])filters.toArray(new QFilter[0]));
        cashAccs.forEach(e -> returns.add(e.getLong("id")));
        returns.add(nullId);
        return returns;
    }

    private Set<Long> getBankAcctScope(CapitalSumParam param) {
        log.info("{}getBankAcctScope.", (Object)LOGTIP);
        HashSet<Long> returns = new HashSet<Long>(16);
        if (CategoryEnum.CASH.getValue().intValue() == param.getCategory()) {
            returns.add(nullId);
            return returns;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        if (QueryTypeEnum.ORG.getValue().equals(param.getQueryOrgType())) {
            filters = CapitalSumListDataRpt.qFilterAccs(param, null);
        } else {
            filters.add(new QFilter("openorg.id", "in", this.filterSet(param.getOrgs())));
            this.addFilter(param.getBankaccounts(), filters, "id");
        }
        this.addFilter(param.getCurrencys(), filters, "currency.fbasedataid");
        this.addFilter(param.getBank(), filters, "bank.id");
        this.addFilter(param.getBanktypes(), filters, "bank.bank_cate.id");
        this.addFilter(param.getAccountProperty(), filters, "acctproperty.id");
        QFilter acctStatusFilter = this.getAcctStatusFilter(param);
        if (acctStatusFilter != null) {
            filters.add(acctStatusFilter);
        }
        log.info("{}getBankAcctScope:form:{};{}", new Object[]{LOGTIP, "bd_accountbanks", ((Object)filters).toString()});
        DynamicObjectCollection bankAccs = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,number,company,acctstatus,currency", (QFilter[])filters.toArray(new QFilter[0]));
        bankAccs.forEach(e -> returns.add(e.getLong("id")));
        returns.add(nullId);
        return returns;
    }

    private QFilter getAcctStatusFilter(CapitalSumParam param) {
        if (!param.getShowCloseAcct().booleanValue()) {
            return new QFilter("acctstatus", "in", acctStatus);
        }
        return null;
    }

    private QFilter getCashAcctStatusFilter(CapitalSumParam param) {
        if (!param.getShowCloseAcct().booleanValue()) {
            return new QFilter("closestatus", "=", (Object)false);
        }
        return null;
    }

    private void addFilter(DynamicObjectCollection cols, List<QFilter> filters, String filterField) {
        Set<Long> ids = this.filterSet(cols);
        if (ids != null && ids.size() > 0) {
            filters.add(new QFilter(filterField, "in", ids));
        }
    }

    private Set<Long> filterSet(DynamicObjectCollection cols) {
        if (cols != null) {
            return cols.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    protected void closeDS(DataSet ds) {
        if (ds != null) {
            ds.close();
        }
    }

    public String getUnit(CapitalSumParam param) {
        switch (param.getStatisticUnit()) {
            case "Billion": 
            case "100000000": {
                return "/100000000";
            }
            case "Million": 
            case "1000000": {
                return "/1000000";
            }
            case "TenThousand": 
            case "10000": {
                return "/10000";
            }
            case "Thousand": 
            case "1000": {
                return "/1000";
            }
            case "Original": 
            case "1": {
                return "/1";
            }
        }
        return "/1";
    }
}

