/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.report;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.report.CapitalSumParam;
import kd.fi.cas.report.capitalreport.enums.QueryTypeEnum;
import kd.fi.cas.report.capitalreport.report.CapitalDataAbstract;
import kd.fi.cas.util.EmptyUtil;

public class CapitalDataDay
extends CapitalDataAbstract {
    @Override
    public DataSet query(ReportQueryParam arg0, Object arg1, boolean isQing) {
        arg0.getFilter().addFilterItem("reporttype", (Object)"1");
        DataSet ds = super.query(arg0, arg1, false);
        log.info("{}CapitalDataDay_query.", (Object)"CapitalReportData:");
        ds = ds.updateField("famtdecimal", "CAST(famtdecimal AS Integer)").updateField("frptamtdecimal", "CAST(frptamtdecimal AS Integer)");
        ds = ds.select(new String[]{"ftype as capitaltype", "forgname orgname", "frptcurrency1 as currencyfield", "fcurrencyid as currencyfield1", "fsign as sign", "frptsign", "forgname as openorgfield", "forgname as company", "frptbanktype as rptbanktype", "ftype as capital_type", "facctshortname as account", "facctname as acctname", "facctpurpose as acctpurpose", "facctstyle as acctstyle", "faccttype as accttype", "facctnumber as accountnumber", "fcurrencyid as currencyid", "fcurrencyname as currencyname", "fbankname as finorginfo", "sumlevel", "round(fbalance" + this.unit + ",famtdecimal) as yest_original", "round(fbalancerpt" + this.unit + ",frptamtdecimal) as yest_report", "round(fdebitamount" + this.unit + ",famtdecimal) as income_original", "round(fdebitamountrpt" + this.unit + ",frptamtdecimal) as income_report", "round(fcreditamount" + this.unit + ",famtdecimal) as expend_original", "round(fcreditamountrpt" + this.unit + ",frptamtdecimal) as expend_report", "round((fbalance + fdebitamount - fcreditamount)" + this.unit + ",famtdecimal) as balan_original", "round((fbalancerpt + fdebitamountrpt - fcreditamountrpt)" + this.unit + ",frptamtdecimal) as balan_report"});
        ds = ds.updateField("yest_original", "case when sumlevel = 0 then yest_original else null end").updateField("income_original", "case when sumlevel = 0 then income_original else null end").updateField("expend_original", "case when sumlevel = 0 then expend_original else null end").updateField("balan_original", "case when sumlevel = 0 then balan_original else null end");
        return ds;
    }

    @Override
    protected List<String> getGroupFields(CapitalSumParam param) {
        switch (param.getSelDimension()) {
            case 1: {
                return Arrays.asList("forgname", "ftype", "facctpurpose");
            }
            case 2: {
                return Arrays.asList("forgname", "frptbanktype");
            }
        }
        return Arrays.asList("forgname", "ftype", "facctpurpose");
    }

    private DynamicObjectCollection getDyobj(FilterInfo filterInfo, String field) {
        Object fieldValue = filterInfo.getValue(field);
        if (fieldValue instanceof DynamicObjectCollection) {
            return filterInfo.getDynamicObjectCollection(field);
        }
        List orgIds = (List)filterInfo.getValue(field);
        return this.queryDyCols("bos_org", orgIds);
    }

    @Override
    protected CapitalSumParam getCapitalSumParam(ReportQueryParam arg0) {
        FilterInfo filterInfo = arg0.getFilter();
        CapitalSumParam param = new CapitalSumParam();
        String queryOrtType = filterInfo.getString("queryorgtype");
        log.info("{}CapitalDataDay.getQueryOrgType:{}.", (Object)"CapitalReportData:", (Object)(queryOrtType == null ? "null" : queryOrtType));
        if (queryOrtType == null) {
            param.setQueryOrgType(QueryTypeEnum.ORG.getValue());
        } else {
            param.setQueryOrgType(queryOrtType);
        }
        DynamicObjectCollection orgs = null;
        if (QueryTypeEnum.ORG.getValue().equals(param.getQueryOrgType())) {
            orgs = this.getDyobj(filterInfo, "filter_company");
            param.setCategory(filterInfo.getInt("category"));
        } else {
            orgs = this.getDyobj(filterInfo, "openorg");
            param.setCategory(2);
        }
        param.setOrgs(orgs);
        param.setAccountcashs(filterInfo.getDynamicObjectCollection("filter_accountcash"));
        param.setBankaccounts(filterInfo.getDynamicObjectCollection("filter_bankaccountnumber"));
        param.setBanks(filterInfo.getDynamicObjectCollection("bank"));
        param.setAccountPropertys(filterInfo.getDynamicObjectCollection("accountproperty"));
        DynamicObjectCollection currencys = filterInfo.getDynamicObjectCollection("orgcurrency");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)currencys)) {
            currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        }
        param.setCurrencys(currencys);
        Date dateFrom = filterInfo.getDate("filter_date");
        param.setDateFrom(dateFrom);
        param.setDateTo(dateFrom);
        param.setTimeType(TimeTypeEnum.BYDATE.getValue());
        param.setSelDimension(filterInfo.getInt("seldimension"));
        param.setStatisticUnit(filterInfo.getString("filter_currencyunit"));
        param.setExrateTable(filterInfo.getDynamicObject("exratetable"));
        param.setCalcCurrency(filterInfo.getDynamicObject("filter_currency"));
        param.setNotShowZero(true);
        param.setShowCloseAcct(filterInfo.getBoolean("isshowclose"));
        log.info("{}getCapitalSumParam:{}.", (Object)"CapitalReportData:", (Object)arg0.getFilter().getString("showsubtotal"));
        param.setShowsubtotal(filterInfo.getBoolean("showsubtotal"));
        param.setDefaulttime(filterInfo.getBoolean("defaulttime"));
        param.setExchangedate(filterInfo.getDate("exchangedate"));
        param.setBanktypes(filterInfo.getDynamicObjectCollection("banktype"));
        param.setDatasource(filterInfo.getInt("datasource"));
        return param;
    }

    private DynamicObjectCollection queryDyCols(String formId, List<Long> pkIds) {
        if (pkIds == null || pkIds.size() == 0) {
            return new DynamicObjectCollection();
        }
        QFilter filter = new QFilter("id", "in", pkIds);
        return QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])filter.toArray());
    }
}

