/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.print;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportView;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.fi.cas.report.capitalreport.print.CapitalDataDayPrint;

public class CapitalDayPrintPluginNew
extends AbstractPrintPlugin {
    private static final String[] CURR_FILED = new String[]{"yest_original", "yest_report", "income_original", "income_report", "expend_original", "expend_report", "balan_original", "balan_report"};
    private static final String SYSTEM_TYPE = "fi-cas-report";
    private static Log log = LogFactory.getLog(CapitalDayPrintPluginNew.class);

    public void loadCustomData(CustomDataLoadEvent evt) {
        log.info("CapitalReportData:CapitalDayPrintPluginNew.loadCustomData_begin.");
        CustomDataSource dataSource = evt.getDataSource();
        String dataSourceName = dataSource.getDsName();
        List dyns = evt.getCustomDataRows();
        ReportView view = (ReportView)SessionManager.getCurrent().getView(dataSource.getPageId());
        ReportQueryParam queryParam = view.getQueryParam();
        int size = queryParam.getFilter().getFilterItems().size();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(size);
        for (FilterItemInfo filterItem : queryParam.getFilter().getFilterItems()) {
            paramMap.put(filterItem.getPropName(), filterItem.getValue());
        }
        log.info("loadCustomData_dataSourceName:capitaldayhead.");
        if ("capitaldayhead".equals(dataSourceName)) {
            DataRowSet capitalsumhead = new DataRowSet();
            StringBuilder period = new StringBuilder();
            period.append(ResManager.loadKDString((String)"\u671f\u95f4\uff1a", (String)"CapitalSumPrintPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            StringBuilder periodName = new StringBuilder();
            Date datefrom = (Date)paramMap.get("filter_date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/M/dd");
            periodName.append(sdf.format(datefrom));
            period.append((CharSequence)periodName);
            capitalsumhead.put("period", (Field)new TextField(period.toString()));
            log.info("loadCustomData_dataSourceName:bdcurrency.");
            StringBuilder bdcurrency = new StringBuilder();
            bdcurrency.append(ResManager.loadKDString((String)"\u62a5\u544a\u5e01\uff1a", (String)"CapitalSumPrintPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            if (Objects.nonNull(paramMap.get("filter_currency"))) {
                bdcurrency.append(((DynamicObject)paramMap.get("filter_currency")).getString("name"));
                capitalsumhead.put("bdcurrency", (Field)new TextField(bdcurrency.toString()));
            }
            log.info("loadCustomData_dataSourceName:Original.");
            StringBuilder currorg = new StringBuilder();
            currorg.append(ResManager.loadKDString((String)"\u7edf\u8ba1\u5355\u4f4d\uff1a", (String)"CapitalSumPrintPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            String statisticunit = paramMap.get("filter_currencyunit").toString();
            if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Original")) {
                statisticunit = ResManager.loadKDString((String)"\u5143", (String)"CapitalSumPrintPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Thousand")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u5143", (String)"CapitalSumPrintPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"TenThousand")) {
                statisticunit = ResManager.loadKDString((String)"\u4e07\u5143", (String)"CapitalSumPrintPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Million")) {
                statisticunit = ResManager.loadKDString((String)"\u767e\u4e07\u5143", (String)"CapitalSumPrintPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)statisticunit, (CharSequence)"Billion")) {
                statisticunit = ResManager.loadKDString((String)"\u5343\u4e07\u5143", (String)"CapitalSumPrintPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            }
            currorg.append(statisticunit);
            log.info("loadCustomData_dataSourceName:currorg.");
            capitalsumhead.put("currorg", (Field)new TextField(currorg.toString()));
            dyns.add(capitalsumhead);
        } else if ("capitaldaybody".equals(dataSourceName)) {
            log.info("loadCustomData_dataSourceName:capitaldaybody.");
            dyns.addAll(new CapitalDataDayPrint().queryRowSet(queryParam, null, true));
            return;
        }
    }
}

