/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.fi.cas.mservice.DisposerActionEnum;
import kd.fi.cas.mservice.IPaymentDisposer;

public class ServiceHandler {
    private static ServiceHandler instance;

    public static ServiceHandler getInstance() {
        if (instance == null) {
            instance = new ServiceHandler();
        }
        return instance;
    }

    public void dispose(DynamicObject payInfo, DisposerActionEnum action) throws KDException {
        IPaymentDisposer disposer = this.getDisposer(payInfo);
        if (disposer != null) {
            disposer.dispose(payInfo, action);
        }
    }

    private IPaymentDisposer getDisposer(DynamicObject payInfo) {
        IPaymentDisposer disposer = null;
        String disposerName = null;
        String sourceBillType = payInfo.getString("sourcebilltype");
        if (sourceBillType.equals("t_er_dailyloanbill")) {
            disposerName = "kd.fi.er.LoanBillDisposer";
        }
        if (disposerName != null) {
            disposer = (IPaymentDisposer)TypesContainer.createInstance((String)disposerName);
        }
        return disposer;
    }
}

