/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mservice.digit.handler.matchorders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.mservice.digit.IDigitEmployeeSkillHandler;
import kd.fi.cas.mservice.digit.handler.matchorders.LastMonthMatchOrdersPayEntryProcessHandler;
import kd.fi.cas.mservice.digit.handler.matchorders.LastMonthMatchOrdersReceiptEntryProcessHandler;
import kd.fi.cas.mservice.digit.handler.matchorders.ThisMonthMatchOrdersPayEntryProcessHandler;
import kd.fi.cas.mservice.digit.handler.matchorders.ThisMonthMatchOrdersReceiptEntryProcessHandler;
import kd.fi.cas.mservice.digit.helper.BankAcctHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccumulateDealMatchOrdersHandler
implements IDigitEmployeeSkillHandler {
    @Override
    public SkillRunResult handler(SkillRunContext skillRunContext) {
        SkillRunResult skillRunResult = new SkillRunResult();
        skillRunResult.setSkillNum(skillRunContext.getSkillNum());
        skillRunResult.setDate(new Date());
        skillRunResult.setStartTime(skillRunContext.getStartTime());
        skillRunResult.setEndTime(skillRunContext.getEndTime());
        Set<Object> virtAcctIds = BankAcctHelper.getVirtAcctIds();
        HashSet<String> receredWays = new HashSet<String>(2);
        receredWays.add("automatch");
        receredWays.add("beipay");
        receredWays.add("rule");
        receredWays.add("claim");
        receredWays.add("hand");
        receredWays.add("handmerge");
        QFilter baseFilter = new QFilter("receredtype", "=", (Object)"3").and(new QFilter("creditamount", "!=", (Object)0)).and(new QFilter("biztime", ">=", (Object)skillRunContext.getStartTime())).and(new QFilter("biztime", "<=", (Object)skillRunContext.getEndTime())).and(new QFilter("accountbank", "not in", virtAcctIds));
        DynamicObject[] interrecs = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id,receredway", (QFilter[])new QFilter[]{baseFilter});
        List interrecsLst = Arrays.stream(interrecs).filter(o -> {
            boolean result = false;
            String receredway = o.getString("receredway");
            if (receredWays.contains(receredway)) {
                result = true;
            } else if (EmptyUtil.isEmpty((String)receredway)) {
                result = true;
            }
            return result;
        }).collect(Collectors.toList());
        int interrecsCount = interrecsLst != null ? interrecsLst.size() : 0;
        QFilter qFilter2 = new QFilter("receredtype", "=", (Object)"3").and(new QFilter("debitamount", "!=", (Object)0)).and(new QFilter("biztime", ">=", (Object)skillRunContext.getStartTime())).and(new QFilter("biztime", "<=", (Object)skillRunContext.getEndTime())).and(new QFilter("accountbank", "not in", virtAcctIds));
        DynamicObject[] intelpays = BusinessDataServiceHelper.load((String)"bei_intelpay", (String)"id,receredway", (QFilter[])new QFilter[]{qFilter2});
        List intelpaysLst = Arrays.stream(intelpays).filter(o -> {
            boolean result = false;
            String receredway = o.getString("receredway");
            if (receredWays.contains(receredway)) {
                result = true;
            } else if (EmptyUtil.isEmpty((String)receredway)) {
                result = true;
            }
            return result;
        }).collect(Collectors.toList());
        int intelpaysCount = intelpaysLst != null ? intelpaysLst.size() : 0;
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(3);
        LastMonthMatchOrdersPayEntryProcessHandler handler1 = new LastMonthMatchOrdersPayEntryProcessHandler();
        data.addAll(handler1.combineData());
        LastMonthMatchOrdersReceiptEntryProcessHandler handler2 = new LastMonthMatchOrdersReceiptEntryProcessHandler();
        data.addAll(handler2.combineData());
        ThisMonthMatchOrdersPayEntryProcessHandler handler3 = new ThisMonthMatchOrdersPayEntryProcessHandler();
        data.addAll(handler3.combineData());
        ThisMonthMatchOrdersReceiptEntryProcessHandler handler4 = new ThisMonthMatchOrdersReceiptEntryProcessHandler();
        data.addAll(handler4.combineData());
        skillRunResult.setData(data);
        skillRunResult.setFailCount(Integer.valueOf(0));
        skillRunResult.setTotalCount(Integer.valueOf(interrecsCount + intelpaysCount));
        return skillRunResult;
    }
}

