/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.mservice.digit.handler.suborders;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.mservice.digit.ICombineDataProcessHandler;
import kd.fi.cas.mservice.digit.helper.BankAcctHelper;

public class LastMonthSubOrdersProcessHandler
implements ICombineDataProcessHandler {
    @Override
    public List<Map<String, String>> combineData() {
        Tuple<Date, Date> lastMonthDateRange = this.getLastMonthDateRange();
        Date startDate = (Date)lastMonthDateRange.item1;
        Date endDate = (Date)lastMonthDateRange.item2;
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>(3);
        Set<Object> virtAcctIds = BankAcctHelper.getVirtAcctIds();
        QFilter baseFilter = new QFilter("receredtype", "=", (Object)"3").and(new QFilter("creditamount", "!=", (Object)0)).and(new QFilter("bizdate", ">=", (Object)startDate)).and(new QFilter("bizdate", "<", (Object)endDate)).and(new QFilter("accountbank", "not in", virtAcctIds));
        HashSet<String> receredWays = new HashSet<String>(4);
        receredWays.add("rule");
        receredWays.add("hand");
        receredWays.add("handmerge");
        receredWays.add("claim");
        QFilter qFilter1 = baseFilter.and(new QFilter("receredway", "in", receredWays).or(new QFilter("receredway", "is null", null)));
        DynamicObject[] interrecs = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id", (QFilter[])new QFilter[]{qFilter1});
        int interrecsCount = interrecs != null ? interrecs.length : 0;
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u6536\u6b3e\u5165\u8d26\u4e2d\u5fc3\u6d41\u6c34\u603b\u6570", (String)"LastMonthReceiptEntryHandler_01", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(interrecsCount), "syskrzzxlszs", true));
        QFilter baseFilter2 = new QFilter("receredtype", "=", (Object)"3").and(new QFilter("creditamount", "!=", (Object)0)).and(new QFilter("bizdate", ">=", (Object)startDate)).and(new QFilter("bizdate", "<", (Object)endDate)).and(new QFilter("accountbank", "not in", virtAcctIds));
        receredWays.clear();
        receredWays.add("rule");
        receredWays.add("claim");
        QFilter qFilter2 = baseFilter2.and(new QFilter("receredway", "in", receredWays));
        DynamicObject[] zninterrecs = BusinessDataServiceHelper.load((String)"bei_intelrec", (String)"id", (QFilter[])new QFilter[]{qFilter2});
        int zninterrecsCount = zninterrecs != null ? zninterrecs.length : 0;
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u5206\u5355\u5165\u8d26\u603b\u6570", (String)"LastMonthReceiptEntryHandler_02", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(zninterrecsCount), "syznfdrzzs", true));
        int percent = (int)Math.ceil((float)zninterrecsCount * 1.0f / (float)interrecsCount * 100.0f);
        data.add(this.buildData(ResManager.loadKDString((String)"\u4e0a\u6708\u667a\u80fd\u5206\u5355\u5165\u8d26\u5360\u6bd4", (String)"LastMonthReceiptEntryHandler_03", (String)"fi-cas-mservice", (Object[])new Object[0]), String.valueOf(percent), "syznfdrzzb", false));
        return data;
    }
}

