/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.writeback;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class DapVoucherWriteBackErUtil {
    private static Log logger = LogFactory.getLog(DapVoucherWriteBackErUtil.class);

    public static void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        Map sourceBillIds = BFTrackerServiceHelper.findSourceBills((String)billEntityNumber, (Long[])billToVch.keySet().toArray(new Long[0]));
        logger.info(String.format("\u67e5\u8be2\u51fa\u7eb3\u5355\u7684\u4e0a\u6e38\u5355. billEntityNumber=%s, billIds=%s, result=%s", billEntityNumber, billToVch.keySet(), sourceBillIds));
        if (sourceBillIds.isEmpty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("operation", operation);
        params.put("billEntityNumber", billEntityNumber);
        params.put("billToVch", billToVch);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"ICasBillDapWriteBackService", (String)"execute", (Object[])new Object[]{params});
    }

    public static Map<Long, String> validate(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        logger.info("DapVoucherWriteBackErUtil.validate... operation value :{}, billEntityNumber:{}, billToVch: {}", (Object)operation.getValue(), billToVch);
        if (VoucherOperation.Delete == operation) {
            DynamicObjectCollection bizBills = QueryServiceHelper.query((String)billEntityNumber, (String)"id,org.id,org.name", (QFilter[])new QFilter[]{new QFilter("id", "in", billToVch.keySet())});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)bizBills)) {
                return null;
            }
            Set voucherIds = billToVch.values().stream().map(Voucher::getId).collect(Collectors.toSet());
            DynamicObjectCollection vchs = QueryServiceHelper.query((String)"gl_voucher", (String)"id,bookeddate,period.name", (QFilter[])new QFilter[]{new QFilter("id", "in", voucherIds)});
            HashMap<Long, String> result = new HashMap<Long, String>(10);
            logger.info("DapVoucherWriteBackErUtil.validate... bizBills.size:{}, vchs.size:{}", (Object)bizBills.size(), (Object)vchs.size());
            Set orgIds = bizBills.stream().map(v -> v.getLong("org.id")).collect(Collectors.toSet());
            Map cashmgtinitMap = BusinessDataServiceHelper.loadFromCache((String)"cas_cashmgtinit", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
            Map<Long, DynamicObject> orgToInitMap = cashmgtinitMap.values().stream().collect(Collectors.toMap(v -> v.getLong("org.id"), o -> o));
            for (DynamicObject bizBill : bizBills) {
                Long org = bizBill.getLong("org.id");
                DynamicObject dynamicObject = orgToInitMap.get(org);
                if (dynamicObject == null) {
                    logger.info("DapVoucherWriteBackErUtil.validate \u67e5\u8be2\u5230\u7684\u51fa\u7eb3\u521d\u59cb\u5316\u6570\u636e\u4e3a\u7a7a\uff0corg:{}", (Object)org);
                    continue;
                }
                DynamicObject currentPeriod = dynamicObject.getDynamicObject("currentperiod");
                if (currentPeriod == null) {
                    logger.info("DapVoucherWriteBackErUtil.validate \u51fa\u7eb3\u521d\u59cb\u5316\u7684\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0corg:{}", (Object)org);
                    continue;
                }
                Date startDate = currentPeriod.getDate("begindate");
                Voucher voucher = billToVch.get(bizBill.getLong("id"));
                DynamicObject vch = vchs.stream().filter(v -> v.getLong("id") == voucher.getId()).findFirst().orElse(null);
                if (null == vch) {
                    logger.info("DapVoucherWriteBackErUtil.validate \u67e5\u8be2\u5230\u7684\u51ed\u8bc1\u6570\u636e\u4e3a\u7a7a\uff0cvoucherid:{}", (Object)voucher.getId());
                    continue;
                }
                Date bookEddate = vch.getDate("bookeddate");
                logger.info("DapVoucherWriteBackErUtil.validate startDate:{}\uff0cbookEddate:{}", (Object)startDate, (Object)bookEddate);
                if (null == startDate || null == bookEddate || bookEddate.compareTo(startDate) >= 0) continue;
                String orgName = bizBill.getString("org.name");
                String periodName = vch.getString("period.name");
                result.put(voucher.getId(), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u51fa\u7eb3\u5e94\u7528%2$s\u5df2\u7ecf\u7ed3\u8d26\uff0c \u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664\u51ed\u8bc1\u3002", (String)"DapVoucherWriteBackErUtil_0", (String)"fi-cas-mservice", (Object[])new Object[0]), orgName, periodName));
            }
            return result;
        }
        return null;
    }
}

