/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.util.EmptyUtil;

public class AccountCashList
extends AbstractListPlugin {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BaseShowParameter baseShowParameter = (BaseShowParameter)e.getParameter();
        Long acctId = (Long)baseShowParameter.getPkId();
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        baseShowParameter.setOpenStyle(style);
        if (acctId == null || baseShowParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
        } else {
            boolean isCanModify = this.isCanModify(acctId);
            if (!isCanModify) {
                baseShowParameter.setStatus(OperationStatus.VIEW);
            } else {
                baseShowParameter.setStatus(OperationStatus.EDIT);
            }
        }
    }

    private boolean isCanModify(Long acctId) {
        DynamicObject acctCash = QueryServiceHelper.queryOne((String)"cas_accountcash", (String)"id, org, closestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)acctId)});
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        boolean isExist = PermissionHelper.checkCurrentUserPermission((String)appId, (long)acctCash.getLong("org"), (String)"cas_accountcash", (String)"4715a0df000000ac");
        return isExist && acctCash.getInt("closestatus") == 0;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("closeacct".equals(afterDoOperationEventArgs.getObjectId()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9500\u6237\u6210\u529f\u3002", (String)"AccountCashList_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else if ("uncloseacct".equals(afterDoOperationEventArgs.getObjectId()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u9500\u6237\u6210\u529f\u3002", (String)"AccountCashList_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if ("closeacct".equals(afterDoOperationEventArgs.getObjectId()) || "uncloseacct".equals(afterDoOperationEventArgs.getObjectId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.setClientQueryFilterParameter(new FilterParameter());
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!commonFilterColumn.getFieldName().equals("openorg.name")) continue;
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgIds = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_accountcash", (String)"47156aff000000ac");
            ArrayList<ComboItem> orgItem = new ArrayList<ComboItem>();
            if (orgIds == null || orgIds.size() == 0) {
                orgItem.add(new ComboItem(new LocaleString(""), "0"));
            } else {
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrg", (String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIds)}, null);){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        orgItem.add(new ComboItem(new LocaleString(row.getString("name")), row.getString("id")));
                    }
                }
            }
            commonFilterColumn.setComboItems(orgItem);
            commonFilterColumn.setDefaultValue("");
        }
    }
}

