/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.SignCallbackEvent;
import kd.bos.form.SignCallbackLisenter;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.business.helper.AgentFillPropHelper;
import kd.fi.cas.business.helper.VisibleVirtualAcctHelper;
import kd.fi.cas.business.opservice.helper.HandLinkBillHelper;
import kd.fi.cas.enums.AsstActTypeAddressEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.formplugin.common.CasBillEdit;
import kd.fi.cas.formplugin.helper.InitCheckPluginHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.AgentPayBillPluginHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.BotpFixLinkHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.CountryHelper;
import kd.fi.cas.helper.DynamicListHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PermissionHelper;
import kd.fi.cas.helper.PluginSignHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.SystemParameterFcsHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.SCAccountInfo;
import kd.fi.cas.pojo.BizBalanceModelBean;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FormUtils;
import org.apache.commons.lang.StringUtils;

public class AgentPayBillEdit
extends CasBillEdit
implements ClickListener,
SignCallbackLisenter {
    private static Log logger = LogFactory.getLog(AgentPayBillEdit.class);
    private static final String SAVE = "bar_save";
    private static final String SUBMIT = "bar_submit";
    private static final String CANCELPAY = "bar_cancelpay";
    private static final String PAYEENAMEF7 = "payeenamef7";
    private static final String PAYEEACCTBANKF7 = "payeeaccountf7";
    private static final String PAYEETYPELIST = "payeetypelist";
    private boolean cancelProChangedOnce = false;
    private boolean isInLoadAction = false;
    private static final String KEY_CANCELLATION = "cancellation";
    private Long internalID;
    private static final String KEY_DIFFPAY_CALLBACK = "KEY_DIFFPAY_CALLBACK";
    private boolean skipPropChange;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"payeename", "payeeacctbank", "encryptpayeeacctbank", "payeebankname", "applyname"});
        this.initF7();
    }

    private void initF7() {
        BasedataEdit openorg = (BasedataEdit)this.getControl("openorg");
        openorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthAcctOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_agentpaybill", (String)"47156aff000000ac");
            if (orgList.size() > 0) {
                showParameter.setCustomParam("range", new ArrayList(orgList));
            }
        });
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_agentpaybill", (String)"47156aff000000ac");
            if (orgList.size() > 0) {
                showParameter.setCustomParam("range", new ArrayList(orgList));
            }
        });
        BasedataEdit payerAcctBankF7 = (BasedataEdit)this.getControl("payeracctbank");
        payerAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long currencyId;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Long orgId = this.getPk("org");
            DynamicObject settletype = this.getDynamicObject("settletype");
            boolean settleTypeVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)settletype);
            filters.add(AccountBankHelper.getUsableFilter_new());
            if (orgId != null) {
                QFilter acctBankFilter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgId);
                filters.add(acctBankFilter);
            }
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (this.isBotpCreate() && !isDiffCur.booleanValue() && (currencyId = this.getPk("currency")) != null) {
                filters.add(new QFilter("currency.fbasedataid.id", "=", (Object)currencyId));
            }
            if (settleTypeVirtual) {
                filters.add(new QFilter("isvirtual", "=", (Object)"1"));
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ifm_inneracct", (String)"id", (QFilter[])new QFilter[0]);
            List innerAcctIds = Stream.of(dynamicObjects).map(v -> v.get("id")).collect(Collectors.toList());
            filters.add(new QFilter("inneracct.id", "not in", innerAcctIds));
            String filterIsElec = "0";
            boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settletype);
            String businessType = (String)this.getValue("businesstype");
            if (isDcep && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                filterIsElec = "1";
            }
            filters.add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
            showParameter.setCustomParam("filterTransferViewOrg", (Object)"1");
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setQFilters(filters);
        });
        BasedataEdit accountCashF7 = (BasedataEdit)this.getControl("accountcash");
        accountCashF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Long currencyId;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Long orgId = this.getPk("org");
            if (orgId != null) {
                QFilter[] usableAccountFilter = AccountCashHelper.getUsableAccountFilter((Long)orgId);
                filters.addAll(Arrays.asList(usableAccountFilter));
            } else {
                filters.add(AccountCashHelper.getUsableFilter());
            }
            Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
            if (this.isBotpCreate() && !isDiffCur.booleanValue() && (currencyId = this.getPk("currency")) != null) {
                filters.add(new QFilter("currency.fbasedataid.id", "=", (Object)currencyId));
            }
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setQFilters(filters);
        });
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (!this.isDelegAgent() && !isDiffCur.booleanValue()) {
            BasedataEdit currencyF7 = (BasedataEdit)this.getControl("currency");
            currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                QFilter filter = new QFilter("enable", "=", (Object)"1");
                boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype"));
                Collection currencys = new ArrayList();
                if (isCash) {
                    Long accountId = this.getPk("accountcash");
                    if (accountId != null) {
                        currencys = AccountCashHelper.getCurrencys(Collections.singletonList(accountId));
                    }
                } else {
                    Long accountId = this.getPk("payeracctbank");
                    if (accountId != null) {
                        currencys = AccountBankHelper.getCurrencyPks((long)accountId);
                    }
                }
                if (!currencys.isEmpty()) {
                    filter = filter.and(new QFilter("id", "in", currencys));
                }
                showParameter.getListFilterParameter().setFilter(filter);
            });
        }
        BasedataEdit erPayeeF7 = (BasedataEdit)this.getControl("erpayeef7");
        erPayeeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int index = this.getModel().getEntryCurrentRowIndex("entry");
            Object payeeName = this.getModel().getValue("payeename", index);
            DynamicObject user = this.getDynamicObject("payee", index);
            QFilter filter = new QFilter("status", "=", (Object)Character.valueOf('C'));
            if (user != null) {
                QFilter isemployeeFilter;
                QFilter payerFilter = new QFilter("payer", "=", user.getPkValue());
                DynamicObjectCollection query = QueryServiceHelper.query((String)"er_payeer", (String)"id", (QFilter[])new QFilter[]{filter, payerFilter, isemployeeFilter = new QFilter("isemployee", "=", (Object)Character.valueOf('1'))});
                if (query.isEmpty() && !StringUtils.isBlank((String)payeeName.toString().trim())) {
                    filter = filter.and(new QFilter("name", "=", payeeName));
                    filter.and(new QFilter("isemployee", "=", (Object)Character.valueOf('0')));
                } else {
                    filter = new QFilter("id", "in", (Object)query.stream().map(dy -> dy.get("id")).toArray());
                }
            } else if (!StringUtils.isBlank((String)payeeName.toString().trim())) {
                filter = filter.and(new QFilter("name", "=", payeeName));
            }
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit payeeAcctBankF7 = (BasedataEdit)this.getControl(PAYEEACCTBANKF7);
        payeeAcctBankF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            if (!"bd_accountbanks".equals(this.getPayeeType())) {
                int index = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject payee = this.getDynamicObject("payee", index);
                if (payee != null) {
                    Long orgId = null;
                    if (this.isPayeeCustomer() || this.isPayeeSupplier()) {
                        orgId = this.internalID;
                    } else if (this.isPayeeOrg()) {
                        orgId = payee.getLong("id");
                    }
                    if (orgId != null && (this.isPayeeCustomer() || this.isPayeeSupplier() || this.isPayeeOrg())) {
                        QFilter tempQ = new QFilter("company", "in", (Object)orgId);
                        filters.add(tempQ);
                        String[] temp = new String[]{"normal", "freeze"};
                        QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
                        filters.add(qFilter);
                    } else {
                        filters.addAll(Arrays.asList(AccountBankHelper.getUsableAccountFilter((long)orgId)));
                    }
                    showParameter.setUseOrgId(orgId.longValue());
                } else {
                    String[] temp = new String[]{"normal", "freeze"};
                    QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
                    filters.add(qFilter);
                }
            }
            showParameter.getListFilterParameter().setQFilters(filters);
        });
        BasedataEdit payeeF7 = (BasedataEdit)this.getControl("payee");
        payeeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            if (this.isPayeeOrg()) {
                showParameter.setCustomParam("islockfunc", (Object)Boolean.TRUE);
                showParameter.setCustomParam("orgFuncId", (Object)"08");
            } else if (this.isPayeeCustomer() || this.isPayeeSupplier()) {
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("enable", "=", (Object)"1"));
                if (this.isPayeeSupplier()) {
                    filters.add(new QFilter("payhold", "=", (Object)"0"));
                }
                showParameter.setCustomParam("orgFuncId", (Object)"08");
            }
            showParameter.getListFilterParameter().setQFilters(filters);
        });
        BasedataEdit delegorg = (BasedataEdit)this.getView().getControl("delegorg");
        delegorg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCustomParam("orgFuncId", (Object)"08");
        });
        CasPluginHelper.filterNetBankAcct((BasedataEdit)((BasedataEdit)this.getControl("netbankacct")), (DynamicObject)((DynamicObject)this.getValue("payeracctbank")));
        this.setSettlementTypeFilter();
        this.fillFundFlow();
    }

    private void fillFundFlow() {
    }

    @Override
    protected void setSettlementTypeFilter() {
        BasedataEdit settletypeF7 = (BasedataEdit)this.getControl("settletype");
        settletypeF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObjectCollection settlementypes;
            DynamicObject payerAcctBank;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (kd.fi.cas.util.StringUtils.isNotEmpty((String)this.getControlBankAcctForSettleType()) && (payerAcctBank = (DynamicObject)this.getModel().getValue(this.getControlBankAcctForSettleType())) != null && (settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype")) != null && settlementypes.size() > 0) {
                HashSet<Long> idSet = new HashSet<Long>();
                for (DynamicObject settlementype : settlementypes) {
                    idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
                }
                QFilter qFilter = new QFilter("id", "in", idSet);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    @Override
    protected String getControlBankAcctForSettleType() {
        return "payeracctbank";
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultPaymentChannelValue();
        BillModel model = (BillModel)this.getModel();
        if (!model.isFromImport()) {
            this.createNewModel();
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"netbankacct"});
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payer"));
            this.accountCashChanged();
        }
        this.setCountryValue();
        this.currencyChanged(this.getValue("currency"), false);
        this.setDiffCurInfo();
        DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
        if (crossTranType0 != null) {
            DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
            DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
            this.isCrossTranTypeHide(dynamicObjectCollection);
        }
    }

    private void setDefaultPaymentChannelValue() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue("counter");
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u67dc\u53f0", (String)"AgentPayBillEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        comboItems.add(comboItem);
        paymentChannel.setComboItems(comboItems);
        this.getModel().setValue("paymentchannel", (Object)comboItem.getValue());
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.afterImport();
    }

    private void createNewModel() {
        DynamicObject dyBilltype;
        DynamicObjectCollection coll;
        List value;
        Iterator iterator;
        this.setValueIfAbsent("bizdate", DateUtils.getCurrentDate());
        this.setValue("settletype", BaseDataHelper.getDefaultSettleType());
        String billType = (String)this.getView().getFormShowParameter().getCustomParam("billtype");
        String paymentTypeNum = null;
        String billtypeId = "";
        if (!this.isAddNew() && this.getPageCache().get("billtype") != null) {
            this.setValue("billtype", Long.valueOf(this.getPageCache().get("billtype")));
        } else if ("fee".equals(billType)) {
            this.setValue("billtype", 343122285806233600L);
            paymentTypeNum = "211";
            billtypeId = "343122285806233600";
        } else if ("salary".equals(billType)) {
            this.setValue("billtype", 343121063871251456L);
            paymentTypeNum = "997";
            billtypeId = "343121063871251456";
        } else {
            this.setValue("billtype", 343121063871251456L);
            paymentTypeNum = "997";
            billtypeId = "343121063871251456";
        }
        QFilter[] filters = new QFilter[]{new QFilter("biztype", "=", (Object)paymentTypeNum).and("enable", "=", (Object)"1")};
        Map paymentTypes = BusinessDataServiceHelper.loadFromCache((String)"cas_paymentbilltype", (String)"id,fundflowitem", (QFilter[])filters, (String)"default desc,predata desc");
        if (EmptyUtil.isNoEmpty((Object)paymentTypes) && (iterator = paymentTypes.entrySet().iterator()).hasNext()) {
            DynamicObject paymentType = (DynamicObject)iterator.next().getValue();
            this.setValue("paymenttype", paymentType);
            this.fillFundflowItem(true, paymentType.getDynamicObject("fundflowitem"));
        }
        Long orgId = this.getPk("org");
        this.setDefaultExratetable(orgId);
        this.payerChanged(orgId);
        this.payerAcctBankChanged(this.getValue("payeracctbank"));
        this.setOpenOrg();
        if (kd.fi.cas.util.StringUtils.isNotEmpty((String)billtypeId) && (value = (coll = (dyBilltype = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"bos_billtype")).getDynamicObjectCollection("fieldcontrolentry")).stream().filter(field -> "isencryption".equals(field.get("fieldkey").toString())).map(dy -> dy.get("defaultvalue").toString()).collect(Collectors.toList())).size() == 1) {
            boolean isencryption = value.get(0) != null && "true".equals(value.get(0));
            this.setValue("isencryption", isencryption);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.isInLoadAction = true;
        this.setValue(PAYEETYPELIST, this.getValue("payeetype"));
        this.getPageCache().put("loaddata", "true");
        BigDecimal payAmount = this.getBigDecimal("payamount");
        payAmount = payAmount == null ? BigDecimal.ZERO : payAmount;
        BigDecimal actPayAmt = this.getBigDecimal("actpayamount");
        actPayAmt = actPayAmt == null ? BigDecimal.ZERO : actPayAmt;
        this.setValue("amountveriance", payAmount.subtract(actPayAmt));
        int count = (Integer)this.getValue("count");
        int actCount = (Integer)this.getValue("actcount");
        this.setValue("countveriance", count - actCount);
        this.showBalance(null);
    }

    private void setNetBankAcctVisible() {
        String paymentchannel = (String)this.getValue("paymentchannel");
        if (null != paymentchannel && "onlinebank".equals(paymentchannel) && CasPluginHelper.isExistOnlineNetBank((DynamicObject)((DynamicObject)this.getValue("payeracctbank")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"netbankacct"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"netbankacct"});
        }
    }

    private void setPayTimeVisible() {
        boolean tempBoolean = false;
        String paymentchannel = (String)this.getValue("paymentchannel");
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entry");
        for (DynamicObject entry : entryCol) {
            boolean Boolean2 = entry.getBoolean("e_issuccess");
            if (!Boolean2) continue;
            tempBoolean = true;
            break;
        }
        if (null != paymentchannel && "bei".equals(paymentchannel) && tempBoolean) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"e_paytime"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"acttradedate"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"acttradedate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"e_paytime"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"acttradedate"});
        }
    }

    private void setRefundtyprVisible() {
        boolean tempBoolean = false;
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entry");
        for (DynamicObject entry : entryCol) {
            boolean Boolean2 = entry.getBoolean("e_isrefund");
            if (!Boolean2) continue;
            tempBoolean = true;
            break;
        }
        if (tempBoolean) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"refundtype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"refundtype"});
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject dyBilltype;
        DynamicObjectCollection coll;
        List value;
        String billtypeId;
        List workflowlist;
        DynamicObject org = this.getDynamicObject("org");
        InitCheckPluginHelper.checkInitForPlugin(this.getView(), org, new String[]{SAVE, SUBMIT});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean showConer = true;
        if (customParams.get("showConer") != null) {
            showConer = (Boolean)customParams.get("showConer");
        }
        if (CollectionUtils.isEmpty((Collection)(workflowlist = WorkflowServiceHelper.getAllApprovalRecord((String)this.getModel().getDataEntity().getPkValue().toString()))) || !showConer.booleanValue()) {
            SplitContainer control = (SplitContainer)this.getControl("splitcontainerap");
            control.hidePanel(SplitDirection.right, true);
            control.setCollapse("splitpanelap1", true);
        }
        if (!this.isAddNew()) {
            this.showBalance(null);
        }
        this.getPageCache().put("billtype", String.valueOf(((DynamicObject)this.getModel().getValue("billtype")).getLong("id")));
        if (this.isBotpNew()) {
            this.getPageCache().put("setdefaultpayeetypelist", "true");
            this.setValue(PAYEETYPELIST, this.getValue("payeetype"));
            DynamicObject acctBank = this.getDynamicObject("payeracctbank");
            if (acctBank != null) {
                DynamicObject bank = acctBank.getDynamicObject("bank");
                this.setValueIfAbsent("payerbank", bank);
                this.setValueIfAbsent("openorg", acctBank.getDynamicObject("openorg"));
            }
            if (org != null) {
                DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)((Long)org.getPkValue()));
                if (baseCurrency == null) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{SAVE, SUBMIT});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_del", "bar_unsubmit", "bar_submitandnew", "bar_audit", "bar_more", "bar_unaudit", "bar_pay", CANCELPAY, "bar_commitbe", "genvoucher"});
                    this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                    this.getView().showErrorNotification(SystemStatusCtrolHelper.notFinishInitSetMsg((String)CasHelper.getLocalValue((DynamicObject)org, (String)"name")));
                    return;
                }
                this.setValue("basecurrency", baseCurrency);
            }
            this.setDiffCurInfo();
            this.setCountryValue();
            DynamicObject paymentType = this.getDynamicObject("paymenttype");
            if (paymentType != null) {
                paymentType = BusinessDataServiceHelper.loadSingleFromCache((Object)paymentType.getPkValue(), (String)"cas_paymentbilltype", (String)"id,fundflowitem");
                this.fillFundflowItem(false, paymentType.getDynamicObject("fundflowitem"));
            }
        }
        if (null == this.getDynamicObject("exratetable")) {
            Long orgId = this.getPk("org");
            this.setDefaultExratetable(orgId);
        }
        this.setBeInfoVisibility();
        this.setAccountVisibility();
        this.setCurrencyEditable();
        if (this.isInLoadAction) {
            this.getModel().setDataChanged(false);
            this.isInLoadAction = false;
        }
        if (this.isDelegPush()) {
            this.setBaseCurrency();
        }
        DynamicObject accountBank = this.getDynamicObject("payeracctbank");
        this.setPaymentChannelValue(accountBank, false);
        if (this.isCopy()) {
            this.setValue(PAYEETYPELIST, this.getValue("payeetype"));
            this.calculateAmount();
            this.showBalance(null);
        }
        this.setExchangerateEditable();
        this.isCrossPayVisibility();
        this.setCrossPayValue();
        this.setNetBankAcctVisible();
        this.isDiffCurVisibility();
        AgentPayBillPluginHelper.setMenuVisibility((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
        this.setPayTimeVisible();
        this.setRefundtyprVisible();
        this.setRefundVisible();
        this.smartMatchInfoHandel();
        DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
        if (crossTranType0 != null) {
            DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
            DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
            this.isCrossTranTypeHide(dynamicObjectCollection);
        }
        if (kd.fi.cas.util.StringUtils.isNotEmpty((String)(billtypeId = String.valueOf(((DynamicObject)this.getModel().getValue("billtype")).getLong("id")))) && (value = (coll = (dyBilltype = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"bos_billtype")).getDynamicObjectCollection("fieldcontrolentry")).stream().filter(field -> "isencryption".equals(field.get("fieldkey").toString())).map(dy -> dy.get("defaultvalue").toString()).collect(Collectors.toList())).size() == 1) {
            boolean isencryption = value.get(0) != null && "true".equals(value.get(0));
            this.setValue("isencryption", isencryption);
        }
        this.setEntrustBtnShow(this.isDelegAgent());
    }

    private void setRefundVisible() {
        boolean isRefund = false;
        IDataModel dataModel = this.getModel();
        DynamicObjectCollection entryList = dataModel.getEntryEntity("entry");
        if (CollectionUtils.isNotEmpty((Collection)entryList)) {
            for (DynamicObject entryData : entryList) {
                if (!entryData.getBoolean("e_isrefund")) continue;
                isRefund = true;
                break;
            }
        }
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(isRefund), new String[]{"totalrefundedamt", "totalremainrefundamt", "e_refundamt", "e_refunddes"});
        if (isRefund) {
            if (((Boolean)dataModel.getValue("isencryption")).booleanValue()) {
                view.setVisible(Boolean.valueOf(false), new String[]{"e_remainrefundamt"});
                view.setVisible(Boolean.valueOf(true), new String[]{"e_remainrefundamt_s"});
            } else {
                view.setVisible(Boolean.valueOf(true), new String[]{"e_remainrefundamt"});
                view.setVisible(Boolean.valueOf(false), new String[]{"e_remainrefundamt_s"});
            }
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"e_remainrefundamt", "e_remainrefundamt_s"});
        }
        boolean visibleLocalAmt = false;
        if (isRefund) {
            Long baseCurId;
            DynamicObject dataEntity = dataModel.getDataEntity();
            Long curId = Optional.ofNullable(dataEntity.getDynamicObject("currency")).map(c -> c.getLong("id")).orElse(0L);
            visibleLocalAmt = curId.compareTo(baseCurId = Long.valueOf(dataEntity.getDynamicObject("basecurrency").getLong("id"))) != 0;
        }
        view.setVisible(Boolean.valueOf(visibleLocalAmt), new String[]{"localrefundedamt", "localremainrefundamt"});
    }

    private void setDefaultExratetable(Long orgId) {
        Long exchangeRateTableId = 0L;
        try {
            exchangeRateTableId = SystemStatusCtrolHelper.getExrateTable((long)orgId).getLong("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
    }

    private void setAccountVisibility() {
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype"));
        this.getView().setVisible(Boolean.valueOf(isCash), new String[]{"accountcash"});
        this.getView().setVisible(Boolean.valueOf(!isCash), new String[]{"payeracctbank", "payerbank"});
    }

    private void settleTypeChanged() {
        block3: {
            block2: {
                this.setBeInfoVisibility();
                this.setAccountVisibility();
                this.setDefaultValueByCash();
                this.setPaymentChannelValue(this.getDynamicObject("payeracctbank"), true);
                this.setBusinessTypeInfo();
                if (!BaseDataHelper.isSettleTypeMatch((DynamicObject)this.getDynamicObject("settletype"))) break block2;
                this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue(), i);
                }
                break block3;
            }
            if (this.getModel().getValue("delegorg") != null) break block3;
            this.setValue("matchflag", AutoMatchFlagEnum.NONE.getValue());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONE.getValue(), i);
            }
        }
    }

    private void setBusinessTypeInfo() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (isDcep) {
            this.setValue("businesstype", PayBusinessTypeEnum.WALLETTRANSFER.getValue());
        } else {
            this.setValue("businesstype", null);
        }
    }

    private void accountCashChanged() {
        DynamicObject openOrg;
        DynamicObject accountCash = this.getDynamicObject("accountcash");
        if (accountCash == null) {
            this.setCurrencyEditable();
            this.showBalance(null);
            return;
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency") : this.getDynamicObject("currency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"cas_accountcash", (Object)accountCash.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            long defaultCurrencyId = accountCash.getLong("defaultcurrency.id");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrencyId);
            } else if (this.isBotpCreate()) {
                this.setValueIfAbsent("currency", defaultCurrencyId);
            } else {
                this.setValue("currency", defaultCurrencyId);
            }
        }
        if ((openOrg = (DynamicObject)this.getModel().getValue("openorg")) == null) {
            this.setValue("openorg", accountCash.getDynamicObject("openorg"));
        }
        this.setCurrencyEditable();
        this.showBalance(null);
    }

    private void setBeInfoVisibility() {
        if (this.isBEPay()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"expectdealtime"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"expectdealtime"});
        }
    }

    private boolean isBEPay() {
        DynamicObject payerAcctBank = (DynamicObject)this.getModel().getValue("payeracctbank");
        if (payerAcctBank == null) {
            return false;
        }
        boolean isPayThroughBE = "bei".equalsIgnoreCase((String)this.getModel().getValue("paymentchannel"));
        boolean isSetBankInterface = payerAcctBank.getBoolean("issetbankinterface");
        return isPayThroughBE && isSetBankInterface;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.skipPropChange) {
            this.skipPropChange = false;
            return;
        }
        if ("import".equals(this.getModel().getValue("source")) && !this.isLoadData()) {
            return;
        }
        if (this.cancelProChangedOnce) {
            this.cancelProChangedOnce = false;
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (key) {
            case "org": {
                this.payerChanged(newValue);
                break;
            }
            case "payeracctbank": {
                this.payerAcctBankChanged(newValue);
                break;
            }
            case "accountcash": {
                this.accountCashChanged();
                break;
            }
            case "settletype": {
                this.settleTypeChanged();
                break;
            }
            case "currency": {
                this.currencyChanged(newValue, true);
                this.setRecInfo("dpcurrency", newValue);
                this.setExratetableVisibility();
                break;
            }
            case "bizdate": {
                this.exratedateChanged(newValue);
                break;
            }
            case "basecurrency": 
            case "exratetable": 
            case "exratedate": {
                this.currencyChanged(newValue, false);
                break;
            }
            case "exchangerate": 
            case "agreedquotation": 
            case "payquotation": 
            case "dppayquotation": {
                this.calculateAmount();
                break;
            }
            case "e_amount": {
                this.calculateAmount();
                break;
            }
            case "billstatus": {
                AgentPayBillPluginHelper.setMenuVisibility((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "payeebanknumber": {
                this.payeeBankNumberChanged((String)newValue, rowIndex);
                break;
            }
            case "payeebank": {
                this.payeeBankChanged(newValue, rowIndex);
                break;
            }
            case "payeenamef7": {
                this.payeeNameF7Changed(newValue);
                break;
            }
            case "erpayeef7": {
                this.erPayeeInfoChanged(newValue);
                break;
            }
            case "payeetypelist": {
                this.beforePayeeTypeChanged(changeData[0]);
                break;
            }
            case "payeeaccountf7": {
                this.payeeAcctBankChanged(newValue, rowIndex);
                break;
            }
            case "payee": {
                this.payeeChanged(newValue);
                break;
            }
            case "payeename": {
                this.payeeNameTextChanged(newValue, rowIndex);
                break;
            }
            case "encryptpayeeacctbank": {
                this.setValue("payeeacctbank", newValue, rowIndex);
                this.payeeAcctBankTextChanged(newValue, rowIndex);
                break;
            }
            case "payeeacctbank": {
                this.payeeAcctBankTextChanged(newValue, rowIndex);
                break;
            }
            case "payeebankname": {
                this.payeeBankNameChanged(newValue, rowIndex);
                break;
            }
            case "bebank": {
                this.beBankChanged(newValue);
                break;
            }
            case "paymentchannel": {
                this.paymentchannelChange();
                break;
            }
            case "paymenttype": {
                if (newValue == null) break;
                this.fillFundflowItem(true, ((DynamicObject)newValue).getDynamicObject("fundflowitem"));
                break;
            }
            case "crosstrantype": {
                DynamicObject crossTranType0 = (DynamicObject)this.getModel().getValue("crosstrantype");
                if (crossTranType0 == null) break;
                DynamicObject crossTransType = BusinessDataServiceHelper.loadSingle((Object)crossTranType0.getPkValue(), (String)"bei_crosstrantype");
                DynamicObjectCollection dynamicObjectCollection = crossTransType.getDynamicObjectCollection("entry");
                this.isCrossTranTypeHide(dynamicObjectCollection);
                for (DynamicObject dyobj : dynamicObjectCollection) {
                    String settleMethod = ResManager.loadKDString((String)"\u6e05\u7b97\u65b9\u5f0f", (String)"AgentPayBillEdit_23", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                    if (!StringUtils.equals((String)settleMethod, (String)dyobj.getString("fieldname")) || !StringUtils.isNotEmpty((String)dyobj.getString("defaultvalue"))) continue;
                    this.getModel().setValue("settlementmethod", (Object)dyobj.getString("defaultvalue"));
                }
                break;
            }
            case "applyid": {
                DynamicObject applyDo = (DynamicObject)newValue;
                if (applyDo == null) break;
                String name = applyDo.getString("name");
                String phone = applyDo.getString("phone");
                this.getModel().beginInit();
                this.getModel().setValue("applyname", (Object)name);
                this.getModel().endInit();
                if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)phone)) {
                    this.getModel().setValue("applyphone", (Object)phone);
                }
                this.getView().updateView("applyname");
                break;
            }
            case "iscrosspay": {
                if (newValue != null && !((Boolean)newValue).booleanValue()) {
                    this.clearDefaultAddress();
                    break;
                }
                if (newValue == null || !((Boolean)newValue).booleanValue()) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
                    int index = 0;
                    for (DynamicObject row : entryEntity) {
                        this.setDefaultAddress(row.get("payee"), index++);
                    }
                }
                this.getView().updateView("entry");
                break;
            }
            case "delegorg": {
                this.setEntrustBtnShow(EmptyUtil.isNoEmpty((Object)newValue));
                if (newValue != null) {
                    this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue(), i);
                    }
                } else {
                    this.setValue("matchflag", AutoMatchFlagEnum.NONE.getValue());
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONE.getValue(), i);
                    }
                }
                break;
            }
        }
    }

    private void isCrossTranTypeHide(DynamicObjectCollection dyobj) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] crossTransType = BusinessDataServiceHelper.load((String)"bei_crosstranfield", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        Set number = dyobj.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        Arrays.stream(crossTransType).forEach(e -> {
            if (!number.contains(e.getLong("id"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{e.getString("number")});
            }
        });
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection entry;
        int length;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("entry".equals(entryName) && (length = (entry = this.getModel().getEntryEntity("entry")).size()) > 0) {
            DynamicObject settleType;
            Boolean isHeadPush;
            Object payeetypelist = this.getModel().getValue(PAYEETYPELIST);
            if (!"other".equals(payeetypelist)) {
                this.getModel().setValue("importpayeetype", payeetypelist, length - 1);
            }
            if ((isHeadPush = (Boolean)this.getValue("isheadpush")).booleanValue()) {
                this.getModel().setValue("sourcebillid", this.getValue("hsourcebillid"), length - 1);
                this.getModel().setValue("sourceentryid", this.getValue("hsourceentryid"), length - 1);
            }
            if (BaseDataHelper.isSettleTypeMatch((DynamicObject)(settleType = (DynamicObject)this.getModel().getValue("settletype"))) || this.getModel().getValue("delegorg") != null) {
                this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue(), length - 1);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject settleType = (DynamicObject)this.getModel().getValue("settletype");
        if (BaseDataHelper.isSettleTypeMatch((DynamicObject)settleType) || this.getModel().getValue("delegorg") != null) {
            this.setValue("matchflag", AutoMatchFlagEnum.NONEED.getValue());
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue(), i);
            }
        }
    }

    private void paymentchannelChange() {
        String paymentchannel = (String)this.getValue("paymentchannel");
        if ("onlinebank".equals(paymentchannel) && CasPluginHelper.isExistOnlineNetBank((DynamicObject)((DynamicObject)this.getValue("payeracctbank")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"netbankacct"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"netbankacct"});
        }
        this.isCrossPayVisibility();
    }

    private Boolean isRecCountryCross() {
        Boolean isCross = Boolean.FALSE;
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue("entry");
        if (entrys == null || entrys.size() <= 0) {
            return isCross;
        }
        for (DynamicObject row : entrys) {
            DynamicObject payeeBank = row.getDynamicObject("payeebank");
            DynamicObject recCountry = payeeBank != null ? payeeBank.getDynamicObject("country") : null;
            if (recCountry == null || CountryHelper.isChina((DynamicObject)recCountry)) continue;
            isCross = Boolean.TRUE;
            break;
        }
        return isCross;
    }

    private void exratedateChanged(Object newValue) {
        if (newValue == null) {
            return;
        }
        this.setValue("exratedate", newValue);
    }

    private void payeeNameTextChanged(Object newValue, int rowIndex) {
        if (CasHelper.isEmpty((Object)newValue)) {
            this.clearField(rowIndex, "payeeacctbank", "encryptpayeeacctbank", "payeebank", "payeebankname", "payeebanknumber");
        }
    }

    private void payeeAcctBankTextChanged(Object newValue, int rowIndex) {
        if (CasHelper.isEmpty((Object)newValue)) {
            this.clearField(rowIndex, "payeebank", "payeebankname", "payeebanknumber");
        }
    }

    private void clearField(int rowIndex, String ... fieldKeys) {
        for (String key : fieldKeys) {
            this.setValue(key, null, rowIndex);
        }
    }

    private void payerChanged(Object newValue) {
        DynamicObject defaultPayAccount;
        this.setValue("payeracctbank", null);
        this.setValue("basecurrency", null);
        if (newValue == null) {
            return;
        }
        Long orgId = null;
        if (newValue instanceof DynamicObject) {
            DynamicObject org = (DynamicObject)newValue;
            orgId = org.getLong("id");
        } else if (newValue instanceof Long) {
            orgId = (Long)newValue;
        } else {
            return;
        }
        this.setValue("basecurrency", OrgHelper.getBaseCurrency((long)orgId));
        if (!this.isDelegAgent() && !BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype")) && (defaultPayAccount = AccountBankHelper.getDefaultPayAccount((Long)orgId)) != null && (BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue() || !BaseDataHelper.isSettleTypeVirtual((DynamicObject)this.getDynamicObject("settletype")) && !VisibleVirtualAcctHelper.checkVirtualAcct((DynamicObject)defaultPayAccount).booleanValue())) {
            this.setValue("payeracctbank", defaultPayAccount);
        }
    }

    private void payerAcctBankChanged(Object newValue) {
        DynamicObject openOrg;
        this.getModel().setValue("payerbank", null);
        this.setValue("feeactbank", null);
        if (newValue == null) {
            this.setCurrencyEditable();
            this.showBalance(null);
            return;
        }
        DynamicObject payerAcctBank = (DynamicObject)newValue;
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            this.setValue("feeactbank", payerAcctBank);
        }
        this.setValue("payerbank", payerAcctBank.getDynamicObject("bank"));
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        DynamicObject payCurrency = null;
        payCurrency = isDiffCur != false ? this.getDynamicObject("dpcurrency") : this.getDynamicObject("currency");
        boolean containCurrency = AccountBankHelper.isAcctBankContainCurrency((String)"bd_accountbanks", (Object)payerAcctBank.getPkValue(), (DynamicObject)payCurrency);
        if (!containCurrency) {
            long defaultCurrencyId = payerAcctBank.getLong("defaultcurrency.id");
            if (isDiffCur.booleanValue()) {
                this.setValue("dpcurrency", defaultCurrencyId);
            } else if (this.isBotpCreate()) {
                this.setValueIfAbsent("currency", defaultCurrencyId);
            } else {
                this.setValue("currency", defaultCurrencyId);
            }
        }
        if ((openOrg = (DynamicObject)this.getModel().getValue("openorg")) == null) {
            this.setValue("openorg", payerAcctBank.getDynamicObject("openorg"));
        }
        this.showBalance(payerAcctBank);
        this.setBeInfoVisibility();
        this.setCurrencyEditable();
        this.setPaymentChannelValue(payerAcctBank, true);
        this.setSettleTypeValue(payerAcctBank);
    }

    private void setPaymentChannelValue(DynamicObject payerAcctBank, boolean isAdd) {
        ComboItem item2;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboEdit paymentChannel = (ComboEdit)this.getControl("paymentchannel");
        DynamicObject settleType = this.getDynamicObject("settletype");
        ComboItem comboItem = new ComboItem();
        comboItem.setValue("counter");
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u67dc\u53f0", (String)"AgentPayBillEdit_13", (String)"fi-cas-formplugin", (Object[])new Object[0])));
        ComboItem selectedItem = comboItem;
        comboItems.add(comboItem);
        if (null == payerAcctBank || settleType != null && "14".equals(settleType.getString("settlementtype"))) {
            paymentChannel.setComboItems(comboItems);
            this.getModel().setValue("paymentchannel", (Object)selectedItem.getValue());
            return;
        }
        if (payerAcctBank.getBoolean("isopenbank")) {
            item2 = new ComboItem();
            item2.setValue("onlinebank");
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7f51\u4e0a\u94f6\u884c", (String)"AgentPayBillEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item2;
            comboItems.add(item2);
        }
        if (payerAcctBank.getBoolean("issetbankinterface")) {
            item2 = new ComboItem();
            item2.setValue("bei");
            item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u94f6\u4f01\u4e92\u8054", (String)"AgentPayBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            selectedItem = item2;
            comboItems.add(item2);
        }
        String defaultPaymentChannel = "";
        if (Objects.nonNull(settleType)) {
            String paymentChannelRange = settleType.getString("paymentchannel");
            defaultPaymentChannel = settleType.getString("defaultpaymentchannel");
            if (StringUtils.isNotEmpty((String)paymentChannelRange)) {
                Set paymentChannels = Arrays.stream(paymentChannelRange.split(",")).filter(kd.bos.dataentity.utils.StringUtils::isNotEmpty).collect(Collectors.toSet());
                comboItems.removeIf(i -> !paymentChannels.contains(i.getValue()));
            }
        }
        paymentChannel.setComboItems(comboItems);
        if (isAdd || this.isBotpNew() && Objects.isNull(this.getModel().getValue("paymentchannel"))) {
            String defChannel = selectedItem.getValue();
            if (settleType != null && !SettleMentTypeEnum.COLLECT.getValue().equals(settleType.getString("settlementtype"))) {
                defChannel = PaymentChannelEnum.COUNTER.getValue();
            }
            if (StringUtils.isNotEmpty((String)defaultPaymentChannel)) {
                defChannel = defaultPaymentChannel;
            }
            String finalDefChannel = defChannel;
            boolean contains = comboItems.stream().anyMatch(item -> Objects.equals(finalDefChannel, item.getValue()));
            if (!contains) {
                defChannel = null;
            }
            this.getModel().setValue("paymentchannel", (Object)defChannel);
        }
    }

    private void setCurrencyEditable() {
        boolean isCurrencyEditable = true;
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)this.getDynamicObject("settletype"));
        if (isCash) {
            DynamicObject accountCash = this.getDynamicObject("accountcash");
            if (accountCash != null) {
                isCurrencyEditable = !accountCash.getBoolean("isbycurrency");
            }
        } else {
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            if (accountBank != null) {
                isCurrencyEditable = accountBank.getBoolean("ismulcurrency");
            }
        }
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(isCurrencyEditable), new String[]{"dpcurrency"});
        } else {
            this.getView().setEnable(Boolean.valueOf(isCurrencyEditable), new String[]{"currency"});
        }
        if (this.isBotpCreate()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
        }
    }

    private void currencyChanged(Object newValue, boolean isReBalance) {
        if (isReBalance) {
            this.showBalance(null);
        }
        this.setExchangerateEditable();
    }

    private void calculateAmount() {
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = this.getBigDecimal("exchangerate");
        String quotation = this.getString("payquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int count = this.getModel().getEntryRowCount("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        boolean isNotInAmount = !AgentPayBillPluginHelper.isEncodeAmount((IDataModel)this.getModel(), (IFormView)this.getView());
        for (int i = 0; i < count; ++i) {
            DynamicObject rowInfo = this.getModel().getEntryRowEntity("entry", i);
            BigDecimal amount = AgentPayBillPluginHelper.getEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)rowInfo);
            sumAmt = sumAmt.add(amount);
            BigDecimal localamt = QuotationHelper.callToCurrency((BigDecimal)amount, (BigDecimal)exchangeRate, (String)quotation, (int)round);
            if (isNotInAmount) {
                this.setValue("e_localamt", localamt, i);
            }
            sumLocalAmt = sumLocalAmt.add(localamt);
        }
        this.setValue("payamount", sumAmt);
        this.setValue("localamt", sumLocalAmt);
        this.calculateDpAmt();
    }

    private void calculateDpAmt() {
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        DynamicObject currency = this.getDynamicObject("currency");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal payamount = this.getBigDecimal("payamount");
        if (currency != null) {
            payamount = payamount.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = this.getBigDecimal("localamt");
        BigDecimal agreedRate = this.getBigDecimal("agreedrate");
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal dpAmt = QuotationHelper.callToCurrency((BigDecimal)payamount, (BigDecimal)agreedRate, (String)agreedquotation, (int)dppayround);
        BigDecimal dpExchangeRate = this.getBigDecimal("dpexchangerate");
        BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpExchangeRate, (String)dppayquotation, (int)round);
        this.getModel().beginInit();
        this.setValue("dpamt", dpAmt);
        this.setValue("dplocalamt", dpLocalAmt);
        this.setValue("lossamt", localAmt.subtract(dpLocalAmt));
        this.getModel().endInit();
        this.getView().updateView("dpamt");
        this.getView().updateView("dplocalamt");
        this.getView().updateView("lossamt");
        this.calculateEntryDpAmt();
    }

    private void calculateEntryDpAmt() {
        Boolean isDiffCur = (Boolean)this.getValue("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            this.clearEntryField("e_dpamt", "e_dplocalamt");
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        for (DynamicObject row : entry) {
            int rowIdx = row.getInt("seq") - 1;
            BigDecimal amount = AgentPayBillPluginHelper.getEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)row);
            if (amount != null && amount.compareTo(new BigDecimal(0)) > 0) {
                rowIndexs.add(rowIdx);
                continue;
            }
            this.setValue("e_dpamt", null, rowIdx);
            this.setValue("e_dplocalamt", null, rowIdx);
        }
        int size = rowIndexs.size();
        if (size <= 0) {
            return;
        }
        BigDecimal dpamt = this.getBigDecimal("dpamt");
        BigDecimal dplocalamt = this.getBigDecimal("dplocalamt");
        BigDecimal dpexchangerate = this.getBigDecimal("dpexchangerate");
        BigDecimal agreedrate = this.getBigDecimal("agreedrate");
        DynamicObject dpcurrency = this.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = this.getDynamicObject("basecurrency");
        String dppayquotation = this.getString("dppayquotation");
        String agreedquotation = this.getString("agreedquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        int dppayround = 10;
        if (dpcurrency != null) {
            dppayround = dpcurrency.getInt("amtprecision");
        }
        BigDecimal sumDpamt = BigDecimal.ZERO;
        BigDecimal sumDpLocalamt = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            int rowIdx = (Integer)rowIndexs.get(i);
            BigDecimal edpamt = BigDecimal.ZERO;
            BigDecimal edplocalamt = BigDecimal.ZERO;
            if (i == size - 1) {
                edpamt = dpamt.subtract(sumDpamt);
                edplocalamt = dplocalamt.subtract(sumDpLocalamt);
            } else {
                BigDecimal eamount = AgentPayBillPluginHelper.getEntryAmount((IDataModel)this.getModel(), (IFormView)this.getView(), (int)rowIdx);
                edpamt = QuotationHelper.callToCurrency((BigDecimal)eamount, (BigDecimal)agreedrate, (String)agreedquotation, (int)dppayround);
                sumDpamt = sumDpamt.add(edpamt);
                edplocalamt = QuotationHelper.callToCurrency((BigDecimal)edpamt, (BigDecimal)dpexchangerate, (String)dppayquotation, (int)round);
                sumDpLocalamt = sumDpLocalamt.add(edplocalamt);
            }
            this.setValue("e_dpamt", edpamt, rowIdx);
            this.setValue("e_dplocalamt", edplocalamt, rowIdx);
        }
    }

    private void beforePayeeTypeChanged(ChangeData changeData) {
        if (this.isCopy() && changeData.getOldValue() == null) {
            return;
        }
        String isSetDefaultPayeeTypeList = this.getPageCache().get("setdefaultpayeetypelist");
        if (Boolean.parseBoolean(isSetDefaultPayeeTypeList)) {
            return;
        }
        List emptyRows = FormUtils.getEmptyRows((IDataModel)this.getModel(), (String[])new String[]{"payeename", "payee", "payeeacctbank"});
        int rowCount = this.getModel().getEntryRowCount("entry");
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (rowCount > emptyRows.size()) {
            String confirmMessage = ResManager.loadKDString((String)"\u5207\u6362\u6536\u6b3e\u4eba\u7c7b\u578b\u5c06\u6e05\u7a7a\u5e94\u7ef4\u62a4\u7684\u5206\u5f55\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AgentPayBillEdit_4", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("payeetypechanged", (IFormPlugin)this);
            this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBacks);
            this.getPageCache().put("newpayeetype", newValue.toString());
            this.getPageCache().put("oldpayeetype", oldValue == null ? "" : oldValue.toString());
        } else {
            this.payeeTypeChanged(newValue);
            this.setPayeeTypeImport();
        }
    }

    private void setPayeeTypeImport() {
        DynamicObjectCollection entry;
        int length;
        if (null != this.getModel().getValue(PAYEETYPELIST) && (length = (entry = this.getModel().getEntryEntity("entry")).size()) > 0) {
            for (int i = 0; i < entry.size(); ++i) {
                if (!"other".equals(this.getPayeeType())) {
                    this.getModel().setValue("importpayeetype", (Object)this.getPayeeType(), i);
                    continue;
                }
                this.getModel().setValue("importpayeetype", null, i);
            }
            this.getView().updateView("entry");
        }
    }

    private void payeeTypeChanged(Object value) {
        if (null != this.getModel().getValue(PAYEETYPELIST)) {
            this.setValue("payeetype", this.getPayeeType());
        }
    }

    private void payeeChanged(Object value) {
        if (!CasHelper.isEmpty((Object)this.getPageCache().get("cas_entryimportCache"))) {
            return;
        }
        if ("bos_user".equals(this.getPayeeType())) {
            this.userF7Changed(value);
        } else if (this.isPayeeOrg()) {
            this.payeeOrgF7Changed(value);
        } else if (this.isPayeeCustomer() || this.isPayeeSupplier()) {
            this.supplierOrCustomerF7Changed(value);
        }
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.setDefaultAddress(value, entryIndex);
    }

    private void payeeOrgF7Changed(Object value) {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (value != null) {
            DynamicObject org = (DynamicObject)value;
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)((Long)org.getPkValue()));
            this.setValue(PAYEEACCTBANKF7, defaultRecAccount);
            DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)org.getPkValue(), (String)"bos_org", (String)"postcode,contactaddress");
            if (o != null) {
                this.setValue("recemail", o.getString("postcode"), entryIndex, true);
                this.setValue("recaddress", o.getString("contactaddress"), entryIndex, true);
            }
        } else {
            this.setValue("recemail", null, entryIndex, true);
            this.setValue("recaddress", null, entryIndex, true);
        }
    }

    private void userF7Changed(Object value) {
        DynamicObject user = (DynamicObject)value;
        String payeeName = null;
        String payerAccount = null;
        String payerAccount02 = null;
        DynamicObject payerBank = null;
        String recemail = null;
        String idcard = null;
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (user != null) {
            DynamicObject u;
            payeeName = user.getLocaleString("name").getLocaleValue();
            Long orgId = this.getPk("org");
            DynamicObject payeeInfo = this.getErPayeeInfo(user, orgId);
            if (payeeInfo != null) {
                payerAccount = payeeInfo.getString("payeraccount");
                payerAccount02 = payeeInfo.getString("payeraccount02");
                payerBank = payeeInfo.getDynamicObject("payerbank");
                payeeName = payeeInfo.getString("payeraccountname");
            }
            if ((u = BusinessDataServiceHelper.loadSingle((Object)user.getPkValue(), (String)"bos_user", (String)"email,idcard")) != null) {
                recemail = u.getString("email");
                String certType = (String)this.getModel().getValue("certtype");
                if ("01".equals(certType)) {
                    idcard = u.getString("idcard");
                }
            }
        }
        this.setValue("payeename", payeeName, entryIndex, true);
        this.setValue("payeeacctbank", payerAccount, entryIndex, true);
        this.setValue("encryptpayeeacctbank", payerAccount02, entryIndex, true);
        this.setValue("payeebank", payerBank, entryIndex);
        this.setValue("recemail", recemail, entryIndex, true);
        this.setValue("certnum", idcard, entryIndex, true);
    }

    private void supplierOrCustomerF7Changed(Object value) {
        String entity;
        DynamicObject basedata = (DynamicObject)value;
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.clearField(entryIndex, "payeeacctbank", "payeename", "recemail", "recaddress");
        if (basedata == null) {
            return;
        }
        Long internalOrgId = this.getInternalOrgID(basedata);
        if (internalOrgId != null && internalOrgId != 0L) {
            DynamicObject defaultRecAccount = AccountBankHelper.getDefaultRecAccount((Long)internalOrgId);
            if (defaultRecAccount != null) {
                this.setValue(PAYEEACCTBANKF7, defaultRecAccount);
            }
        } else {
            SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
            this.setSCBankInfo(defaultBankInfo);
        }
        if (CasHelper.isEmpty((Object)this.getModel().getValue("payeename", entryIndex))) {
            this.setValue("payeename", basedata.getString("name"), entryIndex, true);
        }
        String addressPropName = "bd_supplier".equals(entity = basedata.getDataEntityType().getName()) ? "supplieraddress" : "customeraddress";
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)basedata.getPkValue(), (String)entity, (String)("entry_address." + addressPropName));
        DynamicObjectCollection addressls = supplier.getDynamicObjectCollection("entry_address");
        if (addressls != null && addressls.size() > 0) {
            HashSet addressIds = new HashSet();
            addressls.forEach(a -> addressIds.add(a.get(addressPropName + "_id")));
            DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
            if (addresses != null) {
                for (DynamicObject address : addresses) {
                    if (!address.getBoolean("default")) continue;
                    this.setValue("recemail", address.getString("addemail"), entryIndex, true);
                    this.setValue("recaddress", address.getString("detailaddress"), entryIndex, true);
                    break;
                }
            }
        }
    }

    private void setSCBankInfo(SCAccountInfo scBankInfo) {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (scBankInfo == null) {
            this.clearField(entryIndex, "payeeacctbank", "payeename", "payeebank");
            return;
        }
        this.setValue("payeeacctbank", scBankInfo.getAccount(), entryIndex, true);
        this.setValue("payeebank", scBankInfo.getBeBank(), entryIndex);
        String payeeAccountName = scBankInfo.getAccountName();
        if (CasHelper.isEmpty((Object)payeeAccountName)) {
            DynamicObject payee = this.getDynamicObject("payee", entryIndex);
            payeeAccountName = payee != null ? payee.getLocaleString("name").getLocaleValue() : null;
        }
        this.setValue("payeename", payeeAccountName, entryIndex, true);
    }

    private void payeeNameF7Changed(Object newValue) {
        int entryIndex = this.getModel().getEntryCurrentRowIndex("entry");
        String payeeName = ((DynamicObject)newValue).getLocaleString("name").getLocaleValue();
        this.setValue("payeename", payeeName, entryIndex, true);
        DynamicObject payeeInfo = this.getErPayeeInfo(payeeName);
        if (payeeInfo != null) {
            this.setValue("payeeacctbank", payeeInfo.getString("payeraccount"), entryIndex, true);
            this.setValue("encryptpayeeacctbank", payeeInfo.getString("payeraccount02"), entryIndex, true);
            this.setValue("payeebank", payeeInfo.getDynamicObject("payerbank"), entryIndex);
            this.setValue("payeename", payeeInfo.getString("payeraccountname"), entryIndex, true);
        }
    }

    private DynamicObject getErPayeeInfo(String name) {
        String orderBys;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("name", "=", (Object)name);
        String selectFields = "id,name,payer,creator,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,payeraccountname";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private DynamicObject getErPayeeInfo(DynamicObject user, Long orgID) {
        String orderBys;
        DynamicObject dynamicObject = null;
        QFilter payerFilter = new QFilter("payer", "=", user.getPkValue());
        QFilter isemployeeFilter = new QFilter("isemployee", "=", (Object)Character.valueOf('1'));
        QFilter uFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter eFilter = new QFilter("enable", "=", (Object)"1");
        String selectFields = "id,name,payer,creator,payeraccount,payeraccount01,payeraccount02,payerbank_id,payerbank.name,payerbank.number,payeraccountname";
        List allPermCompanyIds = OrgHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"em", (String)"er_payeer", (String)"47150e89000000ac");
        QFilter useFilter = new QFilter("createorg.id", "in", (Object)allPermCompanyIds);
        QFilter[] qFilters = new QFilter[]{payerFilter, isemployeeFilter, uFilter, useFilter, eFilter};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    private void erPayeeInfoChanged(Object newValue) {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject payeeInfo = (DynamicObject)newValue;
        if (payeeInfo != null) {
            this.setValue("payee", payeeInfo.get("payer"), currentIndex, true);
            this.setValue("payeename", payeeInfo.getString("payeraccountname"), currentIndex, true);
            this.setValue("payeeacctbank", payeeInfo.getString("payeraccount"), currentIndex, true);
            this.setValue("encryptpayeeacctbank", payeeInfo.getString("payeraccount02"), currentIndex, true);
            DynamicObject payerbank = payeeInfo.getDynamicObject("payerbank");
            this.setValue("payeebank", payerbank, currentIndex);
        }
    }

    private void payeeAcctBankChanged(Object newValue, int rowIndex) {
        DynamicObject accountBank = (DynamicObject)newValue;
        if (accountBank == null) {
            return;
        }
        String actName = null;
        if (accountBank.getBoolean("issetbankinterface")) {
            actName = accountBank.getString("acctname");
        } else {
            DynamicObject payee = (DynamicObject)this.getModel().getValue("payee", rowIndex);
            DynamicObject internalOrg = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)payee);
            actName = this.isPayeeCustomer() || this.isPayeeSupplier() ? (internalOrg != null ? accountBank.getString("acctname") : this.getDynamicObject("payee").getString("name")) : (this.isPayeeOrg() ? accountBank.getString("acctname") : accountBank.getString("openorg.name"));
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entry");
        this.setValue("payeename", actName, currentIndex, true);
        this.setValue("payeeacctbank", accountBank.getString("bankaccountnumber"), currentIndex, true);
        this.getModel().beginInit();
        this.setValue(PAYEEACCTBANKF7, null);
        this.getModel().endInit();
        this.getView().updateView(PAYEEACCTBANKF7);
        DynamicObject bank = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBank.getLong("bank.id"), (String)"bd_finorginfo", (String)"name,union_number");
        this.setValue("payeebankname", bank.getString("name"), currentIndex, true);
        this.setValue("payeebanknumber", bank.getString("union_number"), currentIndex);
    }

    private void beBankChanged(Object newValue) {
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (newValue == null) {
            this.setValue("payeebank", null, currentIndex);
        } else {
            this.setValue("payeebank", (DynamicObject)newValue, currentIndex);
        }
    }

    private void payeeBankChanged(Object newValue, int entryIndex) {
        if (newValue == null) {
            this.setValue("payeebanknumber", null, entryIndex, true);
            this.setValue("payeebankname", null, entryIndex, true);
            this.setValue("reccountry", null, entryIndex, true);
            this.setValue("recprovince", null, entryIndex, true);
            this.setValue("reccity", null, entryIndex, true);
            this.setValue("recswiftcode", null, entryIndex, true);
            this.setValue("recroutingnum", null, entryIndex, true);
            this.setValue("recothercode", null, entryIndex, true);
            this.setValue("recbankaddress", null, entryIndex, true);
            return;
        }
        DynamicObject bankInfo = (DynamicObject)newValue;
        this.getModel().beginInit();
        this.setValue("payeebankname", bankInfo.getString("name"), entryIndex, true);
        this.getModel().endInit();
        this.getView().updateView("payeebankname", entryIndex);
        this.setValue("payeebanknumber", bankInfo.getString("union_number"), entryIndex);
    }

    private void payeeBankNameChanged(Object newValue, int entryIndex) {
        if (newValue != null && StringUtils.isNotBlank((String)newValue.toString())) {
            QFilter[] qFilters = new QFilter[]{new QFilter("name", "=", newValue), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)Character.valueOf('C'))};
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"bd_bebank", (String)"id, name, number,union_number", (QFilter[])qFilters);
            DynamicObject beBank = null;
            if (colls != null && colls.length > 0) {
                beBank = colls[0];
                this.setValue("payeebanknumber", colls[0].getString("union_number"), entryIndex);
            }
            this.setValue("payeebank", beBank, entryIndex, true);
        } else {
            this.setValue("payeebanknumber", null, entryIndex);
            this.setValue("payeebank", null, entryIndex, true);
        }
    }

    private void payeeBankNumberChanged(Object newValue, int entryIndex) {
        DynamicObject SelectedBeBank;
        String bankNumber = (String)newValue;
        DynamicObject beBank = null;
        if (EmptyUtil.isNoEmpty((String)bankNumber) && (SelectedBeBank = (DynamicObject)this.getModel().getValue("bebank")) != null) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", SelectedBeBank.getPkValue())};
            beBank = QueryServiceHelper.queryOne((String)"bd_bebank", (String)"id,name,country.id,provincetxt,citytxt,swift_code,routingnum,other_code,address_eng", (QFilter[])filters);
        }
        if (beBank != null) {
            this.setValue("recswiftcode", beBank.getString("swift_code"), entryIndex, true);
            this.setValue("recroutingnum", beBank.getString("routingnum"), entryIndex, true);
            this.setValue("recothercode", beBank.getString("other_code"), entryIndex, true);
            this.setValue("recbankaddress", beBank.getString("address_eng"), entryIndex, true);
            this.setValue("reccountry", beBank.getLong("country.id"), entryIndex);
            this.setValue("recprovince", beBank.getString("provincetxt"), entryIndex);
            this.setValue("reccity", beBank.getString("citytxt"), entryIndex);
        } else {
            this.setValue("recswiftcode", null, entryIndex, true);
            this.setValue("recroutingnum", null, entryIndex, true);
            this.setValue("recothercode", null, entryIndex, true);
            this.setValue("recbankaddress", null, entryIndex, true);
            this.setValue("reccountry", null, entryIndex);
            this.setValue("recprovince", null, entryIndex);
            this.setValue("reccity", null, entryIndex);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("payeeacctbank".equals(key) || "encryptpayeeacctbank".equals(key)) {
            this.addPayeeAccountBank();
        } else if ("payeebankname".equals(key)) {
            this.setValue("bebank", null);
            BasedataEdit beBankF7 = (BasedataEdit)this.getControl("bebank");
            beBankF7.click();
        } else if ("applyname".equals(key)) {
            BasedataEdit applyF7 = (BasedataEdit)this.getControl("applyid");
            applyF7.click();
        }
    }

    private void addPayeeAccountBank() {
        if ("other".equals(this.getPayeeType())) {
            return;
        }
        DynamicObject basedata = this.getDynamicObject("payee", this.getModel().getEntryCurrentRowIndex("entry"));
        if (basedata == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"AgentPayBillEdit_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isPaySalary()) {
            BasedataEdit erPayeeF7 = (BasedataEdit)this.getControl("erpayeef7");
            erPayeeF7.click();
            return;
        }
        if ("bos_user".equals(this.getPayeeType())) {
            BasedataEdit erPayeeF7 = (BasedataEdit)this.getControl("erpayeef7");
            erPayeeF7.click();
            return;
        }
        if (this.isPayeeCustomer()) {
            this.internalID = this.getInternalOrgID(basedata);
            if (this.internalID == null || this.internalID == 0L) {
                SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
                if (defaultBankInfo == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"AgentPayBillEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (basedata != null) {
                    this.showOuterCustomerBankInfoF7(basedata.getPkValue());
                }
                return;
            }
        } else if (this.isPayeeSupplier()) {
            this.internalID = this.getInternalOrgID(basedata);
            if (this.internalID == null || this.internalID == 0L) {
                SCAccountInfo defaultBankInfo = BaseDataHelper.getDefaultBankInfo((DynamicObject)basedata);
                if (defaultBankInfo == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"AgentPayBillEdit_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (basedata != null) {
                    this.showOuterSupplierBankInfoF7(basedata.getPkValue());
                }
                return;
            }
        }
        BasedataEdit payeeAccountF7 = (BasedataEdit)this.getControl(PAYEEACCTBANKF7);
        payeeAccountF7.click();
    }

    private Long getInternalOrgID(DynamicObject basedata) {
        DynamicObject org = BaseDataHelper.getInternalOrg((DynamicObject)this.getDynamicObject("org"), (DynamicObject)basedata);
        return org == null ? null : (Long)org.getPkValue();
    }

    private void showOuterSupplierBankInfoF7(Object pk) {
        ListShowParameter lsp = DynamicListHelper.getSupplierBankInfoShowParameter((Object)pk);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void showOuterCustomerBankInfoF7(Object pk) {
        ListShowParameter lsp = DynamicListHelper.getCustomerBankInfoShowParameter((Object)pk);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "payeeaccountbank");
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("payeeaccountbank".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection rowInfo = (ListSelectedRowCollection)returnData;
            Object entryKey = rowInfo.getEntryPrimaryKeyValues()[0];
            SCAccountInfo scBankinfo = BaseDataHelper.loadBankInfo((String)this.getPayeeType(), (Long)((Long)entryKey));
            this.setSCBankInfo(scBankinfo);
        } else if ("beforesubmit".equals(actionId)) {
            String confirm = (String)closedCallBackEvent.getReturnData();
            if (confirm != null && confirm.equals("ok")) {
                this.getView().invokeOperation("submit");
            }
        } else if ("cas_entryimport".equals(actionId)) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            logger.info("EntryImport >> Data>> {}", (Object)SerializationUtils.toJsonString((Object)returnData));
            this.entryImportDataHandler(returnData);
            if (AgentPayBillPluginHelper.isEncodeAmount((IDataModel)this.getModel(), (IFormView)this.getView())) {
                AgentPayBillPluginHelper.setEncodeField((IDataModel)this.getModel(), (IFormView)this.getView());
            }
            this.calculateAmount();
            this.getPageCache().remove("cas_entryimportCache");
        } else if (StringUtils.equals((String)actionId, (String)KEY_DIFFPAY_CALLBACK) && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("agreedrate", data.get("agreedrate").toString());
            option.setVariableValue("dpamt", data.get("dpamt").toString());
            option.setVariableValue("fee", data.get("fee").toString());
            option.setVariableValue("agreedquotation", data.get("agreedquotation").toString());
            this.getView().invokeOperation("pay", option);
        }
    }

    private void entryImportDataHandler(Map<String, Object> returnData) {
        Object imptMethod = returnData.get("imptmethod");
        if (imptMethod != null && "cover".equals(imptMethod)) {
            this.getModel().deleteEntryData("entry");
        }
        Boolean isHeadPush = (Boolean)this.getValue("isheadpush");
        List rowDatas = (List)returnData.get("rowDatas");
        StringBuilder errorInfo = new StringBuilder();
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            String agentPayBillEdit_20;
            Map row = (Map)rowDatas.get(rowNum);
            int rowIndex = this.getModel().createNewEntryRow("entry");
            try {
                BigDecimal loaclAmount;
                BigDecimal amount;
                block8: for (Map.Entry r : row.entrySet()) {
                    String value;
                    String key;
                    block43: {
                        key = (String)r.getKey();
                        value = (String)r.getValue();
                        if ((value == null || "".equals(value.trim())) && !"payeename".equals(key)) continue;
                        IDataEntityProperty property = null;
                        if (key.contains(".number")) {
                            String keyNum = key.replace(".number", "");
                            property = this.getModel().getProperty(keyNum);
                        } else if (key.contains(".name")) {
                            String keyName = key.replace(".name", "");
                            property = this.getModel().getProperty(keyName);
                        } else {
                            property = this.getModel().getProperty(key);
                        }
                        if (property == null) continue;
                        if ("e_remark".equals(key) || "payeename".equals(key)) {
                            TextAreaProp text = new TextAreaProp();
                            if (property instanceof TextAreaProp) {
                                text = (TextAreaProp)property;
                            }
                            if (text.getMaxLenth() > 0 && value != null && value.length() > text.getMaxLenth()) {
                                value = value.substring(0, text.getMaxLenth());
                                String agentPayBillEdit_16 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236\uff0c\u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AgentPayBillEdit_16", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                errorInfo.append(agentPayBillEdit_16);
                            }
                        }
                        if (property instanceof AmountProp || property instanceof DecimalProp) {
                            BigDecimal amount2 = BigDecimal.ZERO;
                            try {
                                amount2 = new BigDecimal(value);
                                if (amount2.compareTo(BigDecimal.ZERO) < 0) {
                                    throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AgentPayBillEdit_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                                }
                                if ("e_amount".equals(key)) {
                                    this.skipPropChange = true;
                                    this.getModel().setValue(key, (Object)amount2, rowIndex);
                                    this.skipPropChange = false;
                                } else {
                                    this.getModel().setValue(key, (Object)amount2, rowIndex);
                                }
                                break block43;
                            }
                            catch (Exception e) {
                                this.getModel().deleteEntryRow("entry", rowIndex);
                                String agentPayBillEdit_18 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\uff0c\u8f93\u5165\u6570\u636e\u683c\u5f0f\u6709\u8bef\u3002", (String)"AgentPayBillEdit_18", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                errorInfo.append(agentPayBillEdit_18);
                                break;
                            }
                        }
                        if (property instanceof BasedataProp) {
                            String payeetype = this.getModel().getValue("payeetype").toString();
                            if (key.contains(".number")) {
                                if (key.equals("payee.number") && row.get("payee.number") != null) {
                                    if (!"other".equals(payeetype)) {
                                        this.getModel().setValue("importpayeetype", (Object)payeetype, rowIndex);
                                    }
                                    this.getModel().setItemValueByNumber("payee", value, rowIndex);
                                    String payeeNameValue = (String)row.get("payeename");
                                    if (payeeNameValue == null || "".equals(payeeNameValue.trim())) {
                                        DynamicObject payeeDyms = BusinessDataServiceHelper.loadSingle((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)value), new QFilter("enable", "=", (Object)"1")});
                                        Object payname = payeeDyms.get("name");
                                        this.getModel().setValue("payeename", payname, rowIndex);
                                    }
                                } else {
                                    this.getModel().setItemValueByNumber(key.replace(".number", ""), value, rowIndex);
                                }
                            }
                            if (key.contains(".name")) {
                                if (key.equals("payee.name") && row.get("payee.name") != null) {
                                    String payeeNameValue;
                                    Object payee;
                                    DynamicObject payeeNameDyms = BusinessDataServiceHelper.loadSingle((String)payeetype, (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)value), new QFilter("enable", "=", (Object)"1")});
                                    if (!"other".equals(payeetype)) {
                                        this.getModel().setValue("importpayeetype", (Object)payeetype, rowIndex);
                                    }
                                    if (null == (payee = this.getModel().getValue("payee", rowIndex))) {
                                        this.getModel().setValue("payee", payeeNameDyms.getPkValue(), rowIndex);
                                    }
                                    if ((payeeNameValue = (String)row.get("payeename")) == null || "".equals(payeeNameValue.trim())) {
                                        this.getModel().setValue("payeename", (Object)value, rowIndex);
                                    }
                                }
                                if (key.equals("payeebank.name") && row.get("payeebank.name") != null) {
                                    DynamicObject payeebankNameDyms = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)value), new QFilter("enable", "=", (Object)"1")});
                                    this.getModel().setValue("payeebank", payeebankNameDyms.getPkValue(), rowIndex);
                                }
                                if (key.equals("e_fundflowitem.name") && row.get("e_fundflowitem.name") != null) {
                                    DynamicObject e_fundflowitemNameDyms = BusinessDataServiceHelper.loadSingle((String)"cas_fundflowitem", (String)"id, number,name", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)value), new QFilter("enable", "=", (Object)"1")});
                                    this.getModel().setValue("e_fundflowitem", e_fundflowitemNameDyms.getPkValue(), rowIndex);
                                }
                            }
                        } else {
                            if (property instanceof DateProp) {
                                try {
                                    this.getModel().setValue(key, (Object)value, rowIndex);
                                    break block43;
                                }
                                catch (Exception e) {
                                    this.getModel().deleteEntryRow("entry", rowIndex);
                                    String agentPayBillEdit_19 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\uff08\u793a\u4f8b\uff1a2020-01-01\uff09", (String)"AgentPayBillEdit_19", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), property.getDisplayName().getLocaleValue());
                                    errorInfo.append(agentPayBillEdit_19);
                                    break;
                                }
                            }
                            if ("payeename".equals(key)) {
                                if (value != null && !"".equals(value.trim())) {
                                    this.getModel().setValue(key, (Object)value, rowIndex);
                                }
                            } else {
                                this.getModel().setValue(key, (Object)value, rowIndex);
                            }
                        }
                    }
                    if (!"certtype".equals(key)) continue;
                    List comboItems = ((ComboProp)this.getModel().getProperty(key)).getComboItems();
                    for (ValueMapItem item : comboItems) {
                        if (value == null || !value.equals(item.getName().getLocaleValue())) continue;
                        this.getModel().setValue(key, (Object)item.getValue(), rowIndex);
                        continue block8;
                    }
                }
                if (isHeadPush.booleanValue()) {
                    this.getModel().setValue("sourcebillid", this.getValue("hsourcebillid"), rowIndex);
                    this.getModel().setValue("sourceentryid", this.getValue("hsourceentryid"), rowIndex);
                }
                if ((amount = this.getBigDecimal("e_amount", rowIndex)) != null) {
                    String encrptyAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)amount);
                    this.getModel().setValue("e_encryptamount", (Object)encrptyAmountStr, rowIndex);
                }
                if ((loaclAmount = this.getBigDecimal("e_localamt", rowIndex)) == null) continue;
                String encrptyLocalAmountStr = AgentPayBillHelper.encodeAmount((BigDecimal)loaclAmount);
                this.getModel().setValue("e_encryptlocalamt", (Object)encrptyLocalAmountStr, rowIndex);
                continue;
            }
            catch (KDBizException bizExp) {
                this.getModel().deleteEntryRow("entry", rowIndex);
                agentPayBillEdit_20 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"AgentPayBillEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), bizExp.getMessage());
                errorInfo.append(agentPayBillEdit_20);
                logger.info("EntryImport >> data >> {}", (Object)bizExp);
                continue;
            }
            catch (Exception e) {
                this.getModel().deleteEntryRow("entry", rowIndex);
                agentPayBillEdit_20 = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff1a%2$s\u3002", (String)"AgentPayBillEdit_20", (String)"fi-cas-formplugin", (Object[])new Object[0]), row.get("excelrow"), e.getMessage());
                errorInfo.append(agentPayBillEdit_20);
                logger.error("EntryImport >> data >> ", (Throwable)e);
            }
        }
        if (!"".equals(errorInfo.toString())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\u3002\u8bf7\u70b9\u51fb\u201c\u5c55\u793a\u8be6\u60c5\u201d\u67e5\u770b\u3002", (String)"AgentPayBillEdit_21", (String)"fi-cas-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.calculateAmount();
    }

    private void showBalance(DynamicObject acctbank) {
        LocaleString content;
        boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur");
        DynamicObject currency = this.getDynamicObject("currency");
        if (isDiffCur) {
            currency = this.getDynamicObject("dpcurrency");
        }
        if (acctbank == null) {
            acctbank = this.getDynamicObject("payeracctbank");
        }
        DynamicObject acctCash = this.getDynamicObject("accountcash");
        DynamicObject org = this.getDynamicObject("org");
        BigDecimal balance = BigDecimal.ZERO;
        AmountEdit control = (AmountEdit)this.getControl("balance");
        if (acctCash != null) {
            control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d", (String)"AgentPayBillEdit_8", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            content = new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e3a\u73b0\u91d1\u8d26\u6237\u65f6\uff0c\u8d26\u9762\u4f59\u989d\u5373\u4e3a\u5f53\u524d\u65f6\u70b9\u73b0\u91d1\u65e5\u8bb0\u8d26\u8d26\u9762\u4f59\u989d\u3002", (String)"AgentPayBillEdit_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            control.addTips(new Tips("text", null, content, false, null));
        } else {
            control.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d", (String)"AgentPayBillEdit_7", (String)"fi-cas-formplugin", (Object[])new Object[0])));
            content = new LocaleString(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u5f53\u524d\u65f6\u70b9\u4f59\u989d\u3002\u4ed8\u6b3e\u8d26\u6237\u5373\u65f6\u4f59\u989d\u53d6\u503c\u6765\u6e90\u6709\u94f6\u4f01\u4e92\u8054\u4f59\u989d\u8868\u3001\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u65e5\u8bb0\u8d26\uff1b\u7cfb\u7edf\u652f\u6301\u56db\u79cd\u53d6\u503c\u6a21\u5f0f\uff1a\uff081\uff09\u5b8c\u5168\u53d6\u81ea\u4f59\u989d\u8868\uff1b\uff082\uff09\u5b8c\u5168\u53d6\u81ea\u65e5\u8bb0\u8d26\uff1b\uff083\uff09\u4f18\u5148\u53d6\u4f59\u989d\u8868\uff0c\u518d\u53d6\u65e5\u8bb0\u8d26\uff1b\uff084\uff09\u5f00\u901a\u94f6\u4f01\u53d6\u4f59\u989d\u8868\uff0c\u672a\u5f00\u901a\u94f6\u4f01\u53d6\u65e5\u8bb0\u8d26\u3002\u5177\u4f53\u91c7\u53d6\u4f55\u79cd\u6a21\u5f0f\u8bf7\u524d\u5f80\u3010\u7cfb\u7edf\u670d\u52a1\u4e91\u3011-\u3010\u914d\u7f6e\u5de5\u5177\u3011-\u3010\u7cfb\u7edf\u53c2\u6570\u3011-\u3010\u8d44\u91d1\u4e91\u3011-\u3010\u8d44\u91d1\u516c\u5171\u670d\u52a1\u3011\u4e2d\u67e5\u770b\u3002", (String)"AgentPayBillEdit_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            control.addTips(new Tips("text", null, content, false, null));
        }
        if (org != null && (acctbank != null || acctCash != null) && currency != null) {
            try {
                if (acctbank != null && acctCash == null) {
                    String balanceType = SystemParameterFcsHelper.getParameterString((long)org.getLong("id"), (String)"balancevalue");
                    Object result = DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"balanceModelService", (String)"getRunningBalance", (Object[])new Object[]{balanceType, acctbank.getLong("id"), currency.getLong("id")});
                    BizBalanceModelBean bizBalanceModelBean = (BizBalanceModelBean)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)result), BizBalanceModelBean.class);
                    balance = bizBalanceModelBean.getAmount();
                } else {
                    balance = AcctBalanceHelper.getAccountCashCurrBalance((Long)org.getLong("id"), (Long)acctCash.getLong("id"), (Long)currency.getLong("id"), (Date)new Date());
                }
            }
            catch (Exception e) {
                logger.error("showBalance error", (Throwable)e);
                this.getModel().setValue("balance", (Object)BigDecimal.ZERO);
            }
        }
        this.getModel().setValue("balance", (Object)balance);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object value;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("save".equals(operateKey)) {
            this.doBeforeSave();
            this.removeSpaces();
        } else if ("invalid".equals(operateKey)) {
            boolean result = op.getOption().tryGetVariableValue(KEY_CANCELLATION, new RefObject());
            if (!result) {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection lstCollection = list.getSelectedRows();
                args.cancel = true;
                if (lstCollection.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u4ec5\u652f\u6301\u5bf9\u5355\u5f20\u5355\u636e\u5904\u7406\uff0c\u8bf7\u4fee\u6539\u9009\u62e9\u8303\u56f4\u3002", (String)"AgentPayBillEdit_10", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4f5c\u5e9f\u9009\u4e2d\u8bb0\u5f55\u540e\uff0c\u5c06\u65e0\u6cd5\u6062\u590d\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AgentPayBillEdit_11", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(KEY_CANCELLATION, (IFormPlugin)this));
            }
        } else if ("submit".equals(operateKey)) {
            args.cancel = args.cancel ? true : !this.confirmSubmitInfo();
            this.doBeforeSave();
            this.removeSpaces();
        } else if ("deleteentry".equals(operateKey) && (value = this.getModel().getValue("e_bankcheckflag")) != null && StringUtils.isNotEmpty((String)value.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u5f55\u5df2\u5339\u914d\u4ea4\u6613\u660e\u7ec6\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"AgentPayBillEdit_24", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("entryimport".equals(operateKey)) {
            this.getPageCache().put("cas_entryimportCache", "true");
            FormShowParameter showForm = new FormShowParameter();
            Object payeetype = this.getModel().getValue("payeetype");
            showForm.setFormId("cas_entryimport");
            showForm.getOpenStyle().setShowType(ShowType.Modal);
            String billFormId = this.getModel().getDataEntityType().getName();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("payeetype", payeetype);
            params.put("BillFormId", billFormId);
            params.put("BillEntryId", "entry");
            showForm.setCustomParams(params);
            showForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cas_entryimport"));
            this.getView().showForm(showForm);
        }
        if ("beforesubmit".equals(operateKey) || "submit".equals(operateKey)) {
            if (((Boolean)this.getModel().getValue("isencryption")).booleanValue()) {
                int i = 0;
                while (i < this.getModel().getEntryRowCount("entry")) {
                    if (CasHelper.isEmpty((Object)AgentPayBillHelper.decodeAmount((String)((String)this.getModel().getValue("e_encryptamount", i))))) {
                        this.getModel().deleteEntryRow("entry", i);
                        continue;
                    }
                    ++i;
                }
            } else {
                FormUtils.deleteEmptyRows((IDataModel)this.getModel(), (String[])new String[]{"e_amount"});
            }
        }
    }

    private void setDefaultValueByCash() {
        if (this.getDynamicObject("delegorg") != null) {
            return;
        }
        DynamicObject settleType = this.getDynamicObject("settletype");
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (isCash) {
            this.setValue("payeracctbank", null);
            DynamicObject accountCash = this.getDynamicObject("accountcash");
            if (accountCash == null) {
                this.setValue("accountcash", AccountCashHelper.getDefaultAccountcash((Long)this.getPk("org"), (String)"payer"));
            }
            this.setValue("isdiffcur", "0");
            this.getView().setVisible(Boolean.FALSE, new String[]{"isdiffcur"});
        } else {
            this.setValue("accountcash", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"isdiffcur"});
            DynamicObject accountBank = this.getDynamicObject("payeracctbank");
            boolean isVirtual = BaseDataHelper.isSettleTypeVirtual((DynamicObject)settleType);
            if (accountBank == null && !isVirtual) {
                this.setValue("payeracctbank", AccountBankHelper.getDefaultPayAccount((Long)this.getPk("org")));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        OperationResult result = args.getOperationResult();
        if (result != null) {
            boolean isSuccess = result.isSuccess();
            if (isSuccess) {
                List pks;
                if ("beforesubmit".equals(key) && !EmptyUtil.isEmpty((Collection)(pks = result.getSuccessPkIds()))) {
                    this.getView().invokeOperation("submit");
                }
                if ("pay".equals(key) || "cancelpay".equals(key)) {
                    this.getView().invokeOperation("refresh");
                }
                if (Arrays.asList("save", "submit").contains(key)) {
                    this.getView().updateView("delegorg");
                }
                AgentPayBillPluginHelper.setMenuVisibility((AbstractFormPlugin)this, (IDataModel)this.getModel(), (IFormView)this.getView());
            } else if ("pay".equals(key) || "cancelpay".equals(key)) {
                this.getModel().setValue("billstatus", (Object)("pay".equals(key) ? BillStatusEnum.AUDIT.getValue() : BillStatusEnum.PAY.getValue()));
            }
        }
        if (this.getModel().getValue("delegorg") != null && Arrays.asList("save", "submit", "audit").contains(key)) {
            this.getModel().setValue("payeracctbank", null);
            this.getModel().setValue("accountcash", null);
            this.getModel().setValue("settletype", null);
        }
    }

    private void showReviceNo(Object[] billIds) {
        Set isAllSet = HandLinkBillHelper.showBotpRtansDetails((Object[])billIds, (String)"cas_agentpaybill");
        List receiptNos = HandLinkBillHelper.getReceiptNoByDetails((Object[])billIds, (String)"cas_agentpaybill");
        String bankcheckflag = HandLinkBillHelper.getBankCheckFlagNoDetail((Object[])billIds, (String)"cas_agentpaybill");
        if (CasHelper.isEmpty((Object)isAllSet) && CasHelper.isEmpty((Object)receiptNos)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5173\u8054\u7684\u7535\u5b50\u56de\u5355\u3002", (String)"PayBillViewReceiptOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setFormId("cas_multitag");
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = appId != null && "cas".equals(appId) ? "cbei" : "bei";
        para.getCustomParams().put("checkRightAppId", appId);
        para.setCustomParam("receiptID", (Object)bankcheckflag);
        para.setCustomParam("receiptNo", (Object)JSON.toJSONString((Object)receiptNos));
        para.setCustomParam("detailIds", (Object)JSON.toJSONString((Object)isAllSet));
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(para);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String opKey = evt.getOperationKey();
        if ("pay".equals(opKey)) {
            this.pay(evt);
        }
        if ("commitbe".equals(opKey)) {
            PluginSignHelper.signOperate((BeforeItemClickEvent)evt, (SignCallbackLisenter)this, (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (IFormView)this.getView(), (String)"cas_agentpaybill", (Boolean)false);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (CANCELPAY.equals(itemKey)) {
            this.cancelPay();
        } else if ("viewreceipt".equalsIgnoreCase(itemKey)) {
            Long billId = (Long)this.getModel().getDataEntity().getPkValue();
            if (billId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u7535\u5b50\u56de\u5355\u8bb0\u5f55\u3002", (String)"ViewReceiptService_0", (String)"fi-cas-business", (Object[])new Object[0]));
                return;
            }
            Object[] billIds = new Object[]{billId};
            this.showReviceNo(billIds);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("beforesubmit".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.setIgnoreEmptyBEInfo(true);
                this.setIgnoreEmptyRow(true);
                this.getView().invokeOperation("beforesubmit", this.getOperteOption("beforesubmit"));
                this.setIgnoreEmptyRow(false);
                this.setIgnoreEmptyBEInfo(false);
            }
        } else if ("payeetypechanged".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("entry");
                this.setValue("payamount", BigDecimal.ZERO);
                this.setValue("localamt", BigDecimal.ZERO);
                String payeeType = this.getPageCache().get("newpayeetype");
                this.payeeTypeChanged(payeeType);
            } else {
                String payeeType = this.getPageCache().get("oldpayeetype");
                this.setValue(PAYEETYPELIST, payeeType, 0, true);
            }
        } else if (StringUtils.equals((String)callBackId, (String)KEY_CANCELLATION) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(KEY_CANCELLATION, "yes");
            this.getView().invokeOperation("invalid", operateOption);
        } else if (callBackId.equals("CONFIRM_CANCELPAY_CALLBACK") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("cancelpay");
        }
    }

    private boolean confirmSubmitInfo() {
        Boolean isCrossPay;
        if (this.ignoreEmptyBEInfo() && this.ignoreEmptyRow()) {
            return true;
        }
        if (!this.ignoreEmptyBEInfo() && this.isBEPay() && !(isCrossPay = (Boolean)this.getValue("iscrosspay")).booleanValue()) {
            boolean emptyBeInfo = false;
            DynamicObject type = (DynamicObject)this.getValue("crosstrantype");
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
            for (DynamicObject one : entry) {
                String bankNum = one.getString("payeebanknumber");
                String province = one.getString("recprovince");
                String city = one.getString("reccity");
                String usage = one.getString("e_remark");
                if (!CasHelper.isEmpty((Object)bankNum) && !CasHelper.isEmpty((Object)province) && !CasHelper.isEmpty((Object)city) && !CasHelper.isEmpty((Object)usage) || null != type && "BOCHK05".equals(type.getString("number"))) continue;
                emptyBeInfo = true;
                break;
            }
            if (emptyBeInfo) {
                String confirmMessage = ResManager.loadKDString((String)"\u8f6c\u8d26\u9644\u8a00\u3001\u6536\u6b3e\u884c\u884c\u53f7\u6216\u8005\u6536\u6b3e\u7701\u5e02\u4e3a\u7a7a\u5c06\u4e0d\u80fd\u6b63\u5e38\u63d0\u4ea4\u94f6\u4f01\uff0c\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f", (String)"AgentPayBillEdit_12", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("beforesubmit", (IFormPlugin)this);
                this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBacks);
                return false;
            }
        }
        return true;
    }

    private void setIgnoreEmptyBEInfo(boolean ignore) {
        this.getPageCache().put("IgnoreEmptyBEInfo", String.valueOf(ignore));
    }

    private boolean ignoreEmptyBEInfo() {
        String value = this.getPageCache().get("IgnoreEmptyBEInfo");
        return value == null ? false : Boolean.parseBoolean(value);
    }

    private void doBeforeSave() {
        if (!AgentPayBillPluginHelper.isEncodeAmount((IDataModel)this.getModel(), (IFormView)this.getView())) {
            AgentPayBillPluginHelper.setEncodeAmount((IDataModel)this.getModel(), (Boolean)false);
        }
        this.setDefaultValueByCash();
        Boolean isHeadPush = (Boolean)this.getValue("isheadpush");
        if (isHeadPush.booleanValue()) {
            new BotpFixLinkHelper().fixRowLink(this.getModel().getDataEntity(), "entry", "sourcebilltype", String.valueOf(this.getValue("hsourcebillid")), this.getString("hsourceentry"), "sourceentryid");
        }
    }

    private boolean isPayeeCustomer() {
        return "bd_customer".equals(this.getPayeeType());
    }

    private boolean isPayeeSupplier() {
        return "bd_supplier".equals(this.getPayeeType());
    }

    private boolean isPayeeOrg() {
        return "bos_org".equals(this.getPayeeType());
    }

    private String getPayeeType() {
        return this.getString(PAYEETYPELIST);
    }

    private boolean isPaySalary() {
        DynamicObject billType = this.getDynamicObject("billtype");
        return billType.getLong("id") == 343121063871251456L;
    }

    private boolean isAddNew() {
        return this.getView().getFormShowParameter().getCustomParam("billtype") != null;
    }

    private boolean isLoadData() {
        return "true".equalsIgnoreCase(this.getPageCache().get("loaddata"));
    }

    private void setValue(String key, Object value, int rowIndex, boolean cancelProChanged) {
        this.cancelProChangedOnce = cancelProChanged;
        if (value instanceof DynamicObject) {
            value = ((DynamicObject)value).getPkValue();
        }
        this.getModel().setValue(key, value, rowIndex);
        this.cancelProChangedOnce = false;
    }

    @Override
    protected String recPayAccount() {
        return "payeracctbank";
    }

    private boolean isDelegAgent() {
        return this.getValue("delegorg") != null;
    }

    private boolean isDelegPush() {
        String sourceBillType = this.getString("sourcebilltype");
        return !CasHelper.isEmpty((Object)sourceBillType);
    }

    private void setBaseCurrency() {
        Long orgId = this.getPk("org");
        DynamicObject standardCurrency = null;
        try {
            standardCurrency = SystemStatusCtrolHelper.getStandardCurrency((long)orgId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValue("basecurrency", standardCurrency);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!BillStatusEnum.SAVE.getValue().equals(billStatus) || billShowParameter.getStatus() == OperationStatus.VIEW) {
                e.setCheckDataChange(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isCopy() {
        Object value = this.getView().getFormShowParameter().getCustomParam("iscopy");
        return value != null && "true".equals(value.toString());
    }

    private void cancelPay() {
        String billno = (String)this.getModel().getValue("billno");
        DynamicObject payObj = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (String)"id,billno,isvoucher,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (payObj != null) {
            String billstatus = payObj.getString("billstatus");
            if (!billstatus.equals("D")) {
                this.getView().invokeOperation("cancelpay");
                return;
            }
            Boolean isv = payObj.getBoolean("isvoucher");
            if (isv.booleanValue()) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"(%s)\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u662f\u5426\u7ee7\u7eed\u53d6\u6d88\u4ed8\u6b3e\uff1f", (String)"PaymentBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]), billno), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("CONFIRM_CANCELPAY_CALLBACK", (IFormPlugin)this));
            } else {
                this.getView().invokeOperation("cancelpay");
            }
        }
    }

    private void pay(BeforeItemClickEvent evt) {
        if ("bei".equals(this.getString("paymentchannel"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u652f\u4ed8\u6e20\u9053\u4e3a\u94f6\u4f01\u4e92\u8054\uff0c\u8bf7\u63d0\u4ea4\u94f6\u4f01\u8fdb\u884c\u4ed8\u6b3e\u3002", (String)"AgentPayBillList_17", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        if (!BillStatusEnum.AUDIT.getValue().equals(this.getString("billstatus"))) {
            throw new KDBizException(new AgentPayErrorCode().STATUS_CANNOT_PAY(), new Object[0]);
        }
        if (!SystemStatusCtrolHelper.isInitEnable((long)this.getDynamicObject("org").getLong("id"))) {
            throw new KDBizException(SystemStatusCtrolHelper.getNotInitMsg((String)CasHelper.getLocalValue((DynamicObject)this.getDynamicObject("org"), (String)"name")));
        }
        if (this.isDelegAgent()) {
            throw new KDBizException(new AgentPayErrorCode().DELEG_AGENTPAY(), new Object[0]);
        }
        long orgId = (Long)this.getDynamicObject("org").getPkValue();
        Set cs1046 = SystemParameterHelper.getParameterComboxs((long)orgId, (String)"cs1046");
        boolean isDiffPay = (Boolean)this.getValue("isdiffcur");
        if (isDiffPay && cs1046.contains(SysParamCs1046Enum.DIFF.getValue())) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("cas_agentpaybill_diffpay");
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_DIFFPAY_CALLBACK));
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setCustomParam("dpcurrency", this.getDynamicObject("dpcurrency").getPkValue());
            para.setCustomParam("payamount", (Object)this.getBigDecimal("payamount"));
            para.setCustomParam("payamt", (Object)this.getBigDecimal("dpamt"));
            para.setCustomParam("agreedrate", (Object)this.getBigDecimal("agreedrate"));
            para.setCustomParam("agreedquotation", (Object)this.getString("agreedquotation"));
            this.getView().showForm(para);
            evt.setCancel(true);
        }
    }

    private void setExchangerateEditable() {
        DynamicObject srcCurrency = this.getDynamicObject("currency");
        DynamicObject destCurrency = this.getDynamicObject("basecurrency");
        if (srcCurrency == null || destCurrency == null) {
            return;
        }
        if (srcCurrency.getLong("id") == destCurrency.getLong("id")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"exchangerate"});
        }
    }

    private void setRecInfo(String key, Object value) {
        Boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur");
        if (!isDiffCur.booleanValue()) {
            this.getModel().setValue(key, value);
        }
    }

    private void setDiffCurInfo() {
        Boolean isDiffCur = (Boolean)this.getModel().getValue("isdiffcur");
        if (isDiffCur.booleanValue()) {
            return;
        }
        this.setValueIfAbsent("dpcurrency", this.getModel().getValue("currency"));
        this.setValueIfAbsent("dpamt", this.getModel().getValue("payamount"));
        if (!FeePayerEnum.REC.getValue().equals(this.getString("feepayer"))) {
            this.setValueIfAbsent("feeactbank", this.getModel().getValue("payeracctbank"));
            this.setValueIfAbsent("feecurrency", (DynamicObject)this.getModel().getValue("currency"));
        }
    }

    private void setExratetableVisibility() {
        Long currencyId = this.getPk("currency");
        Long dpCurrencyId = this.getPk("dpcurrency");
        Long basecurrencyId = this.getPk("basecurrency");
        if (currencyId != null && !currencyId.equals(basecurrencyId) || dpCurrencyId != null && !dpCurrencyId.equals(basecurrencyId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"exratetable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"exratedate"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"exratetable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"exratedate"});
        }
    }

    private void setSettleTypeValue(DynamicObject payerAcctBank) {
        DynamicObjectCollection settlementypes;
        if (payerAcctBank != null && (settlementypes = payerAcctBank.getDynamicObjectCollection("settlementtype")) != null && settlementypes.size() > 0) {
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject settlementype : settlementypes) {
                idSet.add(((DynamicObject)settlementype.get("fbasedataid")).getLong("id"));
            }
            DynamicObject settleType = this.getDynamicObject("settletype");
            if (idSet.size() == 1) {
                this.setValue("settletype", idSet.iterator().next());
            } else if (settleType != null && !idSet.contains((Long)settleType.getPkValue())) {
                this.setValue("settletype", null);
            }
        }
    }

    private void setCrossPayValue() {
        long orgId;
        boolean autoOpenCrossPay;
        this.getView().setEnable(Boolean.TRUE, new String[]{"iscrosspay"});
        DynamicObject payerBank = this.getDynamicObject("payerbank");
        DynamicObject payCountry = payerBank != null ? payerBank.getDynamicObject("country") : null;
        DynamicObject org = this.getDynamicObject("org");
        if (org != null && (autoOpenCrossPay = SystemParameterHelper.getParameterBoolean((long)(orgId = ((Long)org.getPkValue()).longValue()), (String)"autoopencrosspay"))) {
            if (payCountry != null && !CountryHelper.isChina((DynamicObject)payCountry) || this.isRecCountryCross().booleanValue()) {
                this.setValue("iscrosspay", true);
            } else {
                this.setValue("iscrosspay", false);
            }
        }
    }

    private void isCrossPayVisibility() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"iscrosspay"});
    }

    private void isDiffCurVisibility() {
        DynamicObject settleType = this.getDynamicObject("settletype");
        if (CasHelper.isNotEmpty((Object)settleType) && BaseDataHelper.isSettleTypeCash((DynamicObject)settleType)) {
            this.setValue("isdiffcur", "0");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdiffcur"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isdiffcur"});
        }
    }

    private void setCountryValue() {
        DynamicObject payerBank = this.getDynamicObject("payerbank");
        if (payerBank != null) {
            this.setValue("paycountry", payerBank.getDynamicObject("country"));
        }
    }

    private void clearEntryField(String ... keys) {
        for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
            for (String key : keys) {
                this.setValue(key, null, i);
            }
        }
    }

    private void fillFundflowItem(boolean isCover, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
            if (isCover) {
                this.setValue("e_fundflowitem", defaultFundsItem.getPkValue(), i);
                continue;
            }
            this.setValueIfAbsent("e_fundflowitem", defaultFundsItem.getPkValue(), i);
        }
    }

    private void removeSpaces() {
        for (int i = 0; i < this.getModel().getEntryRowCount("entry"); ++i) {
            this.setValue("payeeacctbank", CheckUtils.bankNumberCheck((String)((String)this.getModel().getValue("payeeacctbank", i))), i);
            this.setValue("payeename", CheckUtils.removeSpaces((String)((String)this.getModel().getValue("payeename", i))), i);
            this.setValue("payeebankname", CheckUtils.removeSpaces((String)((String)this.getModel().getValue("payeebankname", i))), i);
        }
    }

    private void afterImport() {
        DynamicObject dyBilltype;
        DynamicObjectCollection coll;
        List value;
        Long billtypeId = 0L;
        if (this.isPaySalary()) {
            QFilter[] filters = new QFilter[]{new QFilter("biztype", "=", (Object)"997")};
            DynamicObject paymentType = BusinessDataServiceHelper.loadSingle((String)"cas_paymentbilltype", (String)"id,name,number,fundflowitem", (QFilter[])filters);
            this.setValue("paymenttype", paymentType);
            this.setValue(PAYEETYPELIST, "bos_user");
            billtypeId = 343121063871251456L;
        } else {
            billtypeId = 343122285806233600L;
        }
        this.setValueIfAbsent(PAYEETYPELIST, "other");
        this.payeeTypeChanged(null);
        this.setValue("source", "import");
        this.setPayeeTypeImport();
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject payee = this.getDynamicObject("payee", i);
            if (payee != null) {
                this.setValueIfAbsent("payeename", payee.getString("name"), i);
            }
            this.setDefaultPayeeBank(i);
        }
        if (CasHelper.isNotEmpty((Object)billtypeId) && (value = (coll = (dyBilltype = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"bos_billtype")).getDynamicObjectCollection("fieldcontrolentry")).stream().filter(field -> "isencryption".equals(field.get("fieldkey").toString())).map(dy -> dy.get("defaultvalue").toString()).collect(Collectors.toList())).size() == 1) {
            boolean isencryption = value.get(0) != null && "true".equals(value.get(0));
            this.setValue("isencryption", isencryption);
        }
        AgentPayBillPluginHelper.setEncodeAmount((IDataModel)this.getModel(), (Boolean)false);
        AgentFillPropHelper.fillProp((DynamicObject)this.getModel().getDataEntity());
    }

    private void smartMatchInfoHandel() {
        boolean matched;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String bankFlag = dataEntity.getString("bankcheckflag");
        DynamicObjectCollection entryInfo = dataEntity.getDynamicObjectCollection("entry");
        List matchedEntryInfo = entryInfo.stream().filter(item -> StringUtils.isNotEmpty((String)item.getString("e_bankcheckflag"))).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)bankFlag) && matchedEntryInfo.size() != 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"m_addrow", "m_deleterow", "m_entryimport"});
        }
        if (matched = AgentPayBillHelper.isMatched((DynamicObject)dataEntity)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"matchhitinfo"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo", "agentinfo", "actpayinfo", "agententry", "attachmentpanel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matchhitinfo"});
        }
        for (int i = 0; i < entryInfo.size(); ++i) {
            DynamicObject currEntry = (DynamicObject)entryInfo.get(i);
            if (!StringUtils.isNotEmpty((String)currEntry.getString("e_bankcheckflag"))) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"payee", "payeename", "payeeacctbank", "encryptpayeeacctbank", "payeebankname", "e_amount", "payeebanknumber", "e_fundflowitem", "e_remark", "recprovince", "reccity"});
        }
    }

    public void signCallback(SignCallbackEvent evt) {
        PluginSignHelper.signCallBack((SignCallbackEvent)evt, (IFormView)this.getView(), (Boolean)false);
    }

    private void setDefaultAddress(Object payee, int entryIndex) {
        if (EmptyUtil.isNoEmpty((Object)payee)) {
            DynamicObject payeeObj = (DynamicObject)payee;
            long payeeId = payeeObj.getLong("id");
            if (EmptyUtil.isEmpty((Long)payeeId)) {
                return;
            }
            String payeeType = (String)this.getValue(PAYEETYPELIST);
            String address = AsstActTypeAddressEnum.getAddressByAsstActType((String)payeeType, (Long)payeeId);
            this.setValue("recaddress", address, entryIndex, true);
        }
    }

    private void clearDefaultAddress() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        for (DynamicObject row : entryEntity) {
            row.set("recaddress", null);
        }
        this.getView().updateView("entry");
    }

    private void setEntrustBtnShow(boolean isDelegAgent) {
        String appId = this.getView().getFormShowParameter().getAppId();
        boolean permission = isDelegAgent && PermissionHelper.hasEntrustPayPermission((String)appId, (String)"cas_agentpaybill");
        this.getView().setVisible(Boolean.valueOf(permission), new String[]{"gendelegagent", "cancelentrustpay"});
    }

    private void setDefaultPayeeBank(int i) {
        QFilter filter;
        DynamicObject bebankNew;
        DynamicObject entryObj = this.getModel().getEntryRowEntity("entry", i);
        DynamicObject bebank = entryObj.getDynamicObject("payeebank");
        String payeeBankName = entryObj.getString("payeebankname");
        if (EmptyUtil.isEmpty((DynamicObject)bebank) && EmptyUtil.isNoEmpty((String)payeeBankName) && (bebankNew = BusinessDataServiceHelper.loadSingle((String)"bd_bebank", (String)"id,name,number,union_number,country,provincetxt,citytxt", (QFilter[])new QFilter[]{filter = new QFilter("name", "=", (Object)payeeBankName).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")})) != null) {
            this.getModel().setValue("payeebank", (Object)bebankNew, i);
        }
    }
}

