/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class BankStatementPrintDefPlugin
extends AbstractPrintServicePlugin {
    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        super.customPrintDataEntities(e);
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>();
        String dataSourceName = e.getDataSourceName();
        Object billId = e.getPKId();
        Set customFields = e.getCustomFields();
        if (dataSourceName.equals("cas_bankstatement")) {
            DynamicObject bankstatement = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"cas_bankstatement");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement");
            DynamicObjectType cloneType = null;
            try {
                cloneType = (DynamicObjectType)dataEntityType.clone();
                for (String customField : customFields) {
                    DynamicSimpleProperty demoProp = new DynamicSimpleProperty(customField, String.class, (Object)"");
                    cloneType.registerSimpleProperty(demoProp);
                }
                DynamicObject item = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)cloneType, (Object)bankstatement);
                item.set("org", bankstatement.get("org"));
                item.set("accountbank", bankstatement.get("accountbank"));
                item.set("currency", bankstatement.get("currency"));
                if (bankstatement.getBigDecimal("debitamount").compareTo(BigDecimal.ZERO) == 0) {
                    item.set("debit", (Object)0);
                    item.set("credit", (Object)1);
                } else {
                    item.set("debit", (Object)1);
                    item.set("credit", (Object)0);
                }
                newDataEntities.add(item);
            }
            catch (CloneNotSupportedException e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u514b\u9686\u5c5e\u6027\u51fa\u9519\u3002%s", (String)"BankStatementPrintDefPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), e1.getMessage()));
            }
        }
        e.setDataEntities(newDataEntities);
    }
}

