/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.business.journal.SourceNumber;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.formplugin.common.CasCommonFilterListPlugin;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.EmptyUtil;

public class CashJournalListPlugin
extends CasCommonFilterListPlugin {
    private Map<DynamicObject, SourceNumber> voucherNoCache = new HashMap<DynamicObject, SourceNumber>();

    public void initialize() {
        super.initialize();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String isshowtoolbarap = (String)formShowParameter.getCustomParam("isshowtoolbarap");
        if (null != isshowtoolbarap && isshowtoolbarap.equals("no")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("batchaddnew".equals(key.toLowerCase(Locale.ENGLISH))) {
            this.openAddNew();
        }
    }

    private void openAddNew() {
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        Set orgList = OrgHelper.getAuthBankOrgIds((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cas_cashjournal", (String)"47150e89000000ac");
        if (orgList.size() > 0) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cas_cashjournaledit");
            showParameter.setCustomParam("org.id", (Object)this.getPageCache().get("org.id"));
            showParameter.setCustomParam("currency.id", (Object)this.getPageCache().get("currency.id"));
            showParameter.setCustomParam("accountcash.id", (Object)this.getPageCache().get("accountcash.id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "listoperation");
            callBack.setControlKey("billlistap");
            showParameter.setCloseCallBack(callBack);
            this.getView().showForm(showParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u7684\u65b0\u589e\u6743\u9650\u3002", (String)"CashJournalListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        Long billId = (Long)billShowParameter.getPkId();
        boolean isCanModify = this.isCanModify(billId);
        if (!isCanModify) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        } else {
            billShowParameter.setStatus(OperationStatus.EDIT);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customParam = formShowParameter.getCustomParam("delete");
        if (customParam == null) {
            List columns = args.getListColumns();
            IListColumn removeColumn = null;
            for (IListColumn column : columns) {
                String fieldName = column.getListFieldKey();
                if (!"batchno".equals(fieldName)) continue;
                removeColumn = column;
            }
            if (removeColumn != null) {
                columns.remove(removeColumn);
                args.setListColumns(columns);
            }
        }
    }

    private boolean isCanModify(Long billId) {
        Date periodBeginDate;
        ORM orm = ORM.create();
        DynamicObject journal = orm.queryOne("cas_cashjournal", "id,source,bookdate,org.id", new QFilter[]{new QFilter("id", "=", (Object)billId)});
        DynamicObject currentPeriod = SystemStatusCtrolHelper.getCurrentPeriod((long)journal.getDynamicObject("org").getLong("id"));
        if ((currentPeriod = PeriodHelper.getPeriodById((long)currentPeriod.getLong("id"))).getBoolean("isadjustperiod")) {
            return false;
        }
        if (journal.getInt("source") != 1) {
            return false;
        }
        Date bookDate = journal.getDate("bookdate");
        return !bookDate.before(periodBeginDate = currentPeriod.getDate("begindate"));
    }

    @Override
    protected String getAcctEntity() {
        return "cas_accountcash";
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject journal = e.getRowData();
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        String columnName = column.getFieldKey();
        if (this.voucherNoCache.size() > 0 && this.voucherNoCache.get(journal) != null) {
            SourceNumber sourceNumber = this.voucherNoCache.get(journal);
            if ("voucherno".equalsIgnoreCase(columnName)) {
                e.setFormatValue((Object)sourceNumber.getVoucherNo());
            } else if ("sourcebillnumber".equalsIgnoreCase(columnName)) {
                e.setFormatValue((Object)sourceNumber.getBillno());
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicProperty property = data.getDynamicObjectType().getProperty("sourcebilltype");
                if (property != null) {
                    CashJournalListPlugin.this.voucherNoCache = new VoucherBookService().getSourceNumbers((Collection)data, "cas_bankjournal");
                }
                return data;
            }
        });
    }
}

