/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.helper.AccSysHelper;
import kd.fi.cas.helper.CasHelper;

public class CashMgtInitSet
extends AbstractFormPlugin {
    private static Log Logger = LogFactory.getLog(CashMgtInitSet.class);
    private String selectFields = "basecurrency.id baseCurrencyID,exratetable.id exratetable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("startperiod");
        periodF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject type = (DynamicObject)this.getModel().getValue("periodtype");
            QFilter qFilter = null;
            qFilter = type != null && type.getLong("id") > 0L ? new QFilter("periodtype", "=", (Object)type.getLong("id")) : new QFilter("periodtype", "=", null);
            qFilter = qFilter.and(new QFilter("isadjustperiod", "=", (Object)false));
            showParameter.setIsolationOrg(false);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
        this.addClickListeners(new String[]{"syndata"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List orgPks = (List)customParams.get("org");
        if (orgPks == null) {
            return;
        }
        this.getModel().setValue("org", (Object)orgPks.toArray());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        Map baseAccountingInfo = this.getBookInfoByAccSys(Long.parseLong(orgPks.get(0).toString()));
        if (baseAccountingInfo.size() < 1) {
            Logger.info(String.format(ResManager.loadKDString((String)"\u4ece\u57fa\u7840\u6570\u636e\u53d6\uff1a%s", (String)"CashMgtInitSet_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(baseAccountingInfo)));
            baseAccountingInfo = AccSysHelper.getBaseAccountingInfo((Long)Long.valueOf(orgPks.get(0).toString()));
        }
        Logger.info(String.format(ResManager.loadKDString((String)"\u4ece\u4f1a\u8ba1\u8d26\u7c3f\u53d6\uff1a%s", (String)"CashMgtInitSet_7", (String)"fi-cas-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(baseAccountingInfo)));
        if (customParams.get("standardcurrency") != null && Long.parseLong(customParams.get("standardcurrency").toString()) > 0L) {
            this.getModel().setValue("standardcurrency", (Object)Long.valueOf(customParams.get("standardcurrency").toString()));
        } else if (null != baseAccountingInfo && baseAccountingInfo.size() > 0) {
            this.getModel().setValue("standardcurrency", baseAccountingInfo.get("baseCurrencyID"));
        }
        if (customParams.get("periodtype") != null && Long.parseLong(customParams.get("periodtype").toString()) > 0L) {
            this.getModel().setValue("periodtype", (Object)Long.valueOf(customParams.get("periodtype").toString()));
        }
        if (customParams.get("startperiod") != null && Long.parseLong(customParams.get("startperiod").toString()) > 0L) {
            this.getModel().setValue("startperiod", (Object)Long.valueOf(customParams.get("startperiod").toString()));
        }
        if (customParams.get("exratetable") != null && Long.parseLong(customParams.get("exratetable").toString()) > 0L) {
            this.getModel().setValue("exratetable", (Object)Long.valueOf(customParams.get("exratetable").toString()));
        } else if (null != baseAccountingInfo && baseAccountingInfo.size() > 0) {
            this.getModel().setValue("exratetable", baseAccountingInfo.get("exchangeRateTableID"));
        }
        if (customParams.get("id") != null && Long.parseLong(customParams.get("id").toString()) > 0L) {
            this.getModel().setValue("id", (Object)Long.valueOf(customParams.get("id").toString()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if ("periodtype".equals(name)) {
            this.getModel().setValue("startperiod", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op = (AbstractOperate)e.getSource();
        if ("saveinitset".equals(op.getOperateKey())) {
            if (this.getModel().getValue("standardcurrency") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashMgtInitSet_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            } else if (this.getModel().getValue("exratetable") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashMgtInitSet_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            } else if (this.getModel().getValue("periodtype") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashMgtInitSet_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            } else if (this.getModel().getValue("startperiod") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u7528\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CashMgtInitSet_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.cancel = true;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("saveinitset".equals(e.getOperateKey())) {
            if (e.getOperationResult().isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8bbe\u7f6e\u6210\u529f\u3002", (String)"CashMgtInitSet_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                if (this.getModel().getDataEntity().getBoolean("isOpenInitForm")) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    IDataModel model = this.getModel();
                    resultMap.put("org", model.getValue("org"));
                    resultMap.put("isopeninitform", model.getValue("isopeninitform"));
                    this.getView().returnDataToParent(resultMap);
                    this.getView().close();
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8bbe\u7f6e\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u6570\u636e\u3002", (String)"CashMgtInitSet_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "syndata": {
                this.setCurrencyAndExRate();
            }
        }
    }

    private void setCurrencyAndExRate() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List orgPks = (List)customParams.get("org");
        Map baseAccountingInfo = this.getBookInfoByAccSys(Long.parseLong(orgPks.get(0).toString()));
        if (baseAccountingInfo.size() < 1) {
            Logger.info(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u4ece\u57fa\u7840\u6570\u636e\u53d6\uff1a%s", (String)"CashMgtInitSet_6_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(baseAccountingInfo)));
            baseAccountingInfo = AccSysHelper.getBaseAccountingInfo((Long)Long.valueOf(orgPks.get(0).toString()));
        }
        Logger.info(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u4ece\u4f1a\u8ba1\u8d26\u7c3f\u53d6\uff1a%s", (String)"CashMgtInitSet_7_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(baseAccountingInfo)));
        boolean isNull = true;
        if (null != baseAccountingInfo && baseAccountingInfo.size() > 0) {
            this.getModel().setValue("standardcurrency", baseAccountingInfo.get("baseCurrencyID"));
            isNull = false;
        }
        if (null != baseAccountingInfo && baseAccountingInfo.size() > 0) {
            this.getModel().setValue("exratetable", baseAccountingInfo.get("exchangeRateTableID"));
            isNull = false;
        }
        if (isNull) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u3001\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u672a\u8bbe\u7f6e\u4e1a\u52a1\u4e3b\u5e01\u79cd\u548c\u6c47\u7387\u8868\uff0c\u65e0\u6cd5\u81ea\u52a8\u540c\u6b65\uff0c\u8bf7\u624b\u5de5\u586b\u5199\u3002", (String)"CashMgtInitSet_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    public Map<String, Long> getBookInfoByAccSys(long accorg) {
        QFilter h = new QFilter("org.id", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)this.selectFields, (QFilter[])new QFilter[]{k, h});
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (!CasHelper.isEmpty((Object)accountBooksInfo)) {
            map.put("baseCurrencyID", accountBooksInfo.getLong("baseCurrencyID"));
            map.put("exchangeRateTableID", accountBooksInfo.getLong("exratetable"));
        }
        return map;
    }
}

