/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.formplugin.UnreachBaseListDataRpt;
import kd.fi.cas.formplugin.UnreachParam;
import kd.fi.cas.formplugin.helper.UnReachHelper;

public class CompanyUnreachListDataRpt
extends UnreachBaseListDataRpt {
    public CompanyUnreachListDataRpt() {
        this.sourceEntity = "cas_bankstatement";
    }

    @Override
    protected List<Field> getRowMetaField() {
        List<Field> fields = super.getRowMetaField();
        fields.add(new Field("ratesdate", (DataType)DataType.TimestampType));
        fields.add(new Field("bankvouvherno", (DataType)DataType.StringType));
        fields.add(new Field("tradenumber", (DataType)DataType.StringType));
        fields.add(new Field("source", (DataType)DataType.StringType));
        fields.add(new Field("isCheck", (DataType)DataType.StringType));
        fields.add(new Field("balanceamt", (DataType)DataType.BigDecimalType));
        fields.add(new Field("bankcheckflag", (DataType)DataType.StringType));
        fields.add(new Field("isbank", (DataType)DataType.BooleanType));
        fields.add(new Field("bankdetailno", (DataType)DataType.StringType));
        fields.add(new Field("oppunit", (DataType)DataType.StringType));
        fields.add(new Field("oppbank", (DataType)DataType.StringType));
        fields.add(new Field("oppaccountnumber", (DataType)DataType.StringType));
        return fields;
    }

    @Override
    protected String getQueryFiled(UnreachParam param) {
        String queryFiled = super.getQueryFiled(param);
        return queryFiled + ",ratesdate,bankvouvherno,tradenumber,source,isCheck,balanceamt,bankcheckflag,isvalid,bankdetailno,oppunit,oppbank,oppaccountnumber";
    }

    @Override
    protected DataSet addField(DataSet sumset) {
        return sumset.addNullField("ratesdate").addNullField("bankvouvherno").addNullField("tradenumber").addNullField("source").addNullField("isCheck").addNullField("balanceamt").addNullField("bankcheckflag").addNullField("isvalid").addNullField("bankdetailno").addNullField("oppunit").addNullField("oppbank").addNullField("oppaccountnumber");
    }

    @Override
    protected QFilter getQueryQFilter(UnreachParam param) {
        List<Long> orgIdList = UnReachHelper.getOrgIds(param.getOrgs(), param.getEndDate());
        if (orgIdList.isEmpty()) {
            return new QFilter("isbank", "=", (Object)"1");
        }
        if (orgIdList.size() == 1) {
            return new QFilter("org", "=", (Object)orgIdList.get(0)).and(new QFilter("isbank", "=", (Object)"1"));
        }
        return new QFilter("org", "in", orgIdList).and(new QFilter("isbank", "=", (Object)"1"));
    }
}

