/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.url.UrlService;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SettingMapperHelper;

public class FinorgImgConfigPlugin
extends DynamicFormPlugin {
    private boolean confirmDelete = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"selectpic", "saveall", "picurl", "bkimg"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData("entry");
        DynamicObject[] settings = SettingMapperHelper.queryAll((String)"finorgimg");
        String rootUrl = UrlService.getDomainContextUrl();
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        for (DynamicObject setting : settings) {
            int rowIndex = this.getModel().createNewEntryRow("entry");
            this.setValue("banktype", setting.getLong("key"), rowIndex);
            this.setValue("bkimg", rootUrl + setting.getString("value"), rowIndex);
            this.setValue("picurl", setting.getString("value"), rowIndex);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "selectpic": {
                this.showPicSelectForm();
                break;
            }
            case "saveall": {
                this.save();
                break;
            }
            case "picurl": {
                this.showPicSelectForm();
                break;
            }
            case "bkimg": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                Object url = this.getModel().getValue("bkimg", rowIndex);
                this.setValue("bkimg2", url);
            }
        }
    }

    private void save() {
        int[] selectRows;
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        for (int rowIndex : selectRows = entry.getSelectRows()) {
            Long bankTypePk = this.getPk("banktype", rowIndex);
            String url = (String)this.getModel().getValue("bkimg", rowIndex);
            if (bankTypePk == null || CasHelper.isEmpty((Object)url)) continue;
            SettingMapperHelper.saveOrUpdate((String)"finorgimg", (String)bankTypePk.toString(), (String)url);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"FinorgImgConfigPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (!this.confirmDelete) {
            e.setCancel(true);
            this.beforeDelete();
        }
    }

    private void beforeDelete() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("acctbankcardentry");
        Long bankTypePk = this.getPk("banktype", rowIndex);
        if (bankTypePk == null) {
            this.getModel().deleteEntryRow("entry", rowIndex);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FinorgImgConfigPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5f53\u524d\u5206\u5f55\uff1f", (String)"FinorgImgConfigPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    private void confirmDelete() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        Long bankTypePk = this.getPk("banktype", rowIndex);
        SettingMapperHelper.delete((String)"finorgimg", (String)bankTypePk.toString());
        this.confirmDelete = true;
        this.getModel().deleteEntryRow("entry", rowIndex);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"FinorgImgConfigPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && "delete".equals(callBackId)) {
            this.confirmDelete();
        }
    }

    private void showPicSelectForm() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("ide_pictureselector");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ide_pictureselector"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("ide_pictureselector".equals(actionId) && (returnData = (Map)closedCallBackEvent.getReturnData()) != null) {
            Object url = returnData.get("value");
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            this.setValue("bkimg", rootUrl + url, rowIndex);
            this.setValue("picurl", url, rowIndex);
        }
    }
}

