/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class FreeChoiceEdit
extends DynamicFormPlugin
implements TabSelectListener {
    private static String[] temp = new String[]{"normal", "freeze", "closing", "changing"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showBankInfo();
        this.showEntryBank();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private void showEntryBank() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Boolean isCustomer = (Boolean)fsp.getCustomParam("isCustomer");
        String type = (String)fsp.getCustomParam("type");
        Object payeeId = fsp.getCustomParam("payee");
        String entityName = "";
        String selectProperties = "";
        if (isCustomer.booleanValue()) {
            selectProperties = "id,entry_bank.id,entry_bank.bank,entry_bank.bankaccount,entry_bank.accountname,entry_bank.currency,entry_bank.isdefault_bank";
            entityName = "customerentrybank";
            this.getView().setVisible(Boolean.FALSE, new String[]{"supplierentrybank"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customerentrybank"});
        } else {
            entityName = "supplierentrybank";
            selectProperties = "id,entry_bank.id,entry_bank.bank,entry_bank.bankaccount,entry_bank.accountname,entry_bank.currency,entry_bank.isdefault_bank,entry_bank.agentbankaccount,entry_bank.agentbank";
            this.getView().setVisible(Boolean.FALSE, new String[]{"customerentrybank"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"supplierentrybank"});
        }
        DynamicObject payee = BusinessDataServiceHelper.loadSingle((Object)payeeId, (String)type, (String)selectProperties);
        DynamicObjectCollection entryBank = payee.getDynamicObjectCollection("entry_bank");
        if (entryBank != null && entryBank.size() > 0) {
            this.getModel().getEntryEntity(entityName).clear();
            for (DynamicObject entry : entryBank) {
                DynamicObject currency;
                DynamicObject bank;
                int newEntryRow = this.getModel().createNewEntryRow(entityName);
                if (isCustomer.booleanValue()) {
                    this.getModel().setValue("entryid", entry.getPkValue(), newEntryRow);
                    bank = entry.getDynamicObject("bank");
                    this.getModel().setValue("bank", bank == null ? Integer.valueOf(0) : bank.getPkValue(), newEntryRow);
                    this.getModel().setValue("bankaccount", (Object)entry.getString("bankaccount"), newEntryRow);
                    this.getModel().setValue("accountname", (Object)entry.getString("accountname"), newEntryRow);
                    currency = entry.getDynamicObject("currency");
                    this.getModel().setValue("currency", currency == null ? Integer.valueOf(0) : currency.getPkValue(), newEntryRow);
                    this.getModel().setValue("isdefault_bank", entry.get("isdefault_bank"), newEntryRow);
                    continue;
                }
                this.getModel().setValue("sentryid", entry.getPkValue(), newEntryRow);
                bank = entry.getDynamicObject("bank");
                this.getModel().setValue("sbank", bank == null ? Integer.valueOf(0) : bank.getPkValue(), newEntryRow);
                this.getModel().setValue("sbankaccount", (Object)entry.getString("bankaccount"), newEntryRow);
                this.getModel().setValue("saccountname", (Object)entry.getString("accountname"), newEntryRow);
                currency = entry.getDynamicObject("currency");
                this.getModel().setValue("scurrency", currency == null ? Integer.valueOf(0) : currency.getPkValue(), newEntryRow);
                this.getModel().setValue("sisdefault_bank", entry.get("isdefault_bank"), newEntryRow);
                this.getModel().setValue("agentbankaccount", entry.get("agentbankaccount"), newEntryRow);
                DynamicObject agentBank = entry.getDynamicObject("agentbank");
                this.getModel().setValue("agentbank", agentBank == null ? Integer.valueOf(0) : agentBank.getPkValue(), newEntryRow);
            }
            this.getModel().setEntryCurrentRowIndex(entityName, 0);
            this.getView().updateView(entityName);
        }
    }

    private void showBankInfo() {
        Object currencyId;
        DynamicObject currency;
        Object billTypeId;
        DynamicObject billType;
        String sourceBill;
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object internalOrgId = fsp.getCustomParam("internalOrg");
        DynamicObject internalOrg = BusinessDataServiceHelper.loadSingle((Object)internalOrgId, (String)"bos_org", (String)"id");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        QFilter qFilter = new QFilter("acctstatus", "in", (Object)temp);
        filters.add(qFilter);
        if (internalOrg != null) {
            long orgID = internalOrg.getPkValue() == null ? 0L : Long.parseLong(internalOrg.getPkValue().toString());
            HashSet<Long> orgIds = new HashSet<Long>(1);
            orgIds.add(orgID);
            List accountIdList = AccountBankHelper.getUseableAccountPks(orgIds);
            QFilter accountAuthAssignFilter = new QFilter("id", "in", (Object)accountIdList);
            filters.add(accountAuthAssignFilter);
        }
        if ("pay".equalsIgnoreCase(sourceBill = (String)fsp.getCustomParam("sourcebill")) && (billType = BusinessDataServiceHelper.loadSingle((Object)(billTypeId = fsp.getCustomParam("billtype")), (String)"bos_billtype", (String)"id")) != null && (BillTypeConstants.PAYBILL_SYN.equals(billType.getPkValue()) || BillTypeConstants.PAYBILL_CASH.equals(billType.getPkValue()) || BillTypeConstants.PAYBILL_DCEP.equals(billType.getPkValue())) && (currency = BusinessDataServiceHelper.loadSingle((Object)(currencyId = fsp.getCustomParam("currency")), (String)"bd_currency", (String)"id")) != null) {
            filters.add(new QFilter("currency.fbasedataid.id", "=", (Object)currency.getLong("id")));
        }
        this.setDcepFilter(filters);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getFilterParameter().getQFilters().addAll(filters);
    }

    private void setDcepFilter(List<QFilter> filters) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String sourceBill = (String)fsp.getCustomParam("sourcebill");
        if ("pay".equalsIgnoreCase(sourceBill)) {
            this.getPaymentFilter(fsp, filters);
        } else if ("rec".equalsIgnoreCase(sourceBill)) {
            DynamicObject settleType;
            boolean isDcep;
            String filterIsElec = "0";
            String businessType = (String)fsp.getCustomParam("businesstype");
            Object settleTypeId = fsp.getCustomParam("settletype");
            if (EmptyUtil.isNoEmpty((String)businessType) && EmptyUtil.isNoEmpty((Object)settleTypeId) && (isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)(settleType = BusinessDataServiceHelper.loadSingle((Object)settleTypeId, (String)"bd_settlementtype", (String)"settlementtype")))) && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
                filterIsElec = "1";
            }
            filters.add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
        }
    }

    private void getPaymentFilter(FormShowParameter fsp, List<QFilter> filters) {
        DynamicObject payAccBank;
        String filterIsElec = "0";
        String businessType = (String)fsp.getCustomParam("businesstype");
        Object settleTypeId = fsp.getCustomParam("settletype");
        if (EmptyUtil.isEmpty((String)businessType)) {
            return;
        }
        if (EmptyUtil.isEmpty((Object)settleTypeId)) {
            return;
        }
        DynamicObject settleType = BusinessDataServiceHelper.loadSingle((Object)settleTypeId, (String)"bd_settlementtype", (String)"settlementtype");
        if (EmptyUtil.isEmpty((DynamicObject)settleType)) {
            return;
        }
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (!isDcep) {
            return;
        }
        Object payerAcctBankId = fsp.getCustomParam("payeracctbank");
        if (EmptyUtil.isNoEmpty((Object)payerAcctBankId) && EmptyUtil.isNoEmpty((DynamicObject)(payAccBank = BusinessDataServiceHelper.loadSingle((Object)payerAcctBankId, (String)"am_accountbank", (String)"relatedsettleacct")))) {
            if (PayBusinessTypeEnum.WALLETESSAY.getValue().equals(businessType)) {
                DynamicObjectCollection relatedsettleacct = payAccBank.getDynamicObjectCollection("relatedsettleacct");
                List accId = relatedsettleacct.stream().map(o -> o.get("fbasedataid_id")).collect(Collectors.toList());
                filters.add(new QFilter("id", "in", accId));
            } else if (PayBusinessTypeEnum.WALLETUP.getValue().equals(businessType)) {
                filters.add(new QFilter("relatedsettleacct.fbasedataid.id", "=", payAccBank.getPkValue()));
                filterIsElec = "1";
            }
        }
        if (PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)) {
            String payeeType = (String)fsp.getCustomParam("type");
            if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType) || AsstActTypeEnum.CUSTOMER.getValue().equals(payeeType)) {
                Object internalOrgId = fsp.getCustomParam("internalOrg");
                DynamicObject internalOrg = BusinessDataServiceHelper.loadSingle((Object)internalOrgId, (String)"bos_org", (String)"id");
                if (EmptyUtil.isNoEmpty((DynamicObject)internalOrg)) {
                    filterIsElec = "1";
                }
            } else if (AsstActTypeEnum.COMPANY.getValue().equals(payeeType)) {
                filterIsElec = "1";
            }
        }
        filters.add(new QFilter("iselecpayment", "=", (Object)filterIsElec));
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                this.btnOk();
            }
        }
    }

    private void btnOk() {
        String showTab = (String)this.getModel().getValue("showtab");
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        if ("1".equalsIgnoreCase(showTab)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows != null && selectedRows.size() > 0) {
                returnData.put("entity", "am_accountbank");
                ListSelectedRow row = selectedRows.get(0);
                returnData.put("id", row.getPrimaryKeyValue());
            }
        } else if ("2".equalsIgnoreCase(showTab)) {
            Object entryId;
            FormShowParameter fsp = this.getView().getFormShowParameter();
            Boolean isCustomer = (Boolean)fsp.getCustomParam("isCustomer");
            String entityName = "";
            if (isCustomer.booleanValue()) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("customerentrybank");
                entryId = this.getModel().getValue("entryid", rowIndex);
                entityName = "bd_customer";
            } else {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("supplierentrybank");
                entryId = this.getModel().getValue("sentryid", rowIndex);
                entityName = "bd_supplier";
            }
            returnData.put("id", entryId);
            returnData.put("entity", entityName);
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void tabSelected(TabSelectEvent event) {
        String subTabKey = event.getTabKey();
        String value = "1";
        switch (subTabKey) {
            case "accountbanktab": {
                value = "1";
                break;
            }
            case "entrybanktab": {
                value = "2";
            }
        }
        this.getModel().setValue("showtab", (Object)value);
    }
}

