/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FundFlowItemListPlugin
extends AbstractTreeListPlugin
implements ItemClickListener,
TreeNodeClickListener {
    protected ITreeListView treeListView;
    private ITreeModel treeModel;
    private static final String IS_ENABLE_CALLBACK = "isEnableCallBack";
    private static final String IS_DISABLE_CALLBACK = "isDisableCallBack";
    private static final String IS_DELETE_CALLBACK = "isDeleteCallBack";
    private List<Long> childItems = new ArrayList<Long>();

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tblenable", "tbldisables", "tbldels"});
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        String key = e.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "tblenable": {
                e.setCancel(true);
                if (this.isHaveChildren()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u7684\u8d44\u91d1\u7528\u9014\u542f\u7528\uff0c\u5c06\u4f1a\u5bfc\u81f4\u5f53\u524d\u8bb0\u5f55\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u8d44\u91d1\u7528\u9014\u5168\u90e8\u542f\u7528\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FundFlowItemListPlugin_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_ENABLE_CALLBACK, (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("enable");
                break;
            }
            case "tbldisables": {
                e.setCancel(true);
                if (this.isHaveChildren()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u7684\u8d44\u91d1\u7528\u9014\u7981\u7528\uff0c\u5c06\u4f1a\u5bfc\u81f4\u5f53\u524d\u8bb0\u5f55\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u8d44\u91d1\u7528\u9014\u5168\u90e8\u7981\u7528\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FundFlowItemListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_DISABLE_CALLBACK, (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("disable");
                break;
            }
            case "tbldels": {
                e.setCancel(true);
                if (this.isHaveChildren()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u7684\u8d44\u91d1\u7528\u9014\u5220\u9664\uff0c\u5c06\u4f1a\u5bfc\u81f4\u5f53\u524d\u8bb0\u5f55\u53ca\u5176\u6240\u6709\u4e0b\u7ea7\u8d44\u91d1\u7528\u9014\u5168\u90e8\u5220\u9664\uff0c\u8bf7\u95ee\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FundFlowItemListPlugin_2", (String)"fi-cas-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(IS_DELETE_CALLBACK, (IFormPlugin)this));
                    break;
                }
                this.getView().invokeOperation("delete");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals(IS_ENABLE_CALLBACK)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("enable");
            } else if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                return;
            }
        }
        if (callBackId.equals(IS_DISABLE_CALLBACK)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("disable");
            } else if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                return;
            }
        }
        if (callBackId.equals(IS_DELETE_CALLBACK)) {
            if (mbce.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getView().invokeOperation("delete");
            } else if (mbce.getResult().equals((Object)MessageBoxResult.Cancel)) {
                return;
            }
        }
    }

    private boolean isHaveChildren() {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        ArrayList<Long> idpk = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            idpk.add(Long.valueOf(rows.get(i).getPrimaryKeyValue().toString()));
        }
        QFilter df = new QFilter("parent", "in", idpk);
        QFilter[] filters = new QFilter[]{df};
        return QueryServiceHelper.exists((String)"cas_fundflowitem", (QFilter[])filters);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object node;
        super.beforeShowBill(e);
        this.getTreeListView().refreshTreeView();
        if (this.getTreeModel() != null && e.getParameter().getStatus() == OperationStatus.ADDNEW && (node = this.treeModel.getCurrentNodeId()) != null && node.toString().compareTo(this.treeModel.getRoot().getId()) != 0) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_fundflowitem");
            JSONObject parentFFItem = new JSONObject();
            DynamicObject queryitem = new DynamicObject((DynamicObjectType)entityType);
            queryitem = QueryServiceHelper.queryOne((String)"cas_fundflowitem", (String)"id,number,name,level,direction,property,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(this.treeModel.getCurrentNodeId().toString()))});
            parentFFItem.put("id", (Object)queryitem.getLong("id"));
            parentFFItem.put("number", (Object)queryitem.getString("number"));
            parentFFItem.put("name", (Object)queryitem.getString("name"));
            parentFFItem.put("level", (Object)queryitem.getInt("level"));
            parentFFItem.put("direction", (Object)queryitem.getString("direction"));
            parentFFItem.put("property", (Object)queryitem.getString("property"));
            parentFFItem.put("enable", (Object)queryitem.getString("enable"));
            if ("0".equals(queryitem.getString("enable"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u8282\u70b9\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u9009\u62e9\u542f\u7528\u72b6\u6001\u7684\u8d44\u91d1\u7528\u9014\u3002", (String)"FundFlowItemListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "refreshRightList");
            e.getParameter().setCloseCallBack(callBack);
            e.getParameter().setCustomParam("parentFFItem", (Object)parentFFItem);
        }
        BillShowParameter billShowParameter = e.getParameter();
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.Modal);
        billShowParameter.setOpenStyle(style);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("refreshRightList".equalsIgnoreCase(e.getActionId())) {
            TreeView treeview = (TreeView)this.getControl("treeview");
            String selectedNode = null;
            if (treeview.getTreeState().getFocusNodeId() != null) {
                selectedNode = treeview.getTreeState().getFocusNodeId();
                if (selectedNode != null) {
                    this.showAllChildList(selectedNode);
                    this.getTreeListView().refresh();
                } else {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = (String)e.getNodeId();
        if (!nodeId.equals(this.getTreeModel().getRoot().getId())) {
            List<Long> lstChildOrgs = this.getAllChildNodeID(nodeId);
            QFilter f1 = new QFilter("id", "in", lstChildOrgs);
            e.addQFilter(f1);
            e.setCancel(true);
        }
    }

    private List<Long> getAllChildNodeID(String parentID) {
        this.lockOrgUtil(parentID);
        this.childItems.add(Long.valueOf(parentID));
        return this.childItems;
    }

    private void lockOrgUtil(String parentID) {
        DynamicObjectCollection col = QueryServiceHelper.query((String)"fundflowitem", (String)"cas_fundflowitem", (String)"id,parent", null, null);
        for (DynamicObject dynamicObject : col) {
            String par = dynamicObject.get("parent") + "";
            if (!parentID.equals(par)) continue;
            String par1 = dynamicObject.get("id") + "";
            this.getAllChildNodeID(par1);
            this.childItems.add((Long)dynamicObject.get("id"));
        }
    }

    private void showAllChildList(String parentID) {
        if (!parentID.equals(this.getTreeModel().getRoot().getId())) {
            List<Long> lstChildOrgs = this.getAllChildNodeID(parentID);
            QFilter f1 = new QFilter("id", "in", lstChildOrgs);
            FilterParameter fParameter = new FilterParameter();
            fParameter.setFilter(f1);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            AbstractGrid.GridState gridState = billList.getEntryState();
            gridState.put("selDatas", null);
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put("currentListSelectedRowCollection", (String)null);
            billList.setQueryFilterParameter(fParameter);
            billList.refresh();
        }
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.getTreeModel().getRoot().setText(ResManager.loadKDString((String)"\u8d44\u91d1\u7528\u9014", (String)"FundFlowItemListPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
    }

    protected ITreeModel getTreeModel() {
        this.treeModel = super.getTreeModel();
        return this.treeModel;
    }
}

