/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;

public class GenerateVoucherPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(GenerateVoucherPlugin.class);
    private static final String VOUCHERNUM = "vouchernum";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new GetListDataProvider());
    }

    protected static class GetListDataProvider
    extends ListDataProvider {
        private boolean isSelectedAllRows;

        protected GetListDataProvider() {
        }

        protected void setSelectedAllRows(boolean isSelectedAllRows) {
            this.isSelectedAllRows = isSelectedAllRows;
            super.setSelectedAllRows(isSelectedAllRows);
        }

        protected boolean isOnlyPK4SelectedAllRows() {
            return true;
        }

        private List<ListField> getBillNoFields(List<ListField> listFieldList) {
            return listFieldList.stream().filter(x -> x.getFieldName() != null && x.getFieldName().contains("billno")).collect(Collectors.toList());
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows;
            if (this.isCustomListDataProvider() && this.isSelectedAllRows && this.isOnlyPK4SelectedAllRows()) {
                List pkFields = this.getPKFields();
                pkFields.addAll(this.getBillNoFields(this.getListFields()));
                this.setPKFields(pkFields);
            }
            if ((rows = super.getData(arg0, arg1)).isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                if (!row.getDataEntityType().getProperties().containsKey((Object)"draftbill")) continue;
                DynamicObjectCollection draftbills = row.getDynamicObjectCollection("draftbill");
                ArrayList<String> draftNo = new ArrayList<String>(20);
                if (draftbills == null || draftbills.size() <= 0) continue;
                for (DynamicObject draftbill : draftbills) {
                    DynamicObject draft = draftbill.getDynamicObject("fbasedataid");
                    draftNo.add(draft != null ? draft.getString("draftbillno") : "");
                }
                String draftNoStr = String.join((CharSequence)",", draftNo);
                draftNoStr = draftNoStr == null || draftNoStr.length() < 2000 ? draftNoStr : draftNoStr.substring(0, 1999);
                row.set("settletnumber", (Object)draftNoStr);
            }
            return rows;
        }
    }
}

