/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.cas.formplugin.PayerInfoEdit;
import kd.fi.cas.formplugin.common.DynamicFormPlugin;

public class OpenOrgHandle {
    private DynamicFormPlugin from;

    public OpenOrgHandle(DynamicFormPlugin from) {
        this.from = from;
    }

    public void setOpenOrg() {
        Map companyByOrg;
        DynamicObject org = (DynamicObject)this.from.getValue("org");
        if (org != null && null != (companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()))) && companyByOrg.size() > 0) {
            this.from.setValue("openorg", companyByOrg.get("id"));
            return;
        }
        boolean isSetValue = this.openOrgHandle(acct -> this.from.setValue("openorg", acct.getString("id")));
        if (isSetValue) {
            return;
        }
        this.from.setValue("openorg", null);
    }

    public void fillOpenOrg(BasedataEdit orgF7) {
        DynamicObjectCollection dCollection;
        HashSet<Long> setOrgIds = new HashSet<Long>(10);
        DynamicObject org = (DynamicObject)this.from.getValue("org");
        if (this.isOpenOrg(org)) {
            setOrgIds.add(org.getLong("id"));
        }
        if ((dCollection = this.getOrgRelation(org)) != null && dCollection.size() > 0) {
            for (DynamicObject obj : dCollection) {
                setOrgIds.add(obj.getLong("fromorg"));
            }
        }
        this.openOrgHandle(openorg -> setOrgIds.add(openorg.getLong("id")));
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", (Object)setOrgIds);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private boolean openOrgHandle(Consumer<DynamicObject> consumer) {
        DynamicObject openorg;
        String accountField = this.from instanceof PayerInfoEdit ? "payeracctbank" : "accountbank";
        DynamicObject acct = (DynamicObject)this.from.getValue(accountField);
        if (acct != null && this.isOpenOrg(openorg = (acct = BusinessDataServiceHelper.loadSingle((Object)acct.get("id"), (String)acct.getDataEntityType().getName())).getDynamicObject("openorg"))) {
            consumer.accept(openorg);
            return true;
        }
        return false;
    }

    public DynamicObjectCollection getOrgRelation(DynamicObject org) {
        if (org == null) {
            return null;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("fromtype", "=", (Object)"10"), new QFilter("totype", "=", (Object)"08")};
        DynamicObject relation = QueryServiceHelper.queryOne((String)"bos_org_typerelation", (String)"id", (QFilter[])qFilters);
        DynamicObjectCollection relationCol = null;
        if (relation != null && org != null) {
            qFilters = new QFilter[]{new QFilter("typerelation", "=", relation.get("id")), new QFilter("toorg", "=", org.get("id"))};
            relationCol = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg", (QFilter[])qFilters);
        }
        return relationCol;
    }

    public boolean isOpenOrg(DynamicObject org) {
        if (org == null) {
            return false;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", org.get("id"))};
        if ((org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fisaccounting", (QFilter[])qFilters)) == null) {
            return false;
        }
        return org.getBoolean("fisaccounting");
    }
}

