/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.cas.builder.FormulaGetHandle;
import kd.fi.cas.builder.ISingleTaskContext;
import kd.fi.cas.builder.SingleTaskContext;
import kd.fi.cas.business.helper.LinkagePaymentHelper;
import kd.fi.cas.enums.TransTypeEnum;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayAcceptanceBotpConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(PayAcceptanceBotpConvertPlugin.class);

    public void afterConvert(AfterConvertEventArgs e) {
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        String billType = this.getTgtMainType().getBillType();
        ExtendedDataEntity[] billDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        List<Object> pkValues = Arrays.stream(billDataEntities).map(o -> ((DynamicProperty)e.getFldProperties().get("id")).getValue(((List)o.getValue("ConvertSource")).get(0))).collect(Collectors.toList());
        DynamicObject[] casPayBillObjects = BusinessDataServiceHelper.load((Object[])pkValues.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        Map idToObj = Arrays.stream(casPayBillObjects).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        Map idToIsIfm = PayBillCrossHelper.batchIsIfmAcc(Arrays.asList(casPayBillObjects), (String)"payeeacctbank");
        Map<Object, Long> idToInnerAccId = Arrays.stream(casPayBillObjects).filter(o -> o.getDynamicObject("inneraccount") != null).collect(Collectors.toMap(o -> o.getPkValue(), o -> o.getDynamicObject("inneraccount").getLong("id")));
        Map accIdToOrgId = PayBillCrossHelper.batchGetSettleCenterOrgIdByBankAcct(idToInnerAccId.values());
        QFilter qFilterOrgId = new QFilter("id", "in", accIdToOrgId.values());
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])qFilterOrgId.toArray());
        Map orgIdToOrg = Arrays.stream(orgs).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        Map<Object, Long> idToPayerAccId = Arrays.stream(casPayBillObjects).filter(o -> o.getDynamicObject("payeracctbank") != null).collect(Collectors.toMap(o -> o.getPkValue(), o -> o.getDynamicObject("payeracctbank").getLong("id")));
        Map payerAccIdToOrgId = PayBillCrossHelper.batchGetSettleCenterOrgIdByBankAcct(idToPayerAccId.values());
        QFilter qFilterPayerOrgId = new QFilter("id", "in", payerAccIdToOrgId.values());
        DynamicObject[] payerOrgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])qFilterPayerOrgId.toArray());
        Map payerOrgIdToOrg = Arrays.stream(payerOrgs).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (ExtendedDataEntity billDataEntity : billDataEntities) {
            DynamicObject settleCenterObject;
            Long settleCenter;
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            Object pkValue = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject casPayBillObject = (DynamicObject)idToObj.get(pkValue);
            boolean isInnerAcc = (Boolean)idToIsIfm.get(pkValue);
            if (isInnerAcc) {
                billDataEntity.setValue("transtype", (Object)TransTypeEnum.INNER_TRANSFER.getValue());
            } else {
                billDataEntity.setValue("transtype", (Object)TransTypeEnum.INNER_AGENT_PAY.getValue());
            }
            boolean isLinkagePayment = LinkagePaymentHelper.isLinkagePayment((DynamicObject)casPayBillObject);
            if (isLinkagePayment) {
                DynamicObject bank;
                billDataEntity.setValue("transtype", (Object)TransTypeEnum.INNER_LINKAGE_PAY.getValue());
                settleCenter = (Long)accIdToOrgId.get(idToInnerAccId.get(pkValue));
                settleCenterObject = (DynamicObject)orgIdToOrg.get(settleCenter);
                billDataEntity.getDataEntity().set("scorg", (Object)settleCenterObject);
                DynamicObject parentacct = casPayBillObject.getDynamicObject("parentacct");
                billDataEntity.getDataEntity().set("agentpayeraccount", (Object)parentacct);
                Optional<DynamicObject> type = Optional.ofNullable(parentacct).map(b -> b.getDynamicObject("bank"));
                if (type.isPresent() && (bank = BusinessDataServiceHelper.loadSingle((Object)type.get().getPkValue(), (String)"bd_finorginfo", (String)"id,bank_cate")) != null) {
                    billDataEntity.getDataEntity().set("agentfinorgcat", (Object)bank.getDynamicObject("bank_cate"));
                }
            } else {
                settleCenter = (Long)payerAccIdToOrgId.get(idToPayerAccId.get(pkValue));
                settleCenterObject = (DynamicObject)payerOrgIdToOrg.get(settleCenter);
                billDataEntity.getDataEntity().set("scorg", (Object)settleCenterObject);
            }
            billDataEntity.setValue("sourcebillid", pkValue);
            billDataEntity.setValue("sbilltype", (Object)billType);
            billDataEntity.setValue("sourcebilltype", (Object)"cas_paybill");
            this.fillProxyBebankactno(casPayBillObject, billDataEntity);
            DynamicObject agentPayerAccount = (DynamicObject)billDataEntity.getValue("agentpayeraccount");
            if (agentPayerAccount == null || !EmptyUtil.isNoEmpty((DynamicObject)agentPayerAccount)) continue;
            agentPayerAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)agentPayerAccount.getPkValue(), (String)"bd_accountbanks");
            DynamicObject bankObject = agentPayerAccount.getDynamicObject("bank");
            Long bankId = (Long)bankObject.getPkValue();
            bankObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bankId, (String)"bd_finorginfo");
            DynamicObject bankCateObject = bankObject.getDynamicObject("bank_cate");
            billDataEntity.getDataEntity().set("agentfinorg", (Object)bankObject);
            billDataEntity.getDataEntity().set("agentfinorgcat", (Object)bankCateObject);
        }
    }

    private void fillProxyBebankactno(DynamicObject casPayBillObject, ExtendedDataEntity billDataEntity) {
        DynamicObject e_parentacct;
        boolean isInnerBank = false;
        DynamicObject defaultRule = null;
        DynamicObject payeraAcctBank = casPayBillObject.getDynamicObject("payeracctbank");
        Long payeraAcctBankId = payeraAcctBank.getLong("id");
        Long bankId = payeraAcctBank.getDynamicObject("bank").getLong("id");
        DynamicObject bank = BusinessDataServiceHelper.loadSingle((Object)bankId, (String)"bd_finorginfo");
        DynamicObject finorgType = bank.getDynamicObject("finorgtype");
        String type = finorgType.getString("type");
        if ("1".equals(type)) {
            isInnerBank = true;
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        if (isInnerBank) {
            qFilter.and("entryentity.e_internalacct", "=", (Object)payeraAcctBankId);
        } else {
            qFilter.and("entryentity.e_account", "=", (Object)payeraAcctBankId);
        }
        Object[] linkPayRelations = BusinessDataServiceHelper.load((String)"am_linkpayrelation", (String)"entryentity,entryentity.e_account,entryentity.e_internalacct,entryentity.e_parentacct,entryentity.e_bank,entryentity.e_default,entryentity.e_datafilter,entryentity.e_datafilter_tag", (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])linkPayRelations)) {
            return;
        }
        for (Object linkPayRelation : linkPayRelations) {
            DynamicObjectCollection entries = linkPayRelation.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject e_parentacct2;
                String dataFilter;
                boolean isMatchRule;
                boolean e_default;
                if (isInnerBank) {
                    Long internalacctId;
                    DynamicObject e_internalacct = entry.getDynamicObject("e_internalacct");
                    if (e_internalacct == null || !(internalacctId = Long.valueOf(e_internalacct.getLong("id"))).equals(payeraAcctBankId)) continue;
                    e_default = entry.getBoolean("e_default");
                    if (e_default) {
                        defaultRule = entry;
                    }
                } else {
                    Long accountId;
                    DynamicObject e_account = entry.getDynamicObject("e_account");
                    if (e_account == null || !(accountId = Long.valueOf(e_account.getLong("id"))).equals(payeraAcctBankId)) continue;
                    e_default = entry.getBoolean("e_default");
                    if (e_default) {
                        defaultRule = entry;
                    }
                }
                if (!(isMatchRule = this.matchRuleBill(dataFilter = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entry.getString("e_datafilter")) ? entry.getString("e_datafilter") : entry.getString("e_datafilter_tag"), casPayBillObject)) || (e_parentacct2 = entry.getDynamicObject("e_parentacct")) == null) continue;
                billDataEntity.getDataEntity().set("agentpayeraccount", (Object)e_parentacct2);
                logger.info("\u8bbe\u7f6e\u4ed8\u6b3e\u4ee3\u7406\u8d26\u53f7agentpayeraccount\uff0c\u662f\u5426\u5185\u90e8\u8d26\u6237\uff1a" + isInnerBank + ";\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u652f\u4ed8\u5173\u7cfb\u7ef4\u62a4:" + linkPayRelation.getString("number") + "");
                return;
            }
        }
        if (defaultRule != null && (e_parentacct = defaultRule.getDynamicObject("e_parentacct")) != null) {
            billDataEntity.getDataEntity().set("agentpayeraccount", (Object)e_parentacct);
            logger.info("\u8bbe\u7f6e\u4ed8\u6b3e\u4ee3\u7406\u8d26\u53f7agentpayeraccount\uff0c\u662f\u5426\u5185\u90e8\u8d26\u6237\uff1a" + isInnerBank + ";\u672a\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u652f\u4ed8\u5173\u7cfb\u7ef4\u62a4\uff0c\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u9ed8\u8ba4\u7684\u5206\u5f55\uff0c\u5206\u5f55id:" + defaultRule.getPkValue() + "");
            return;
        }
        logger.info("\u7ed3\u675f\u8bbe\u7f6e\u4ed8\u6b3e\u4ee3\u7406\u8d26\u53f7agentpayeraccount\uff0c\u662f\u5426\u5185\u90e8\u8d26\u6237\uff1a" + isInnerBank + ";\u672a\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u652f\u4ed8\u5173\u7cfb\u7ef4\u62a4\uff0c\u4e14\u4e5f\u6ca1\u5339\u914d\u4e0a\u5bf9\u5e94\u7684\u9ed8\u8ba4\u7684\u5206\u5f55");
    }

    public boolean matchRuleBill(String filterStr, DynamicObject detailDy) {
        Map<String, DynamicProperty> fldProperties = PayAcceptanceBotpConvertPlugin.getFilterProperties(detailDy);
        boolean isMatchRule = false;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (!"".equals(baseFilterStr)) {
                FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                boolean baseBoolean = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, detailDy, null);
                if (baseBoolean) {
                    isMatchRule = true;
                }
            } else {
                isMatchRule = true;
            }
        } else {
            isMatchRule = true;
        }
        return isMatchRule;
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"cas_paybill");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)property.getAlias()) || propName.contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }
}

