/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.cas.business.ebank.impl.EBankExcelFileCreateImpl;
import kd.fi.cas.business.ebank.impl.EBankTxTFileCreateImpl;
import kd.fi.cas.consts.ExportHeader;
import kd.fi.cas.consts.FetchDataReponse;
import kd.fi.cas.consts.FetchDataRequest;
import kd.fi.cas.helper.AppLogHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PayBillExportFilesList
extends AbstractListPlugin {
    private static final int maxLength = 50;
    private static Log logger = LogFactory.getLog(PayBillExportFilesList.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "exportfiles": {
                this.exportFiles();
            }
        }
    }

    private void exportFiles() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() <= 0) {
            return;
        }
        ListShowParameter createShowListForm = ShowFormHelper.createShowListForm((String)"fbd_export_template", (boolean)false);
        List filters = createShowListForm.getListFilterParameter().getQFilters();
        QFilter qf = new QFilter("bizobject.number", "=", (Object)"cas_paybill");
        qf.and(new QFilter("enable", "=", (Object)"1"));
        if (null != filters) {
            filters.add(qf);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "exportfiles");
        createShowListForm.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)createShowListForm);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"exportfiles")) {
            String errMsg;
            InputStream txtFileInStream;
            String fileName;
            EBankTxTFileCreateImpl fileCreate;
            HashSet<Long> idSet = new HashSet<Long>(primaryKeyValues.length);
            for (Object id : primaryKeyValues) {
                idSet.add((Long)id);
            }
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            Long returnId = (Long)returnData.getPrimaryKeyValues()[0];
            String formName = "cas_paybill";
            FetchDataRequest fetchDataRequest = new FetchDataRequest();
            fetchDataRequest.setBillNo(formName);
            fetchDataRequest.setIdSet(idSet);
            fetchDataRequest.setTemplateId(returnId);
            String fetchDataResponse = (String)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbp", (String)"eBankFetchValueHelper", (String)"exportData", (Object[])new Object[]{SerializationUtils.toJsonString((Object)fetchDataRequest)});
            FetchDataReponse responseData = (FetchDataReponse)SerializationUtils.fromJsonString((String)fetchDataResponse, FetchDataReponse.class);
            ExportHeader header = responseData.getHeader();
            this.orderBodyBySelectRows(selectedRows, responseData);
            String type = header.getExportType();
            String url = null;
            if (type.equals("txt")) {
                fileCreate = new EBankTxTFileCreateImpl(this.getView(), "cas_paybill");
                fileName = fileCreate.getTemporaryFilename("cas_paybill", ".txt");
                try {
                    txtFileInStream = fileCreate.createFileContent(responseData, new Object[0]);
                    url = fileCreate.writeTemporaryFile(txtFileInStream, fileName);
                }
                catch (Exception e) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u751f\u6210 TXT \u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"InternetBankExport_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
                    InputStream txtFileInStream2 = fileCreate.createFileContent(errMsg);
                    try {
                        url = fileCreate.writeTemporaryFile(txtFileInStream2, fileName);
                    }
                    catch (IOException ex) {
                        throw new KDBizException(ex.getMessage());
                    }
                }
            } else if (type.equals("xls")) {
                fileCreate = new EBankExcelFileCreateImpl(this.getView(), "cas_paybill");
                fileName = fileCreate.getTemporaryFilename("cas_paybill", ".xlsx");
                try {
                    txtFileInStream = fileCreate.createFileContent(responseData, new Object[]{ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u7f51\u94f6\u5bfc\u51fa\u6570\u636e", (String)"PayBillExportFilesList_0", (String)"fi-cas-formplugin", (Object[])new Object[0])});
                    url = fileCreate.writeTemporaryFile(txtFileInStream, fileName);
                }
                catch (Exception e) {
                    errMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u751f\u6210EXCEL \u6587\u4ef6\u5931\u8d25\uff1a%s\u3002", (String)"InternetBankExport_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), ExceptionUtils.getStackTrace((Throwable)e));
                    InputStream txtFileInStream3 = fileCreate.createFileContent(errMsg);
                    try {
                        url = fileCreate.writeTemporaryFile(txtFileInStream3, fileName);
                    }
                    catch (IOException ex) {
                        throw new KDBizException(ex.getMessage());
                    }
                }
            }
            this.getView().download(url);
            Map failureDatas = responseData.getBody().getFailureDatas();
            MultiLangEnumBridge opDesc = AppLogHelper.buildMultiLangBridge((String)"\u672c\u6b21\u5bfc\u51fa\u5171%1$s\u6761\uff0c\u5176\u4e2d\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\u3002", (String)"PayBillExportFilesList_1", (String)"fi-cas-formplugin");
            MultiLangEnumBridge opNameBridge = AppLogHelper.buildMultiLangBridge((String)"\u5bfc\u51fa\u7f51\u94f6\u6587\u4ef6", (String)"PayBillExportFilesList_2", (String)"fi-cas-formplugin");
            AppLogInfo appLogInfo = AppLogHelper.createAppLog((String)"cas_paybill", (long)RequestContext.get().getOrgId(), (String)"exportfiles", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDesc, (Object[])new Object[]{selectedRows.size(), selectedRows.size() - failureDatas.size(), failureDatas.size()});
            LogServiceHelper.addLog((AppLogInfo)appLogInfo);
        }
    }

    private void orderBodyBySelectRows(ListSelectedRowCollection selectedRows, FetchDataReponse responseData) {
        if (EmptyUtil.isEmpty((Object)responseData) || EmptyUtil.isEmpty((Object)responseData.getBody()) || EmptyUtil.isEmpty((Object)responseData.getBody().getDetails()) || EmptyUtil.isEmpty(responseData.getBody().getDetails().get("body"))) {
            return;
        }
        Map bodyMap = (Map)responseData.getBody().getDetails().get("body");
        LinkedHashMap orderBodyMap = new LinkedHashMap(bodyMap.size());
        selectedRows.forEach(listSelectedRow -> {
            Long selectId = (Long)listSelectedRow.getPrimaryKeyValue();
            if (bodyMap.containsKey(selectId)) {
                orderBodyMap.put(selectId, bodyMap.get(selectId));
            }
        });
        bodyMap.clear();
        bodyMap.putAll(orderBodyMap);
    }
}

