/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.PayBusinessTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.DcepConverHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayInfoChgPlugin
extends AbstractBillPlugIn {
    private static final String KEY_CHANGECHG_CALLBACK = "KEY_CHANGECHG_CALLBACK";
    private static final String[] operationArr = new String[]{"save", "submit", "unsubmit", "audit", "unaudit", "delete", "confirm", "autoconfirm"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"hide"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String curAppId = this.getView().getFormShowParameter().getAppId();
        if (curAppId != null && curAppId.equals("tr")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"barconfirm"});
        }
        this.setBusinessTypeAndFlexVisible();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        Object id = this.getModel().getDataEntity().getPkValue();
        boolean isAllowOperation = Arrays.stream(operationArr).anyMatch(o -> o.equalsIgnoreCase(key));
        if (isAllowOperation && EmptyUtil.isNoEmpty((Object)id)) {
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            QFilter filter = new QFilter("applyuser", "=", (Object)userPK).or(new QFilter("alterationuser", "=", (Object)userPK));
            DynamicObjectCollection queryData = QueryServiceHelper.query((String)"cas_paychgbill", (String)"id", (QFilter[])filter.toArray());
            if (queryData != null && queryData.size() > 0) {
                Set idSet = queryData.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
                if (!idSet.contains(id)) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d8\u66f4\u4eba\u6216\u53d8\u66f4\u7533\u8bf7\u4eba\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PayInfoChgList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d8\u66f4\u4eba\u6216\u53d8\u66f4\u7533\u8bf7\u4eba\u624d\u80fd\u64cd\u4f5c\u3002", (String)"PayInfoChgList_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("deliver".equals(key)) {
            DynamicObject paychgbill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"cas_paychgbill", (String)"id,chgtype,billstatus,sourcebillid");
            if (!"A".equals(paychgbill.get("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8f6c\u4ea4\u6682\u5b58\u7684\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u6570\u636e\u3002", (String)"PayInfoChgList_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return;
            }
            Object sourceId = this.getModel().getValue("sourcebillid");
            Object sourceType = this.getModel().getValue("sourcetype");
            FormShowParameter showParameter = new FormShowParameter();
            StyleCss css = new StyleCss();
            css.setWidth("700");
            css.setHeight("400");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.setCustomParam("id", id);
            showParameter.setCustomParam("sourceId", sourceId);
            showParameter.setCustomParam("sourceType", sourceType);
            showParameter.setFormId("cas_paychgdeliver");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CHANGECHG_CALLBACK));
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (KEY_CHANGECHG_CALLBACK.equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
            Map data = (Map)e.getReturnData();
            if (null != data && null != data.get("messageId")) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u4ea4\u6210\u529f", (String)"PayInfoChgList_3", (String)"fi-cas-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("hide".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_dcepinfo"});
        }
    }

    private void setBusinessTypeAndFlexVisible() {
        boolean isShow = false;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entrys", 0);
        if (entryRowEntity == null) {
            return;
        }
        DynamicObject settleType = entryRowEntity.getDynamicObject("settletype");
        String businessType = entryRowEntity.getString("businesstype");
        boolean isDcep = BaseDataHelper.isSettleTypeDcep((DynamicObject)settleType);
        if (isDcep) {
            isShow = true;
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"businesstype"});
        this.getView().setVisible(Boolean.valueOf(isShow && PayBusinessTypeEnum.WALLETTRANSFER.getValue().equals(businessType)), new String[]{"flex_dcepinfo"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        int rowIdx = e.getChangeSet()[0].getRowIndex();
        switch (fieldKey) {
            case "chgpayeeaccbank": 
            case "afterpayeracctbank": {
                DynamicObject acct = (DynamicObject)newValue;
                if (EmptyUtil.isNoEmpty((DynamicObject)acct)) {
                    String institutionCode = DcepConverHelper.getInstitUtionCode((DynamicObject)acct);
                    String institutionName = DcepConverHelper.getInstitutionName((DynamicObject)acct);
                    this.getModel().setValue("afterinstitutioncode", (Object)institutionCode, rowIdx);
                    this.getModel().setValue("afterinstitutionname", (Object)institutionName, rowIdx);
                    break;
                }
                this.getModel().setValue("afterinstitutioncode", null, rowIdx);
                this.getModel().setValue("afterinstitutionname", null, rowIdx);
                break;
            }
        }
    }
}

