/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayWarningEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7ClickListeners();
    }

    public void addF7ClickListeners() {
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            int rowCount = this.getModel().getEntryRowCount("entry");
            ArrayList<Long> selectedOrgPks = new ArrayList<Long>();
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject entryOrg;
                if (i == rowIndex || (entryOrg = (DynamicObject)this.getModel().getValue("org", i)) == null) continue;
                selectedOrgPks.add((Long)entryOrg.getPkValue());
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            appId = EmptyUtil.isNotEmpty((String)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
            Set idList = OrgHelper.getAuthBankOrgIds((Long)userId, (String)appId, (String)"cas_paywarnset", (String)"47156aff000000ac");
            for (Long pk : selectedOrgPks) {
                idList.remove(pk);
            }
            QFilter qFilter = new QFilter("id", "in", (Object)idList);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    public void afterLoadData(EventObject e) {
        Object entryOrg;
        super.afterLoadData(e);
        if (this.getModel().getEntryRowCount("entry") == 1 && (entryOrg = this.getModel().getValue("org", 0)) == null) {
            this.getModel().deleteEntryRow("entry", 0);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(key) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
    }
}

