/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimCoreBillTypeEnum;
import kd.fi.cas.formplugin.common.BillEditPlugin;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CoreBillSettingHelper;
import kd.fi.cas.helper.ViewInputHelper;
import kd.fi.cas.util.EmptyUtil;

public class ReceivingBillCoreBillEdit
extends BillEditPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        Object oldValue;
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue == (oldValue = changeData[0].getOldValue())) {
            return;
        }
        if ("e_corebillno".equals(key)) {
            Object newValueObj = e.getChangeSet()[0].getNewValue();
            this.checkChangeData(newValueObj);
        }
    }

    private void checkChangeData(Object newValueObj) {
        if (EmptyUtil.isNoEmpty((Object)newValueObj)) {
            int entryInd = this.getModel().getEntryCurrentRowIndex("entry");
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillid", null, (int)entryInd);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillentryid", null, (int)entryInd);
            ViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"e_corebillentryseq", null, (int)entryInd);
            Object coreBillTypeObj = this.getModel().getValue("e_corebilltype", entryInd);
            if (EmptyUtil.isNoEmpty((Object)coreBillTypeObj)) {
                List coreBillSettings;
                DynamicObject coreBillSetting;
                String coreBillType = (String)coreBillTypeObj;
                String corebillno = (String)newValueObj;
                boolean isMultiReceivingType = (Boolean)this.getModel().getValue("multireceivingtype");
                DynamicObject recPayType = (DynamicObject)this.getModel().getValue("receivingtype");
                boolean isPartReceivable = false;
                if (recPayType != null) {
                    isPartReceivable = recPayType.getBoolean("ispartreceivable");
                }
                if (CasHelper.isNotEmpty((Object)(coreBillSetting = CoreBillSettingHelper.filterCoreBillSetting((List)(coreBillSettings = CoreBillSettingHelper.loadCoreBillSetting((String)"cas_recbill", (boolean)isMultiReceivingType, (boolean)isPartReceivable)), (String)coreBillType)))) {
                    boolean isHandInput = coreBillSetting.getBoolean("handinput");
                    if (isHandInput) {
                        DynamicObject settleorg = (DynamicObject)this.getModel().getValue("e_settleorg", entryInd);
                        if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        Map showParams = CoreBillSettingHelper.dealShowF7CustomParams((DynamicObject)coreBillSetting, (IDataModel)this.getModel(), (boolean)false);
                        showParams.put("billno", corebillno);
                        showParams.put("entitynumber", coreBillType);
                        CoreBillSettingHelper.setCoreBillInfo((DynamicObject)coreBillSetting, (Map)showParams, (IFormView)this.getView(), (int)entryInd, (boolean)false);
                    }
                } else if (coreBillType.equals("ar_finarbill") || coreBillType.equals("sm_salorder") || coreBillType.equals("conm_salcontract") || coreBillType.equals("er_repaymentbill") || coreBillType.equals("fr_glreim_recbill")) {
                    DynamicObject settleorg = (DynamicObject)this.getModel().getValue("e_settleorg", entryInd);
                    if (EmptyUtil.isEmpty((DynamicObject)settleorg)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u7ed3\u7b97\u7ec4\u7ec7", (String)"ClaimHandleEditPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    QFilter billNoFilter = new QFilter("billno", "=", (Object)corebillno);
                    List<QFilter> coreBillFilters = this.getCoreBillFilter(coreBillType, settleorg);
                    coreBillFilters.add(billNoFilter);
                    Object isSelectCoreBillNo = this.getView().getFormShowParameter().getCustomParam("isSelectCoreBillNo");
                    Object[] coreBillColl = BusinessDataServiceHelper.load((String)coreBillType, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)corebillno)});
                    if (EmptyUtil.isNoEmpty((Object[])coreBillColl) && !coreBillType.equals("er_repaymentbill")) {
                        if (ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType) || ClaimCoreBillTypeEnum.SALCONTRACT.getValue().equals(coreBillType)) {
                            if (!"true".equals(isSelectCoreBillNo)) {
                                boolean isSalOrder = ClaimCoreBillTypeEnum.SALORDER.getValue().equals(coreBillType);
                                if (isSalOrder) {
                                    List<String> conGroupFields = Arrays.asList("billentry.conbillnumber", "billentry.conbillrownum", "billentry.conbillid", "billentry.conbillentryid");
                                    QFilter filter = new QFilter("id", "=", (Object)coreBillColl[0].getLong("id"));
                                    DynamicObject queryInfo = QueryServiceHelper.queryOne((String)coreBillType, (String)String.join((CharSequence)",", conGroupFields), (QFilter[])new QFilter[]{filter});
                                    if (queryInfo != null) {
                                        this.getModel().setValue("conbillnumber", (Object)queryInfo.getString("billentry.conbillnumber"), entryInd);
                                    }
                                }
                                this.getModel().setValue("conbillentity", (Object)"conm_salcontract", entryInd);
                                this.getModel().setValue("conbillrownum", (Object)"", entryInd);
                            }
                        } else {
                            this.getModel().setValue("e_corebillid", (Object)coreBillColl[0].getLong("id"), entryInd);
                        }
                    } else if (!"true".equals(isSelectCoreBillNo)) {
                        this.getModel().beginInit();
                        this.getModel().setValue("e_corebillno", null, entryInd);
                        this.getModel().setValue("e_corebillid", null, entryInd);
                        this.getModel().setValue("e_sourcebillentryid", null, entryInd);
                        this.getModel().setValue("e_sourcebillid", null, entryInd);
                        this.getModel().endInit();
                        String message = ResManager.loadKDString((String)"\u5bf9\u5e94\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\u6b64\u6838\u5fc3\u5355\u636e\u53f7\u3002", (String)"ReceivingBillEdit_14", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        if (coreBillType.equals("er_repaymentbill")) {
                            message = ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u4e3a\u8fd8\u6b3e\u5355\u3002\u6838\u5fc3\u5355\u636e\u7f16\u53f7\u4e0d\u5141\u8bb8\u624b\u5de5\u4fee\u6539\u3002", (String)"ReceivingBillCoreBillEdit_0", (String)"fi-cas-formplugin", (Object[])new Object[0]);
                        }
                        this.getView().showTipNotification(message);
                    }
                }
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("e_corebillno", null, entryInd);
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u6838\u5fc3\u5355\u636e\u7c7b\u578b\u3002", (String)"ReceivingBillEdit_15", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<QFilter> getCoreBillFilter(String coreBillType, DynamicObject settleorg) {
        DynamicObject recType;
        boolean isAr;
        Object payer;
        ArrayList<QFilter> list = new ArrayList<QFilter>(8);
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.FINARBILL.getValue())) {
            list.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            list.add(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}));
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALORDER.getValue())) {
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            payer = this.getModel().getValue("payer");
            list.add(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
            list.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptamount < totalallamount ", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.SALCONTRACT.getValue())) {
            list.add(new QFilter("billentry.entrysettleorg", "=", settleorg.getPkValue()));
            payer = this.getModel().getValue("payer");
            list.add(new QFilter("customer", "=", !ObjectUtils.isEmpty((Object)payer) ? payer : Long.valueOf(0L)));
            list.add(new QFilter("validstatus", "<>", (Object)"A"));
            list.add(new QFilter("changestatus", "<>", (Object)"B"));
            list.add(QFilter.of((String)" receiptallamount < totalallamount ", (Object[])new Object[0]));
        }
        if ((isAr = (recType = this.getDynamicObject("receivingtype")).getBoolean("ispartreceivable")) && StringUtils.equals((CharSequence)coreBillType, (CharSequence)ClaimCoreBillTypeEnum.PAYBILL.getValue())) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("paymenttype.ispartpayment", "=", (Object)"1"));
            qFilters.add(new QFilter("dpcurrency", "=", currency.getPkValue()));
            qFilters.add(new QFilter("billstatus", "=", (Object)"D"));
            qFilters.add(new QFilter("entry.settleorg", "=", settleorg.getPkValue()));
            return qFilters;
        }
        return list;
    }
}

